/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent;

import com.oracle.bmc.generativeaiagent.GenerativeAiAgent;
import com.oracle.bmc.generativeaiagent.model.AgentEndpointSummary;
import com.oracle.bmc.generativeaiagent.model.AgentSummary;
import com.oracle.bmc.generativeaiagent.model.DataIngestionJobSummary;
import com.oracle.bmc.generativeaiagent.model.DataSourceSummary;
import com.oracle.bmc.generativeaiagent.model.KnowledgeBaseSummary;
import com.oracle.bmc.generativeaiagent.model.ToolSummary;
import com.oracle.bmc.generativeaiagent.model.WorkRequestError;
import com.oracle.bmc.generativeaiagent.model.WorkRequestLogEntry;
import com.oracle.bmc.generativeaiagent.model.WorkRequestSummary;
import com.oracle.bmc.generativeaiagent.requests.ListAgentEndpointsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListAgentsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListDataIngestionJobsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListDataSourcesRequest;
import com.oracle.bmc.generativeaiagent.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.generativeaiagent.requests.ListToolsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestsRequest;
import com.oracle.bmc.generativeaiagent.responses.ListAgentEndpointsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListAgentsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListDataIngestionJobsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListDataSourcesResponse;
import com.oracle.bmc.generativeaiagent.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.generativeaiagent.responses.ListToolsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class GenerativeAiAgentPaginators {
    private final GenerativeAiAgent client;

    public GenerativeAiAgentPaginators(GenerativeAiAgent client) {
        this.client = client;
    }

    public Iterable<ListAgentEndpointsResponse> listAgentEndpointsResponseIterator(final ListAgentEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAgentEndpointsRequest.Builder>(){

            @Override
            public ListAgentEndpointsRequest.Builder get() {
                return ListAgentEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentEndpointsResponse, String>(){

            @Override
            public String apply(ListAgentEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentEndpointsRequest.Builder>, ListAgentEndpointsRequest>(){

            @Override
            public ListAgentEndpointsRequest apply(RequestBuilderAndToken<ListAgentEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentEndpointsRequest, ListAgentEndpointsResponse>(){

            @Override
            public ListAgentEndpointsResponse apply(ListAgentEndpointsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listAgentEndpoints(request);
            }
        });
    }

    public Iterable<AgentEndpointSummary> listAgentEndpointsRecordIterator(final ListAgentEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAgentEndpointsRequest.Builder>(){

            @Override
            public ListAgentEndpointsRequest.Builder get() {
                return ListAgentEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentEndpointsResponse, String>(){

            @Override
            public String apply(ListAgentEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentEndpointsRequest.Builder>, ListAgentEndpointsRequest>(){

            @Override
            public ListAgentEndpointsRequest apply(RequestBuilderAndToken<ListAgentEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentEndpointsRequest, ListAgentEndpointsResponse>(){

            @Override
            public ListAgentEndpointsResponse apply(ListAgentEndpointsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listAgentEndpoints(request);
            }
        }, (Function)new Function<ListAgentEndpointsResponse, List<AgentEndpointSummary>>(){

            @Override
            public List<AgentEndpointSummary> apply(ListAgentEndpointsResponse response) {
                return response.getAgentEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListAgentsResponse> listAgentsResponseIterator(final ListAgentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAgentsRequest.Builder>(){

            @Override
            public ListAgentsRequest.Builder get() {
                return ListAgentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentsResponse, String>(){

            @Override
            public String apply(ListAgentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentsRequest.Builder>, ListAgentsRequest>(){

            @Override
            public ListAgentsRequest apply(RequestBuilderAndToken<ListAgentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentsRequest, ListAgentsResponse>(){

            @Override
            public ListAgentsResponse apply(ListAgentsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listAgents(request);
            }
        });
    }

    public Iterable<AgentSummary> listAgentsRecordIterator(final ListAgentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAgentsRequest.Builder>(){

            @Override
            public ListAgentsRequest.Builder get() {
                return ListAgentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentsResponse, String>(){

            @Override
            public String apply(ListAgentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentsRequest.Builder>, ListAgentsRequest>(){

            @Override
            public ListAgentsRequest apply(RequestBuilderAndToken<ListAgentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentsRequest, ListAgentsResponse>(){

            @Override
            public ListAgentsResponse apply(ListAgentsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listAgents(request);
            }
        }, (Function)new Function<ListAgentsResponse, List<AgentSummary>>(){

            @Override
            public List<AgentSummary> apply(ListAgentsResponse response) {
                return response.getAgentCollection().getItems();
            }
        });
    }

    public Iterable<ListDataIngestionJobsResponse> listDataIngestionJobsResponseIterator(final ListDataIngestionJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataIngestionJobsRequest.Builder>(){

            @Override
            public ListDataIngestionJobsRequest.Builder get() {
                return ListDataIngestionJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataIngestionJobsResponse, String>(){

            @Override
            public String apply(ListDataIngestionJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataIngestionJobsRequest.Builder>, ListDataIngestionJobsRequest>(){

            @Override
            public ListDataIngestionJobsRequest apply(RequestBuilderAndToken<ListDataIngestionJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataIngestionJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataIngestionJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataIngestionJobsRequest, ListDataIngestionJobsResponse>(){

            @Override
            public ListDataIngestionJobsResponse apply(ListDataIngestionJobsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listDataIngestionJobs(request);
            }
        });
    }

    public Iterable<DataIngestionJobSummary> listDataIngestionJobsRecordIterator(final ListDataIngestionJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataIngestionJobsRequest.Builder>(){

            @Override
            public ListDataIngestionJobsRequest.Builder get() {
                return ListDataIngestionJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataIngestionJobsResponse, String>(){

            @Override
            public String apply(ListDataIngestionJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataIngestionJobsRequest.Builder>, ListDataIngestionJobsRequest>(){

            @Override
            public ListDataIngestionJobsRequest apply(RequestBuilderAndToken<ListDataIngestionJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataIngestionJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataIngestionJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataIngestionJobsRequest, ListDataIngestionJobsResponse>(){

            @Override
            public ListDataIngestionJobsResponse apply(ListDataIngestionJobsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listDataIngestionJobs(request);
            }
        }, (Function)new Function<ListDataIngestionJobsResponse, List<DataIngestionJobSummary>>(){

            @Override
            public List<DataIngestionJobSummary> apply(ListDataIngestionJobsResponse response) {
                return response.getDataIngestionJobCollection().getItems();
            }
        });
    }

    public Iterable<ListDataSourcesResponse> listDataSourcesResponseIterator(final ListDataSourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataSourcesRequest.Builder>(){

            @Override
            public ListDataSourcesRequest.Builder get() {
                return ListDataSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataSourcesResponse, String>(){

            @Override
            public String apply(ListDataSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataSourcesRequest.Builder>, ListDataSourcesRequest>(){

            @Override
            public ListDataSourcesRequest apply(RequestBuilderAndToken<ListDataSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataSourcesRequest, ListDataSourcesResponse>(){

            @Override
            public ListDataSourcesResponse apply(ListDataSourcesRequest request) {
                return GenerativeAiAgentPaginators.this.client.listDataSources(request);
            }
        });
    }

    public Iterable<DataSourceSummary> listDataSourcesRecordIterator(final ListDataSourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataSourcesRequest.Builder>(){

            @Override
            public ListDataSourcesRequest.Builder get() {
                return ListDataSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataSourcesResponse, String>(){

            @Override
            public String apply(ListDataSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataSourcesRequest.Builder>, ListDataSourcesRequest>(){

            @Override
            public ListDataSourcesRequest apply(RequestBuilderAndToken<ListDataSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataSourcesRequest, ListDataSourcesResponse>(){

            @Override
            public ListDataSourcesResponse apply(ListDataSourcesRequest request) {
                return GenerativeAiAgentPaginators.this.client.listDataSources(request);
            }
        }, (Function)new Function<ListDataSourcesResponse, List<DataSourceSummary>>(){

            @Override
            public List<DataSourceSummary> apply(ListDataSourcesResponse response) {
                return response.getDataSourceCollection().getItems();
            }
        });
    }

    public Iterable<ListKnowledgeBasesResponse> listKnowledgeBasesResponseIterator(final ListKnowledgeBasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListKnowledgeBasesRequest.Builder>(){

            @Override
            public ListKnowledgeBasesRequest.Builder get() {
                return ListKnowledgeBasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListKnowledgeBasesResponse, String>(){

            @Override
            public String apply(ListKnowledgeBasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListKnowledgeBasesRequest.Builder>, ListKnowledgeBasesRequest>(){

            @Override
            public ListKnowledgeBasesRequest apply(RequestBuilderAndToken<ListKnowledgeBasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListKnowledgeBasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListKnowledgeBasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse>(){

            @Override
            public ListKnowledgeBasesResponse apply(ListKnowledgeBasesRequest request) {
                return GenerativeAiAgentPaginators.this.client.listKnowledgeBases(request);
            }
        });
    }

    public Iterable<KnowledgeBaseSummary> listKnowledgeBasesRecordIterator(final ListKnowledgeBasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListKnowledgeBasesRequest.Builder>(){

            @Override
            public ListKnowledgeBasesRequest.Builder get() {
                return ListKnowledgeBasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListKnowledgeBasesResponse, String>(){

            @Override
            public String apply(ListKnowledgeBasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListKnowledgeBasesRequest.Builder>, ListKnowledgeBasesRequest>(){

            @Override
            public ListKnowledgeBasesRequest apply(RequestBuilderAndToken<ListKnowledgeBasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListKnowledgeBasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListKnowledgeBasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse>(){

            @Override
            public ListKnowledgeBasesResponse apply(ListKnowledgeBasesRequest request) {
                return GenerativeAiAgentPaginators.this.client.listKnowledgeBases(request);
            }
        }, (Function)new Function<ListKnowledgeBasesResponse, List<KnowledgeBaseSummary>>(){

            @Override
            public List<KnowledgeBaseSummary> apply(ListKnowledgeBasesResponse response) {
                return response.getKnowledgeBaseCollection().getItems();
            }
        });
    }

    public Iterable<ListToolsResponse> listToolsResponseIterator(final ListToolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListToolsRequest.Builder>(){

            @Override
            public ListToolsRequest.Builder get() {
                return ListToolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListToolsResponse, String>(){

            @Override
            public String apply(ListToolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListToolsRequest.Builder>, ListToolsRequest>(){

            @Override
            public ListToolsRequest apply(RequestBuilderAndToken<ListToolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListToolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListToolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListToolsRequest, ListToolsResponse>(){

            @Override
            public ListToolsResponse apply(ListToolsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listTools(request);
            }
        });
    }

    public Iterable<ToolSummary> listToolsRecordIterator(final ListToolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListToolsRequest.Builder>(){

            @Override
            public ListToolsRequest.Builder get() {
                return ListToolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListToolsResponse, String>(){

            @Override
            public String apply(ListToolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListToolsRequest.Builder>, ListToolsRequest>(){

            @Override
            public ListToolsRequest apply(RequestBuilderAndToken<ListToolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListToolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListToolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListToolsRequest, ListToolsResponse>(){

            @Override
            public ListToolsResponse apply(ListToolsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listTools(request);
            }
        }, (Function)new Function<ListToolsResponse, List<ToolSummary>>(){

            @Override
            public List<ToolSummary> apply(ListToolsResponse response) {
                return response.getToolCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GenerativeAiAgentPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

