/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.HttpEndpointAuthScopeConfig;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="httpEndpointAuthScopeConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class HttpEndpointApiKeyAuthScopeConfig
extends HttpEndpointAuthScopeConfig {
    @JsonProperty(value="vaultSecretId")
    private final String vaultSecretId;
    @JsonProperty(value="keyLocation")
    private final KeyLocation keyLocation;
    @JsonProperty(value="keyName")
    private final String keyName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HttpEndpointApiKeyAuthScopeConfig(String vaultSecretId, KeyLocation keyLocation, String keyName) {
        this.vaultSecretId = vaultSecretId;
        this.keyLocation = keyLocation;
        this.keyName = keyName;
    }

    public String getVaultSecretId() {
        return this.vaultSecretId;
    }

    public KeyLocation getKeyLocation() {
        return this.keyLocation;
    }

    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpEndpointApiKeyAuthScopeConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vaultSecretId=").append(String.valueOf(this.vaultSecretId));
        sb.append(", keyLocation=").append(String.valueOf((Object)this.keyLocation));
        sb.append(", keyName=").append(String.valueOf(this.keyName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpEndpointApiKeyAuthScopeConfig)) {
            return false;
        }
        HttpEndpointApiKeyAuthScopeConfig other = (HttpEndpointApiKeyAuthScopeConfig)((Object)o);
        return Objects.equals(this.vaultSecretId, other.vaultSecretId) && Objects.equals((Object)this.keyLocation, (Object)other.keyLocation) && Objects.equals(this.keyName, other.keyName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vaultSecretId == null ? 43 : this.vaultSecretId.hashCode());
        result = result * 59 + (this.keyLocation == null ? 43 : this.keyLocation.hashCode());
        result = result * 59 + (this.keyName == null ? 43 : this.keyName.hashCode());
        return result;
    }

    public static enum KeyLocation implements BmcEnum
    {
        Header("HEADER"),
        QueryParameter("QUERY_PARAMETER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, KeyLocation> map;

        private KeyLocation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static KeyLocation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'KeyLocation', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(KeyLocation.class);
            map = new HashMap<String, KeyLocation>();
            for (KeyLocation v : KeyLocation.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vaultSecretId")
        private String vaultSecretId;
        @JsonProperty(value="keyLocation")
        private KeyLocation keyLocation;
        @JsonProperty(value="keyName")
        private String keyName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vaultSecretId(String vaultSecretId) {
            this.vaultSecretId = vaultSecretId;
            this.__explicitlySet__.add("vaultSecretId");
            return this;
        }

        public Builder keyLocation(KeyLocation keyLocation) {
            this.keyLocation = keyLocation;
            this.__explicitlySet__.add("keyLocation");
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            this.__explicitlySet__.add("keyName");
            return this;
        }

        public HttpEndpointApiKeyAuthScopeConfig build() {
            HttpEndpointApiKeyAuthScopeConfig model = new HttpEndpointApiKeyAuthScopeConfig(this.vaultSecretId, this.keyLocation, this.keyName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HttpEndpointApiKeyAuthScopeConfig model) {
            if (model.wasPropertyExplicitlySet("vaultSecretId")) {
                this.vaultSecretId(model.getVaultSecretId());
            }
            if (model.wasPropertyExplicitlySet("keyLocation")) {
                this.keyLocation(model.getKeyLocation());
            }
            if (model.wasPropertyExplicitlySet("keyName")) {
                this.keyName(model.getKeyName());
            }
            return this;
        }
    }
}

