/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.ApiSchemaInputLocation;
import com.oracle.bmc.generativeaiagent.model.HttpEndpointAuthConfig;
import com.oracle.bmc.generativeaiagent.model.ToolConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="toolConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class HttpEndpointToolConfig
extends ToolConfig {
    @JsonProperty(value="apiSchema")
    private final ApiSchemaInputLocation apiSchema;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="httpEndpointAuthConfig")
    private final HttpEndpointAuthConfig httpEndpointAuthConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HttpEndpointToolConfig(ApiSchemaInputLocation apiSchema, String subnetId, HttpEndpointAuthConfig httpEndpointAuthConfig) {
        this.apiSchema = apiSchema;
        this.subnetId = subnetId;
        this.httpEndpointAuthConfig = httpEndpointAuthConfig;
    }

    public ApiSchemaInputLocation getApiSchema() {
        return this.apiSchema;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public HttpEndpointAuthConfig getHttpEndpointAuthConfig() {
        return this.httpEndpointAuthConfig;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpEndpointToolConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", apiSchema=").append(String.valueOf((Object)this.apiSchema));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", httpEndpointAuthConfig=").append(String.valueOf((Object)this.httpEndpointAuthConfig));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpEndpointToolConfig)) {
            return false;
        }
        HttpEndpointToolConfig other = (HttpEndpointToolConfig)((Object)o);
        return Objects.equals((Object)this.apiSchema, (Object)other.apiSchema) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals((Object)this.httpEndpointAuthConfig, (Object)other.httpEndpointAuthConfig) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apiSchema == null ? 43 : this.apiSchema.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.httpEndpointAuthConfig == null ? 43 : this.httpEndpointAuthConfig.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="apiSchema")
        private ApiSchemaInputLocation apiSchema;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="httpEndpointAuthConfig")
        private HttpEndpointAuthConfig httpEndpointAuthConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder apiSchema(ApiSchemaInputLocation apiSchema) {
            this.apiSchema = apiSchema;
            this.__explicitlySet__.add("apiSchema");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder httpEndpointAuthConfig(HttpEndpointAuthConfig httpEndpointAuthConfig) {
            this.httpEndpointAuthConfig = httpEndpointAuthConfig;
            this.__explicitlySet__.add("httpEndpointAuthConfig");
            return this;
        }

        public HttpEndpointToolConfig build() {
            HttpEndpointToolConfig model = new HttpEndpointToolConfig(this.apiSchema, this.subnetId, this.httpEndpointAuthConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HttpEndpointToolConfig model) {
            if (model.wasPropertyExplicitlySet("apiSchema")) {
                this.apiSchema(model.getApiSchema());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("httpEndpointAuthConfig")) {
                this.httpEndpointAuthConfig(model.getHttpEndpointAuthConfig());
            }
            return this;
        }
    }
}

