/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KnowledgeBaseStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="totalIngestedFiles")
    private final Long totalIngestedFiles;

    @Deprecated
    @ConstructorProperties(value={"sizeInBytes", "totalIngestedFiles"})
    public KnowledgeBaseStatistics(Long sizeInBytes, Long totalIngestedFiles) {
        this.sizeInBytes = sizeInBytes;
        this.totalIngestedFiles = totalIngestedFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Long getTotalIngestedFiles() {
        return this.totalIngestedFiles;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KnowledgeBaseStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", totalIngestedFiles=").append(String.valueOf(this.totalIngestedFiles));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KnowledgeBaseStatistics)) {
            return false;
        }
        KnowledgeBaseStatistics other = (KnowledgeBaseStatistics)((Object)o);
        return Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.totalIngestedFiles, other.totalIngestedFiles) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.totalIngestedFiles == null ? 43 : this.totalIngestedFiles.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="totalIngestedFiles")
        private Long totalIngestedFiles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder totalIngestedFiles(Long totalIngestedFiles) {
            this.totalIngestedFiles = totalIngestedFiles;
            this.__explicitlySet__.add("totalIngestedFiles");
            return this;
        }

        public KnowledgeBaseStatistics build() {
            KnowledgeBaseStatistics model = new KnowledgeBaseStatistics(this.sizeInBytes, this.totalIngestedFiles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KnowledgeBaseStatistics model) {
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("totalIngestedFiles")) {
                this.totalIngestedFiles(model.getTotalIngestedFiles());
            }
            return this;
        }
    }
}

