/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.DatabaseConnection;
import com.oracle.bmc.generativeaiagent.model.DatabaseFunction;
import com.oracle.bmc.generativeaiagent.model.IndexConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="indexConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class OciDatabaseConfig
extends IndexConfig {
    @JsonProperty(value="databaseConnection")
    private final DatabaseConnection databaseConnection;
    @JsonProperty(value="databaseFunctions")
    private final List<DatabaseFunction> databaseFunctions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OciDatabaseConfig(DatabaseConnection databaseConnection, List<DatabaseFunction> databaseFunctions) {
        this.databaseConnection = databaseConnection;
        this.databaseFunctions = databaseFunctions;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public List<DatabaseFunction> getDatabaseFunctions() {
        return this.databaseFunctions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciDatabaseConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", databaseConnection=").append(String.valueOf((Object)this.databaseConnection));
        sb.append(", databaseFunctions=").append(String.valueOf(this.databaseFunctions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciDatabaseConfig)) {
            return false;
        }
        OciDatabaseConfig other = (OciDatabaseConfig)((Object)o);
        return Objects.equals((Object)this.databaseConnection, (Object)other.databaseConnection) && Objects.equals(this.databaseFunctions, other.databaseFunctions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseConnection == null ? 43 : this.databaseConnection.hashCode());
        result = result * 59 + (this.databaseFunctions == null ? 43 : this.databaseFunctions.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseConnection")
        private DatabaseConnection databaseConnection;
        @JsonProperty(value="databaseFunctions")
        private List<DatabaseFunction> databaseFunctions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseConnection(DatabaseConnection databaseConnection) {
            this.databaseConnection = databaseConnection;
            this.__explicitlySet__.add("databaseConnection");
            return this;
        }

        public Builder databaseFunctions(List<DatabaseFunction> databaseFunctions) {
            this.databaseFunctions = databaseFunctions;
            this.__explicitlySet__.add("databaseFunctions");
            return this;
        }

        public OciDatabaseConfig build() {
            OciDatabaseConfig model = new OciDatabaseConfig(this.databaseConnection, this.databaseFunctions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciDatabaseConfig model) {
            if (model.wasPropertyExplicitlySet("databaseConnection")) {
                this.databaseConnection(model.getDatabaseConnection());
            }
            if (model.wasPropertyExplicitlySet("databaseFunctions")) {
                this.databaseFunctions(model.getDatabaseFunctions());
            }
            return this;
        }
    }
}

