/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.DataSourceConfig;
import com.oracle.bmc.generativeaiagent.model.ObjectStoragePrefix;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dataSourceConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class OciObjectStorageDataSourceConfig
extends DataSourceConfig {
    @JsonProperty(value="objectStoragePrefixes")
    private final List<ObjectStoragePrefix> objectStoragePrefixes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OciObjectStorageDataSourceConfig(Boolean shouldEnableMultiModality, List<ObjectStoragePrefix> objectStoragePrefixes) {
        super(shouldEnableMultiModality);
        this.objectStoragePrefixes = objectStoragePrefixes;
    }

    public List<ObjectStoragePrefix> getObjectStoragePrefixes() {
        return this.objectStoragePrefixes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciObjectStorageDataSourceConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", objectStoragePrefixes=").append(String.valueOf(this.objectStoragePrefixes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciObjectStorageDataSourceConfig)) {
            return false;
        }
        OciObjectStorageDataSourceConfig other = (OciObjectStorageDataSourceConfig)((Object)o);
        return Objects.equals(this.objectStoragePrefixes, other.objectStoragePrefixes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.objectStoragePrefixes == null ? 43 : this.objectStoragePrefixes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shouldEnableMultiModality")
        private Boolean shouldEnableMultiModality;
        @JsonProperty(value="objectStoragePrefixes")
        private List<ObjectStoragePrefix> objectStoragePrefixes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shouldEnableMultiModality(Boolean shouldEnableMultiModality) {
            this.shouldEnableMultiModality = shouldEnableMultiModality;
            this.__explicitlySet__.add("shouldEnableMultiModality");
            return this;
        }

        public Builder objectStoragePrefixes(List<ObjectStoragePrefix> objectStoragePrefixes) {
            this.objectStoragePrefixes = objectStoragePrefixes;
            this.__explicitlySet__.add("objectStoragePrefixes");
            return this;
        }

        public OciObjectStorageDataSourceConfig build() {
            OciObjectStorageDataSourceConfig model = new OciObjectStorageDataSourceConfig(this.shouldEnableMultiModality, this.objectStoragePrefixes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciObjectStorageDataSourceConfig model) {
            if (model.wasPropertyExplicitlySet("shouldEnableMultiModality")) {
                this.shouldEnableMultiModality(model.getShouldEnableMultiModality());
            }
            if (model.wasPropertyExplicitlySet("objectStoragePrefixes")) {
                this.objectStoragePrefixes(model.getObjectStoragePrefixes());
            }
            return this;
        }
    }
}

