/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.OutputLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OutputConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="outputLocation")
    private final OutputLocation outputLocation;
    @JsonProperty(value="retentionPeriodInMinutes")
    private final Integer retentionPeriodInMinutes;

    @Deprecated
    @ConstructorProperties(value={"outputLocation", "retentionPeriodInMinutes"})
    public OutputConfig(OutputLocation outputLocation, Integer retentionPeriodInMinutes) {
        this.outputLocation = outputLocation;
        this.retentionPeriodInMinutes = retentionPeriodInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public Integer getRetentionPeriodInMinutes() {
        return this.retentionPeriodInMinutes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OutputConfig(");
        sb.append("super=").append(super.toString());
        sb.append("outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", retentionPeriodInMinutes=").append(String.valueOf(this.retentionPeriodInMinutes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig)((Object)o);
        return Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals(this.retentionPeriodInMinutes, other.retentionPeriodInMinutes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.retentionPeriodInMinutes == null ? 43 : this.retentionPeriodInMinutes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="outputLocation")
        private OutputLocation outputLocation;
        @JsonProperty(value="retentionPeriodInMinutes")
        private Integer retentionPeriodInMinutes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder retentionPeriodInMinutes(Integer retentionPeriodInMinutes) {
            this.retentionPeriodInMinutes = retentionPeriodInMinutes;
            this.__explicitlySet__.add("retentionPeriodInMinutes");
            return this;
        }

        public OutputConfig build() {
            OutputConfig model = new OutputConfig(this.outputLocation, this.retentionPeriodInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OutputConfig model) {
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriodInMinutes")) {
                this.retentionPeriodInMinutes(model.getRetentionPeriodInMinutes());
            }
            return this;
        }
    }
}

