/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.KnowledgeBaseConfig;
import com.oracle.bmc.generativeaiagent.model.LlmCustomization;
import com.oracle.bmc.generativeaiagent.model.ToolConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="toolConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class RagToolConfig
extends ToolConfig {
    @JsonProperty(value="knowledgeBaseConfigs")
    private final List<KnowledgeBaseConfig> knowledgeBaseConfigs;
    @JsonProperty(value="generationLlmCustomization")
    private final LlmCustomization generationLlmCustomization;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RagToolConfig(List<KnowledgeBaseConfig> knowledgeBaseConfigs, LlmCustomization generationLlmCustomization) {
        this.knowledgeBaseConfigs = knowledgeBaseConfigs;
        this.generationLlmCustomization = generationLlmCustomization;
    }

    public List<KnowledgeBaseConfig> getKnowledgeBaseConfigs() {
        return this.knowledgeBaseConfigs;
    }

    public LlmCustomization getGenerationLlmCustomization() {
        return this.generationLlmCustomization;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RagToolConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", knowledgeBaseConfigs=").append(String.valueOf(this.knowledgeBaseConfigs));
        sb.append(", generationLlmCustomization=").append(String.valueOf((Object)this.generationLlmCustomization));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RagToolConfig)) {
            return false;
        }
        RagToolConfig other = (RagToolConfig)((Object)o);
        return Objects.equals(this.knowledgeBaseConfigs, other.knowledgeBaseConfigs) && Objects.equals((Object)this.generationLlmCustomization, (Object)other.generationLlmCustomization) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.knowledgeBaseConfigs == null ? 43 : this.knowledgeBaseConfigs.hashCode());
        result = result * 59 + (this.generationLlmCustomization == null ? 43 : this.generationLlmCustomization.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="knowledgeBaseConfigs")
        private List<KnowledgeBaseConfig> knowledgeBaseConfigs;
        @JsonProperty(value="generationLlmCustomization")
        private LlmCustomization generationLlmCustomization;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder knowledgeBaseConfigs(List<KnowledgeBaseConfig> knowledgeBaseConfigs) {
            this.knowledgeBaseConfigs = knowledgeBaseConfigs;
            this.__explicitlySet__.add("knowledgeBaseConfigs");
            return this;
        }

        public Builder generationLlmCustomization(LlmCustomization generationLlmCustomization) {
            this.generationLlmCustomization = generationLlmCustomization;
            this.__explicitlySet__.add("generationLlmCustomization");
            return this;
        }

        public RagToolConfig build() {
            RagToolConfig model = new RagToolConfig(this.knowledgeBaseConfigs, this.generationLlmCustomization);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RagToolConfig model) {
            if (model.wasPropertyExplicitlySet("knowledgeBaseConfigs")) {
                this.knowledgeBaseConfigs(model.getKnowledgeBaseConfigs());
            }
            if (model.wasPropertyExplicitlySet("generationLlmCustomization")) {
                this.generationLlmCustomization(model.getGenerationLlmCustomization());
            }
            return this;
        }
    }
}

