/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.DatabaseConnection;
import com.oracle.bmc.generativeaiagent.model.InputLocation;
import com.oracle.bmc.generativeaiagent.model.LlmCustomization;
import com.oracle.bmc.generativeaiagent.model.ToolConfig;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="toolConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class SqlToolConfig
extends ToolConfig {
    @JsonProperty(value="iclExamples")
    private final InputLocation iclExamples;
    @JsonProperty(value="databaseSchema")
    private final InputLocation databaseSchema;
    @JsonProperty(value="shouldEnableSqlExecution")
    private final Boolean shouldEnableSqlExecution;
    @JsonProperty(value="dialect")
    private final Dialect dialect;
    @JsonProperty(value="modelSize")
    private final ModelSize modelSize;
    @JsonProperty(value="shouldEnableSelfCorrection")
    private final Boolean shouldEnableSelfCorrection;
    @JsonProperty(value="tableAndColumnDescription")
    private final InputLocation tableAndColumnDescription;
    @JsonProperty(value="generationLlmCustomization")
    private final LlmCustomization generationLlmCustomization;
    @JsonProperty(value="databaseConnection")
    private final DatabaseConnection databaseConnection;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SqlToolConfig(InputLocation iclExamples, InputLocation databaseSchema, Boolean shouldEnableSqlExecution, Dialect dialect, ModelSize modelSize, Boolean shouldEnableSelfCorrection, InputLocation tableAndColumnDescription, LlmCustomization generationLlmCustomization, DatabaseConnection databaseConnection) {
        this.iclExamples = iclExamples;
        this.databaseSchema = databaseSchema;
        this.shouldEnableSqlExecution = shouldEnableSqlExecution;
        this.dialect = dialect;
        this.modelSize = modelSize;
        this.shouldEnableSelfCorrection = shouldEnableSelfCorrection;
        this.tableAndColumnDescription = tableAndColumnDescription;
        this.generationLlmCustomization = generationLlmCustomization;
        this.databaseConnection = databaseConnection;
    }

    public InputLocation getIclExamples() {
        return this.iclExamples;
    }

    public InputLocation getDatabaseSchema() {
        return this.databaseSchema;
    }

    public Boolean getShouldEnableSqlExecution() {
        return this.shouldEnableSqlExecution;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public ModelSize getModelSize() {
        return this.modelSize;
    }

    public Boolean getShouldEnableSelfCorrection() {
        return this.shouldEnableSelfCorrection;
    }

    public InputLocation getTableAndColumnDescription() {
        return this.tableAndColumnDescription;
    }

    public LlmCustomization getGenerationLlmCustomization() {
        return this.generationLlmCustomization;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlToolConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", iclExamples=").append(String.valueOf((Object)this.iclExamples));
        sb.append(", databaseSchema=").append(String.valueOf((Object)this.databaseSchema));
        sb.append(", shouldEnableSqlExecution=").append(String.valueOf(this.shouldEnableSqlExecution));
        sb.append(", dialect=").append(String.valueOf((Object)this.dialect));
        sb.append(", modelSize=").append(String.valueOf((Object)this.modelSize));
        sb.append(", shouldEnableSelfCorrection=").append(String.valueOf(this.shouldEnableSelfCorrection));
        sb.append(", tableAndColumnDescription=").append(String.valueOf((Object)this.tableAndColumnDescription));
        sb.append(", generationLlmCustomization=").append(String.valueOf((Object)this.generationLlmCustomization));
        sb.append(", databaseConnection=").append(String.valueOf((Object)this.databaseConnection));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlToolConfig)) {
            return false;
        }
        SqlToolConfig other = (SqlToolConfig)((Object)o);
        return Objects.equals((Object)this.iclExamples, (Object)other.iclExamples) && Objects.equals((Object)this.databaseSchema, (Object)other.databaseSchema) && Objects.equals(this.shouldEnableSqlExecution, other.shouldEnableSqlExecution) && Objects.equals((Object)this.dialect, (Object)other.dialect) && Objects.equals((Object)this.modelSize, (Object)other.modelSize) && Objects.equals(this.shouldEnableSelfCorrection, other.shouldEnableSelfCorrection) && Objects.equals((Object)this.tableAndColumnDescription, (Object)other.tableAndColumnDescription) && Objects.equals((Object)this.generationLlmCustomization, (Object)other.generationLlmCustomization) && Objects.equals((Object)this.databaseConnection, (Object)other.databaseConnection) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.iclExamples == null ? 43 : this.iclExamples.hashCode());
        result = result * 59 + (this.databaseSchema == null ? 43 : this.databaseSchema.hashCode());
        result = result * 59 + (this.shouldEnableSqlExecution == null ? 43 : this.shouldEnableSqlExecution.hashCode());
        result = result * 59 + (this.dialect == null ? 43 : this.dialect.hashCode());
        result = result * 59 + (this.modelSize == null ? 43 : this.modelSize.hashCode());
        result = result * 59 + (this.shouldEnableSelfCorrection == null ? 43 : this.shouldEnableSelfCorrection.hashCode());
        result = result * 59 + (this.tableAndColumnDescription == null ? 43 : this.tableAndColumnDescription.hashCode());
        result = result * 59 + (this.generationLlmCustomization == null ? 43 : this.generationLlmCustomization.hashCode());
        result = result * 59 + (this.databaseConnection == null ? 43 : this.databaseConnection.hashCode());
        return result;
    }

    public static enum ModelSize implements BmcEnum
    {
        Small("SMALL"),
        Large("LARGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelSize> map;

        private ModelSize(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelSize create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelSize', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelSize.class);
            map = new HashMap<String, ModelSize>();
            for (ModelSize v : ModelSize.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Dialect implements BmcEnum
    {
        SqlLite("SQL_LITE"),
        OracleSql("ORACLE_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Dialect> map;

        private Dialect(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Dialect create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Dialect', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Dialect.class);
            map = new HashMap<String, Dialect>();
            for (Dialect v : Dialect.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="iclExamples")
        private InputLocation iclExamples;
        @JsonProperty(value="databaseSchema")
        private InputLocation databaseSchema;
        @JsonProperty(value="shouldEnableSqlExecution")
        private Boolean shouldEnableSqlExecution;
        @JsonProperty(value="dialect")
        private Dialect dialect;
        @JsonProperty(value="modelSize")
        private ModelSize modelSize;
        @JsonProperty(value="shouldEnableSelfCorrection")
        private Boolean shouldEnableSelfCorrection;
        @JsonProperty(value="tableAndColumnDescription")
        private InputLocation tableAndColumnDescription;
        @JsonProperty(value="generationLlmCustomization")
        private LlmCustomization generationLlmCustomization;
        @JsonProperty(value="databaseConnection")
        private DatabaseConnection databaseConnection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder iclExamples(InputLocation iclExamples) {
            this.iclExamples = iclExamples;
            this.__explicitlySet__.add("iclExamples");
            return this;
        }

        public Builder databaseSchema(InputLocation databaseSchema) {
            this.databaseSchema = databaseSchema;
            this.__explicitlySet__.add("databaseSchema");
            return this;
        }

        public Builder shouldEnableSqlExecution(Boolean shouldEnableSqlExecution) {
            this.shouldEnableSqlExecution = shouldEnableSqlExecution;
            this.__explicitlySet__.add("shouldEnableSqlExecution");
            return this;
        }

        public Builder dialect(Dialect dialect) {
            this.dialect = dialect;
            this.__explicitlySet__.add("dialect");
            return this;
        }

        public Builder modelSize(ModelSize modelSize) {
            this.modelSize = modelSize;
            this.__explicitlySet__.add("modelSize");
            return this;
        }

        public Builder shouldEnableSelfCorrection(Boolean shouldEnableSelfCorrection) {
            this.shouldEnableSelfCorrection = shouldEnableSelfCorrection;
            this.__explicitlySet__.add("shouldEnableSelfCorrection");
            return this;
        }

        public Builder tableAndColumnDescription(InputLocation tableAndColumnDescription) {
            this.tableAndColumnDescription = tableAndColumnDescription;
            this.__explicitlySet__.add("tableAndColumnDescription");
            return this;
        }

        public Builder generationLlmCustomization(LlmCustomization generationLlmCustomization) {
            this.generationLlmCustomization = generationLlmCustomization;
            this.__explicitlySet__.add("generationLlmCustomization");
            return this;
        }

        public Builder databaseConnection(DatabaseConnection databaseConnection) {
            this.databaseConnection = databaseConnection;
            this.__explicitlySet__.add("databaseConnection");
            return this;
        }

        public SqlToolConfig build() {
            SqlToolConfig model = new SqlToolConfig(this.iclExamples, this.databaseSchema, this.shouldEnableSqlExecution, this.dialect, this.modelSize, this.shouldEnableSelfCorrection, this.tableAndColumnDescription, this.generationLlmCustomization, this.databaseConnection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlToolConfig model) {
            if (model.wasPropertyExplicitlySet("iclExamples")) {
                this.iclExamples(model.getIclExamples());
            }
            if (model.wasPropertyExplicitlySet("databaseSchema")) {
                this.databaseSchema(model.getDatabaseSchema());
            }
            if (model.wasPropertyExplicitlySet("shouldEnableSqlExecution")) {
                this.shouldEnableSqlExecution(model.getShouldEnableSqlExecution());
            }
            if (model.wasPropertyExplicitlySet("dialect")) {
                this.dialect(model.getDialect());
            }
            if (model.wasPropertyExplicitlySet("modelSize")) {
                this.modelSize(model.getModelSize());
            }
            if (model.wasPropertyExplicitlySet("shouldEnableSelfCorrection")) {
                this.shouldEnableSelfCorrection(model.getShouldEnableSelfCorrection());
            }
            if (model.wasPropertyExplicitlySet("tableAndColumnDescription")) {
                this.tableAndColumnDescription(model.getTableAndColumnDescription());
            }
            if (model.wasPropertyExplicitlySet("generationLlmCustomization")) {
                this.generationLlmCustomization(model.getGenerationLlmCustomization());
            }
            if (model.wasPropertyExplicitlySet("databaseConnection")) {
                this.databaseConnection(model.getDatabaseConnection());
            }
            return this;
        }
    }
}

