/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.generativeaiagent.model.UpdateToolDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateToolRequest
extends BmcRequest<UpdateToolDetails> {
    private String toolId;
    private UpdateToolDetails updateToolDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getToolId() {
        return this.toolId;
    }

    public UpdateToolDetails getUpdateToolDetails() {
        return this.updateToolDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateToolDetails getBody$() {
        return this.updateToolDetails;
    }

    public Builder toBuilder() {
        return new Builder().toolId(this.toolId).updateToolDetails(this.updateToolDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",toolId=").append(String.valueOf(this.toolId));
        sb.append(",updateToolDetails=").append(String.valueOf((Object)this.updateToolDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateToolRequest)) {
            return false;
        }
        UpdateToolRequest other = (UpdateToolRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.toolId, other.toolId) && Objects.equals((Object)this.updateToolDetails, (Object)other.updateToolDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.toolId == null ? 43 : this.toolId.hashCode());
        result = result * 59 + (this.updateToolDetails == null ? 43 : this.updateToolDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateToolRequest, UpdateToolDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String toolId = null;
        private UpdateToolDetails updateToolDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder toolId(String toolId) {
            this.toolId = toolId;
            return this;
        }

        public Builder updateToolDetails(UpdateToolDetails updateToolDetails) {
            this.updateToolDetails = updateToolDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateToolRequest o) {
            this.toolId(o.getToolId());
            this.updateToolDetails(o.getUpdateToolDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateToolRequest build() {
            UpdateToolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateToolDetails body) {
            this.updateToolDetails(body);
            return this;
        }

        public UpdateToolRequest buildWithoutInvocationCallback() {
            UpdateToolRequest request = new UpdateToolRequest();
            request.toolId = this.toolId;
            request.updateToolDetails = this.updateToolDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

