/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.generativeaiagentruntime.GenerativeAiAgentRuntimeAsync;
import com.oracle.bmc.generativeaiagentruntime.model.ChatResult;
import com.oracle.bmc.generativeaiagentruntime.model.Session;
import com.oracle.bmc.generativeaiagentruntime.requests.ChatRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.CreateSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.DeleteSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.GetSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.UpdateSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.responses.ChatResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.CreateSessionResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.DeleteSessionResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.GetSessionResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.UpdateSessionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerativeAiAgentRuntimeAsyncClient
extends BaseAsyncClient
implements GenerativeAiAgentRuntimeAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GENERATIVEAIAGENTRUNTIME").serviceEndpointPrefix("").serviceEndpointTemplate("https://genai-agent-service.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GenerativeAiAgentRuntimeAsyncClient.class);

    GenerativeAiAgentRuntimeAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChatResponse> chat(ChatRequest request, AsyncHandler<ChatRequest, ChatResponse> handler) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChatDetails(), "chatDetails is required");
        return this.clientCall(request, ChatResponse::builder).logger(LOG, "chat").serviceDetails("GenerativeAiAgentRuntime", "Chat", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents-client/20240531/Session/Chat").method(Method.POST).requestBuilder(ChatRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).appendPathParam("actions").appendPathParam("chat").accept(new String[]{"application/json, text/event-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ChatResult.class, ChatResponse.Builder::chatResult).handleEventStream(ChatResponse.Builder::eventStream).handleResponseHeaderString("opc-request-id", ChatResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSessionResponse> createSession(CreateSessionRequest request, AsyncHandler<CreateSessionRequest, CreateSessionResponse> handler) {
        Objects.requireNonNull(request.getCreateSessionDetails(), "createSessionDetails is required");
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateSessionResponse::builder).logger(LOG, "createSession").serviceDetails("GenerativeAiAgentRuntime", "CreateSession", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents-client/20240531/Session/CreateSession").method(Method.POST).requestBuilder(CreateSessionRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).appendPathParam("sessions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Session.class, CreateSessionResponse.Builder::session).handleResponseHeaderString("etag", CreateSessionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSessionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSessionResponse> deleteSession(DeleteSessionRequest request, AsyncHandler<DeleteSessionRequest, DeleteSessionResponse> handler) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSessionId(), (String)"sessionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSessionResponse::builder).logger(LOG, "deleteSession").serviceDetails("GenerativeAiAgentRuntime", "DeleteSession", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents-client/20240531/Session/DeleteSession").method(Method.DELETE).requestBuilder(DeleteSessionRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).appendPathParam("sessions").appendPathParam(request.getSessionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSessionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSessionResponse> getSession(GetSessionRequest request, AsyncHandler<GetSessionRequest, GetSessionResponse> handler) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSessionId(), (String)"sessionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSessionResponse::builder).logger(LOG, "getSession").serviceDetails("GenerativeAiAgentRuntime", "GetSession", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents-client/20240531/Session/GetSession").method(Method.GET).requestBuilder(GetSessionRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).appendPathParam("sessions").appendPathParam(request.getSessionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Session.class, GetSessionResponse.Builder::session).handleResponseHeaderString("etag", GetSessionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSessionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSessionResponse> updateSession(UpdateSessionRequest request, AsyncHandler<UpdateSessionRequest, UpdateSessionResponse> handler) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSessionId(), (String)"sessionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSessionDetails(), "updateSessionDetails is required");
        return this.clientCall(request, UpdateSessionResponse::builder).logger(LOG, "updateSession").serviceDetails("GenerativeAiAgentRuntime", "UpdateSession", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents-client/20240531/Session/UpdateSession").method(Method.PUT).requestBuilder(UpdateSessionRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).appendPathParam("sessions").appendPathParam(request.getSessionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Session.class, UpdateSessionResponse.Builder::session).handleResponseHeaderString("etag", UpdateSessionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSessionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public GenerativeAiAgentRuntimeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GenerativeAiAgentRuntimeAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAgentRuntimeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GenerativeAiAgentRuntimeAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAgentRuntimeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GenerativeAiAgentRuntimeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAgentRuntimeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GenerativeAiAgentRuntimeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAgentRuntimeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GenerativeAiAgentRuntimeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAgentRuntimeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GenerativeAiAgentRuntimeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAgentRuntimeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GenerativeAiAgentRuntimeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GenerativeAiAgentRuntimeAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "generativeaiagentruntime";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"generativeaiagentruntime");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public GenerativeAiAgentRuntimeAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GenerativeAiAgentRuntimeAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

