/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ChatDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="userMessage")
    private final String userMessage;
    @JsonProperty(value="shouldStream")
    private final Boolean shouldStream;
    @JsonProperty(value="sessionId")
    private final String sessionId;

    @Deprecated
    @ConstructorProperties(value={"userMessage", "shouldStream", "sessionId"})
    public ChatDetails(String userMessage, Boolean shouldStream, String sessionId) {
        this.userMessage = userMessage;
        this.shouldStream = shouldStream;
        this.sessionId = sessionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public Boolean getShouldStream() {
        return this.shouldStream;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChatDetails(");
        sb.append("super=").append(super.toString());
        sb.append("userMessage=").append(String.valueOf(this.userMessage));
        sb.append(", shouldStream=").append(String.valueOf(this.shouldStream));
        sb.append(", sessionId=").append(String.valueOf(this.sessionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatDetails)) {
            return false;
        }
        ChatDetails other = (ChatDetails)((Object)o);
        return Objects.equals(this.userMessage, other.userMessage) && Objects.equals(this.shouldStream, other.shouldStream) && Objects.equals(this.sessionId, other.sessionId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.userMessage == null ? 43 : this.userMessage.hashCode());
        result = result * 59 + (this.shouldStream == null ? 43 : this.shouldStream.hashCode());
        result = result * 59 + (this.sessionId == null ? 43 : this.sessionId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userMessage")
        private String userMessage;
        @JsonProperty(value="shouldStream")
        private Boolean shouldStream;
        @JsonProperty(value="sessionId")
        private String sessionId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userMessage(String userMessage) {
            this.userMessage = userMessage;
            this.__explicitlySet__.add("userMessage");
            return this;
        }

        public Builder shouldStream(Boolean shouldStream) {
            this.shouldStream = shouldStream;
            this.__explicitlySet__.add("shouldStream");
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            this.__explicitlySet__.add("sessionId");
            return this;
        }

        public ChatDetails build() {
            ChatDetails model = new ChatDetails(this.userMessage, this.shouldStream, this.sessionId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ChatDetails model) {
            if (model.wasPropertyExplicitlySet("userMessage")) {
                this.userMessage(model.getUserMessage());
            }
            if (model.wasPropertyExplicitlySet("shouldStream")) {
                this.shouldStream(model.getShouldStream());
            }
            if (model.wasPropertyExplicitlySet("sessionId")) {
                this.sessionId(model.getSessionId());
            }
            return this;
        }
    }
}

