/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagentruntime.model.Trace;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="traceType")
@JsonFilter(value="explicitlySetFilter")
public final class GenerationTrace
extends Trace {
    @JsonProperty(value="generation")
    private final String generation;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GenerationTrace(Date timeCreated, String generation) {
        super(timeCreated);
        this.generation = generation;
    }

    public String getGeneration() {
        return this.generation;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerationTrace(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", generation=").append(String.valueOf(this.generation));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerationTrace)) {
            return false;
        }
        GenerationTrace other = (GenerationTrace)((Object)o);
        return Objects.equals(this.generation, other.generation) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.generation == null ? 43 : this.generation.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="generation")
        private String generation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder generation(String generation) {
            this.generation = generation;
            this.__explicitlySet__.add("generation");
            return this;
        }

        public GenerationTrace build() {
            GenerationTrace model = new GenerationTrace(this.timeCreated, this.generation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenerationTrace model) {
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("generation")) {
                this.generation(model.getGeneration());
            }
            return this;
        }
    }
}

