/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagentruntime.model.SourceLocation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceLocationType")
@JsonFilter(value="explicitlySetFilter")
public final class OciOpenSearchSourceLocation
extends SourceLocation {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="indexName")
    private final String indexName;
    @JsonProperty(value="url")
    private final String url;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OciOpenSearchSourceLocation(String id, String indexName, String url) {
        this.id = id;
        this.indexName = indexName;
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciOpenSearchSourceLocation(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", indexName=").append(String.valueOf(this.indexName));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciOpenSearchSourceLocation)) {
            return false;
        }
        OciOpenSearchSourceLocation other = (OciOpenSearchSourceLocation)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.indexName, other.indexName) && Objects.equals(this.url, other.url) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.indexName == null ? 43 : this.indexName.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="indexName")
        private String indexName;
        @JsonProperty(value="url")
        private String url;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            this.__explicitlySet__.add("indexName");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public OciOpenSearchSourceLocation build() {
            OciOpenSearchSourceLocation model = new OciOpenSearchSourceLocation(this.id, this.indexName, this.url);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciOpenSearchSourceLocation model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("indexName")) {
                this.indexName(model.getIndexName());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            return this;
        }
    }
}

