/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagentruntime.model.Citation;
import com.oracle.bmc.generativeaiagentruntime.model.Trace;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="traceType")
@JsonFilter(value="explicitlySetFilter")
public final class RetrievalTrace
extends Trace {
    @JsonProperty(value="retrievalInput")
    private final String retrievalInput;
    @JsonProperty(value="citations")
    private final List<Citation> citations;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RetrievalTrace(Date timeCreated, String retrievalInput, List<Citation> citations) {
        super(timeCreated);
        this.retrievalInput = retrievalInput;
        this.citations = citations;
    }

    public String getRetrievalInput() {
        return this.retrievalInput;
    }

    public List<Citation> getCitations() {
        return this.citations;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RetrievalTrace(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", retrievalInput=").append(String.valueOf(this.retrievalInput));
        sb.append(", citations=").append(String.valueOf(this.citations));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetrievalTrace)) {
            return false;
        }
        RetrievalTrace other = (RetrievalTrace)((Object)o);
        return Objects.equals(this.retrievalInput, other.retrievalInput) && Objects.equals(this.citations, other.citations) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.retrievalInput == null ? 43 : this.retrievalInput.hashCode());
        result = result * 59 + (this.citations == null ? 43 : this.citations.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="retrievalInput")
        private String retrievalInput;
        @JsonProperty(value="citations")
        private List<Citation> citations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder retrievalInput(String retrievalInput) {
            this.retrievalInput = retrievalInput;
            this.__explicitlySet__.add("retrievalInput");
            return this;
        }

        public Builder citations(List<Citation> citations) {
            this.citations = citations;
            this.__explicitlySet__.add("citations");
            return this;
        }

        public RetrievalTrace build() {
            RetrievalTrace model = new RetrievalTrace(this.timeCreated, this.retrievalInput, this.citations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RetrievalTrace model) {
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("retrievalInput")) {
                this.retrievalInput(model.getRetrievalInput());
            }
            if (model.wasPropertyExplicitlySet("citations")) {
                this.citations(model.getCitations());
            }
            return this;
        }
    }
}

