/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.generativeaiagentruntime.model.ChatDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChatRequest
extends BmcRequest<ChatDetails> {
    private String agentEndpointId;
    private ChatDetails chatDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getAgentEndpointId() {
        return this.agentEndpointId;
    }

    public ChatDetails getChatDetails() {
        return this.chatDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChatDetails getBody$() {
        return this.chatDetails;
    }

    public Builder toBuilder() {
        return new Builder().agentEndpointId(this.agentEndpointId).chatDetails(this.chatDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",agentEndpointId=").append(String.valueOf(this.agentEndpointId));
        sb.append(",chatDetails=").append(String.valueOf((Object)this.chatDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatRequest)) {
            return false;
        }
        ChatRequest other = (ChatRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.agentEndpointId, other.agentEndpointId) && Objects.equals((Object)this.chatDetails, (Object)other.chatDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.agentEndpointId == null ? 43 : this.agentEndpointId.hashCode());
        result = result * 59 + (this.chatDetails == null ? 43 : this.chatDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChatRequest, ChatDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String agentEndpointId = null;
        private ChatDetails chatDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder agentEndpointId(String agentEndpointId) {
            this.agentEndpointId = agentEndpointId;
            return this;
        }

        public Builder chatDetails(ChatDetails chatDetails) {
            this.chatDetails = chatDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChatRequest o) {
            this.agentEndpointId(o.getAgentEndpointId());
            this.chatDetails(o.getChatDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChatRequest build() {
            ChatRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChatDetails body) {
            this.chatDetails(body);
            return this;
        }

        public ChatRequest buildWithoutInvocationCallback() {
            ChatRequest request = new ChatRequest();
            request.agentEndpointId = this.agentEndpointId;
            request.chatDetails = this.chatDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

