/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.generativeaiagentruntime.model.CreateSessionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateSessionRequest
extends BmcRequest<CreateSessionDetails> {
    private CreateSessionDetails createSessionDetails;
    private String agentEndpointId;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateSessionDetails getCreateSessionDetails() {
        return this.createSessionDetails;
    }

    public String getAgentEndpointId() {
        return this.agentEndpointId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateSessionDetails getBody$() {
        return this.createSessionDetails;
    }

    public Builder toBuilder() {
        return new Builder().createSessionDetails(this.createSessionDetails).agentEndpointId(this.agentEndpointId).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createSessionDetails=").append(String.valueOf((Object)this.createSessionDetails));
        sb.append(",agentEndpointId=").append(String.valueOf(this.agentEndpointId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createSessionDetails, (Object)other.createSessionDetails) && Objects.equals(this.agentEndpointId, other.agentEndpointId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createSessionDetails == null ? 43 : this.createSessionDetails.hashCode());
        result = result * 59 + (this.agentEndpointId == null ? 43 : this.agentEndpointId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateSessionRequest, CreateSessionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateSessionDetails createSessionDetails = null;
        private String agentEndpointId = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createSessionDetails(CreateSessionDetails createSessionDetails) {
            this.createSessionDetails = createSessionDetails;
            return this;
        }

        public Builder agentEndpointId(String agentEndpointId) {
            this.agentEndpointId = agentEndpointId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateSessionRequest o) {
            this.createSessionDetails(o.getCreateSessionDetails());
            this.agentEndpointId(o.getAgentEndpointId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateSessionRequest build() {
            CreateSessionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateSessionDetails body) {
            this.createSessionDetails(body);
            return this;
        }

        public CreateSessionRequest buildWithoutInvocationCallback() {
            CreateSessionRequest request = new CreateSessionRequest();
            request.createSessionDetails = this.createSessionDetails;
            request.agentEndpointId = this.agentEndpointId;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

