/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagentruntime.responses;

import com.oracle.bmc.generativeaiagentruntime.model.ChatResult;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChatResponse
extends BmcResponse {
    private String opcRequestId;
    private ChatResult chatResult;
    private InputStream eventStream;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ChatResult getChatResult() {
        return this.chatResult;
    }

    public InputStream getEventStream() {
        return this.eventStream;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "chatResult", "eventStream"})
    private ChatResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, ChatResult chatResult, InputStream eventStream) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.chatResult = chatResult;
        this.eventStream = eventStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",chatResult=").append(String.valueOf((Object)this.chatResult));
        sb.append(",eventStream=").append(String.valueOf(this.eventStream));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatResponse)) {
            return false;
        }
        ChatResponse other = (ChatResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.chatResult, (Object)other.chatResult) && Objects.equals(this.eventStream, other.eventStream);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.chatResult == null ? 43 : this.chatResult.hashCode());
        result = result * 59 + (this.eventStream == null ? 43 : this.eventStream.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ChatResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private ChatResult chatResult;
        private InputStream eventStream;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder chatResult(ChatResult chatResult) {
            this.chatResult = chatResult;
            return this;
        }

        public Builder eventStream(InputStream eventStream) {
            this.eventStream = eventStream;
            return this;
        }

        public Builder copy(ChatResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.chatResult(o.getChatResult());
            this.eventStream(o.getEventStream());
            return this;
        }

        public ChatResponse build() {
            return new ChatResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.chatResult, this.eventStream);
        }
    }
}

