/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference;

import com.oracle.bmc.generativeaiinference.model.AssistantMessage;
import com.oracle.bmc.generativeaiinference.model.ChatChoice;
import com.oracle.bmc.generativeaiinference.model.ChatContent;
import com.oracle.bmc.generativeaiinference.model.ChatResult;
import com.oracle.bmc.generativeaiinference.model.CohereLlmInferenceResponse;
import com.oracle.bmc.generativeaiinference.model.GenerateTextResult;
import com.oracle.bmc.generativeaiinference.model.GeneratedText;
import com.oracle.bmc.generativeaiinference.model.GenericChatResponse;
import com.oracle.bmc.generativeaiinference.model.TextContent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerativeAiInferenceSseHelper {
    public static final Function<InputStream, GenerateTextResult> generateTextResultReader = entityStream -> {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)entityStream));){
            GenerateTextResult result;
            String line;
            ArrayList<GeneratedText> generatedTextList = new ArrayList<GeneratedText>();
            String patternString = "\"text\"\\s*:\\s*\"([^\"]*)\"";
            Pattern pattern = Pattern.compile(patternString);
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                if (line.isEmpty() || line.startsWith(":") || !(matcher = pattern.matcher(line)).find()) continue;
                String textField = matcher.group(1);
                GeneratedText generatedText = GeneratedText.builder().text(textField).build();
                generatedTextList.add(generatedText);
            }
            CohereLlmInferenceResponse response = CohereLlmInferenceResponse.builder().generatedTexts(generatedTextList).timeCreated(Date.from(Instant.now())).build();
            GenerateTextResult generateTextResult = result = GenerateTextResult.builder().inferenceResponse(response).build();
            return generateTextResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    public static final Function<InputStream, ChatResult> chatResultReader = entityStream -> {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)entityStream));){
            ChatResult chatResult;
            String line;
            ArrayList<ChatChoice> chatChoiceList = new ArrayList<ChatChoice>();
            String patternString = "\"text\"\\s*:\\s*\"([^\"]*)\"";
            Pattern pattern = Pattern.compile(patternString);
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                if (line.isEmpty() || line.startsWith(":") || !(matcher = pattern.matcher(line)).find()) continue;
                String textField = matcher.group(1);
                TextContent chatContent = TextContent.builder().text(textField).build();
                ArrayList<ChatContent> chatContentList = new ArrayList<ChatContent>();
                chatContentList.add(chatContent);
                AssistantMessage message = AssistantMessage.builder().content(chatContentList).build();
                ChatChoice chatChoice = ChatChoice.builder().message(message).build();
                chatChoiceList.add(chatChoice);
            }
            GenericChatResponse chatResponse = GenericChatResponse.builder().choices(chatChoiceList).build();
            ChatResult chatResult2 = chatResult = ChatResult.builder().chatResponse(chatResponse).build();
            return chatResult2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
}

