/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.BaseChatRequest;
import com.oracle.bmc.generativeaiinference.model.CohereMessage;
import com.oracle.bmc.generativeaiinference.model.CohereTool;
import com.oracle.bmc.generativeaiinference.model.CohereToolResult;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="apiFormat")
@JsonFilter(value="explicitlySetFilter")
public final class CohereChatRequest
extends BaseChatRequest {
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="chatHistory")
    private final List<CohereMessage> chatHistory;
    @JsonProperty(value="documents")
    private final List<Object> documents;
    @JsonProperty(value="isSearchQueriesOnly")
    private final Boolean isSearchQueriesOnly;
    @JsonProperty(value="preambleOverride")
    private final String preambleOverride;
    @JsonProperty(value="isStream")
    private final Boolean isStream;
    @JsonProperty(value="maxTokens")
    private final Integer maxTokens;
    @JsonProperty(value="temperature")
    private final Double temperature;
    @JsonProperty(value="topK")
    private final Integer topK;
    @JsonProperty(value="topP")
    private final Double topP;
    @JsonProperty(value="promptTruncation")
    private final PromptTruncation promptTruncation;
    @JsonProperty(value="frequencyPenalty")
    private final Double frequencyPenalty;
    @JsonProperty(value="presencePenalty")
    private final Double presencePenalty;
    @JsonProperty(value="seed")
    private final Integer seed;
    @JsonProperty(value="isEcho")
    private final Boolean isEcho;
    @JsonProperty(value="tools")
    private final List<CohereTool> tools;
    @JsonProperty(value="toolResults")
    private final List<CohereToolResult> toolResults;
    @JsonProperty(value="isForceSingleStep")
    private final Boolean isForceSingleStep;
    @JsonProperty(value="stopSequences")
    private final List<String> stopSequences;
    @JsonProperty(value="isRawPrompting")
    private final Boolean isRawPrompting;
    @JsonProperty(value="citationQuality")
    private final CitationQuality citationQuality;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CohereChatRequest(String message, List<CohereMessage> chatHistory, List<Object> documents, Boolean isSearchQueriesOnly, String preambleOverride, Boolean isStream, Integer maxTokens, Double temperature, Integer topK, Double topP, PromptTruncation promptTruncation, Double frequencyPenalty, Double presencePenalty, Integer seed, Boolean isEcho, List<CohereTool> tools, List<CohereToolResult> toolResults, Boolean isForceSingleStep, List<String> stopSequences, Boolean isRawPrompting, CitationQuality citationQuality) {
        this.message = message;
        this.chatHistory = chatHistory;
        this.documents = documents;
        this.isSearchQueriesOnly = isSearchQueriesOnly;
        this.preambleOverride = preambleOverride;
        this.isStream = isStream;
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topK = topK;
        this.topP = topP;
        this.promptTruncation = promptTruncation;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.seed = seed;
        this.isEcho = isEcho;
        this.tools = tools;
        this.toolResults = toolResults;
        this.isForceSingleStep = isForceSingleStep;
        this.stopSequences = stopSequences;
        this.isRawPrompting = isRawPrompting;
        this.citationQuality = citationQuality;
    }

    public String getMessage() {
        return this.message;
    }

    public List<CohereMessage> getChatHistory() {
        return this.chatHistory;
    }

    public List<Object> getDocuments() {
        return this.documents;
    }

    public Boolean getIsSearchQueriesOnly() {
        return this.isSearchQueriesOnly;
    }

    public String getPreambleOverride() {
        return this.preambleOverride;
    }

    public Boolean getIsStream() {
        return this.isStream;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public PromptTruncation getPromptTruncation() {
        return this.promptTruncation;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Boolean getIsEcho() {
        return this.isEcho;
    }

    public List<CohereTool> getTools() {
        return this.tools;
    }

    public List<CohereToolResult> getToolResults() {
        return this.toolResults;
    }

    public Boolean getIsForceSingleStep() {
        return this.isForceSingleStep;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public Boolean getIsRawPrompting() {
        return this.isRawPrompting;
    }

    public CitationQuality getCitationQuality() {
        return this.citationQuality;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CohereChatRequest(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", chatHistory=").append(String.valueOf(this.chatHistory));
        sb.append(", documents=").append(String.valueOf(this.documents));
        sb.append(", isSearchQueriesOnly=").append(String.valueOf(this.isSearchQueriesOnly));
        sb.append(", preambleOverride=").append(String.valueOf(this.preambleOverride));
        sb.append(", isStream=").append(String.valueOf(this.isStream));
        sb.append(", maxTokens=").append(String.valueOf(this.maxTokens));
        sb.append(", temperature=").append(String.valueOf(this.temperature));
        sb.append(", topK=").append(String.valueOf(this.topK));
        sb.append(", topP=").append(String.valueOf(this.topP));
        sb.append(", promptTruncation=").append(String.valueOf((Object)this.promptTruncation));
        sb.append(", frequencyPenalty=").append(String.valueOf(this.frequencyPenalty));
        sb.append(", presencePenalty=").append(String.valueOf(this.presencePenalty));
        sb.append(", seed=").append(String.valueOf(this.seed));
        sb.append(", isEcho=").append(String.valueOf(this.isEcho));
        sb.append(", tools=").append(String.valueOf(this.tools));
        sb.append(", toolResults=").append(String.valueOf(this.toolResults));
        sb.append(", isForceSingleStep=").append(String.valueOf(this.isForceSingleStep));
        sb.append(", stopSequences=").append(String.valueOf(this.stopSequences));
        sb.append(", isRawPrompting=").append(String.valueOf(this.isRawPrompting));
        sb.append(", citationQuality=").append(String.valueOf((Object)this.citationQuality));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CohereChatRequest)) {
            return false;
        }
        CohereChatRequest other = (CohereChatRequest)((Object)o);
        return Objects.equals(this.message, other.message) && Objects.equals(this.chatHistory, other.chatHistory) && Objects.equals(this.documents, other.documents) && Objects.equals(this.isSearchQueriesOnly, other.isSearchQueriesOnly) && Objects.equals(this.preambleOverride, other.preambleOverride) && Objects.equals(this.isStream, other.isStream) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topK, other.topK) && Objects.equals(this.topP, other.topP) && Objects.equals((Object)this.promptTruncation, (Object)other.promptTruncation) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.seed, other.seed) && Objects.equals(this.isEcho, other.isEcho) && Objects.equals(this.tools, other.tools) && Objects.equals(this.toolResults, other.toolResults) && Objects.equals(this.isForceSingleStep, other.isForceSingleStep) && Objects.equals(this.stopSequences, other.stopSequences) && Objects.equals(this.isRawPrompting, other.isRawPrompting) && Objects.equals((Object)this.citationQuality, (Object)other.citationQuality) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.chatHistory == null ? 43 : this.chatHistory.hashCode());
        result = result * 59 + (this.documents == null ? 43 : this.documents.hashCode());
        result = result * 59 + (this.isSearchQueriesOnly == null ? 43 : this.isSearchQueriesOnly.hashCode());
        result = result * 59 + (this.preambleOverride == null ? 43 : this.preambleOverride.hashCode());
        result = result * 59 + (this.isStream == null ? 43 : this.isStream.hashCode());
        result = result * 59 + (this.maxTokens == null ? 43 : this.maxTokens.hashCode());
        result = result * 59 + (this.temperature == null ? 43 : this.temperature.hashCode());
        result = result * 59 + (this.topK == null ? 43 : this.topK.hashCode());
        result = result * 59 + (this.topP == null ? 43 : this.topP.hashCode());
        result = result * 59 + (this.promptTruncation == null ? 43 : this.promptTruncation.hashCode());
        result = result * 59 + (this.frequencyPenalty == null ? 43 : this.frequencyPenalty.hashCode());
        result = result * 59 + (this.presencePenalty == null ? 43 : this.presencePenalty.hashCode());
        result = result * 59 + (this.seed == null ? 43 : this.seed.hashCode());
        result = result * 59 + (this.isEcho == null ? 43 : this.isEcho.hashCode());
        result = result * 59 + (this.tools == null ? 43 : this.tools.hashCode());
        result = result * 59 + (this.toolResults == null ? 43 : this.toolResults.hashCode());
        result = result * 59 + (this.isForceSingleStep == null ? 43 : this.isForceSingleStep.hashCode());
        result = result * 59 + (this.stopSequences == null ? 43 : this.stopSequences.hashCode());
        result = result * 59 + (this.isRawPrompting == null ? 43 : this.isRawPrompting.hashCode());
        result = result * 59 + (this.citationQuality == null ? 43 : this.citationQuality.hashCode());
        return result;
    }

    public static enum CitationQuality implements BmcEnum
    {
        Accurate("ACCURATE"),
        Fast("FAST");

        private final String value;
        private static Map<String, CitationQuality> map;

        private CitationQuality(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CitationQuality create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CitationQuality: " + key);
        }

        static {
            map = new HashMap<String, CitationQuality>();
            for (CitationQuality v : CitationQuality.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PromptTruncation implements BmcEnum
    {
        Off("OFF"),
        AutoPreserveOrder("AUTO_PRESERVE_ORDER");

        private final String value;
        private static Map<String, PromptTruncation> map;

        private PromptTruncation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PromptTruncation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PromptTruncation: " + key);
        }

        static {
            map = new HashMap<String, PromptTruncation>();
            for (PromptTruncation v : PromptTruncation.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="chatHistory")
        private List<CohereMessage> chatHistory;
        @JsonProperty(value="documents")
        private List<Object> documents;
        @JsonProperty(value="isSearchQueriesOnly")
        private Boolean isSearchQueriesOnly;
        @JsonProperty(value="preambleOverride")
        private String preambleOverride;
        @JsonProperty(value="isStream")
        private Boolean isStream;
        @JsonProperty(value="maxTokens")
        private Integer maxTokens;
        @JsonProperty(value="temperature")
        private Double temperature;
        @JsonProperty(value="topK")
        private Integer topK;
        @JsonProperty(value="topP")
        private Double topP;
        @JsonProperty(value="promptTruncation")
        private PromptTruncation promptTruncation;
        @JsonProperty(value="frequencyPenalty")
        private Double frequencyPenalty;
        @JsonProperty(value="presencePenalty")
        private Double presencePenalty;
        @JsonProperty(value="seed")
        private Integer seed;
        @JsonProperty(value="isEcho")
        private Boolean isEcho;
        @JsonProperty(value="tools")
        private List<CohereTool> tools;
        @JsonProperty(value="toolResults")
        private List<CohereToolResult> toolResults;
        @JsonProperty(value="isForceSingleStep")
        private Boolean isForceSingleStep;
        @JsonProperty(value="stopSequences")
        private List<String> stopSequences;
        @JsonProperty(value="isRawPrompting")
        private Boolean isRawPrompting;
        @JsonProperty(value="citationQuality")
        private CitationQuality citationQuality;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder chatHistory(List<CohereMessage> chatHistory) {
            this.chatHistory = chatHistory;
            this.__explicitlySet__.add("chatHistory");
            return this;
        }

        public Builder documents(List<Object> documents) {
            this.documents = documents;
            this.__explicitlySet__.add("documents");
            return this;
        }

        public Builder isSearchQueriesOnly(Boolean isSearchQueriesOnly) {
            this.isSearchQueriesOnly = isSearchQueriesOnly;
            this.__explicitlySet__.add("isSearchQueriesOnly");
            return this;
        }

        public Builder preambleOverride(String preambleOverride) {
            this.preambleOverride = preambleOverride;
            this.__explicitlySet__.add("preambleOverride");
            return this;
        }

        public Builder isStream(Boolean isStream) {
            this.isStream = isStream;
            this.__explicitlySet__.add("isStream");
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            this.__explicitlySet__.add("maxTokens");
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            this.__explicitlySet__.add("temperature");
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            this.__explicitlySet__.add("topK");
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            this.__explicitlySet__.add("topP");
            return this;
        }

        public Builder promptTruncation(PromptTruncation promptTruncation) {
            this.promptTruncation = promptTruncation;
            this.__explicitlySet__.add("promptTruncation");
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            this.__explicitlySet__.add("frequencyPenalty");
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            this.__explicitlySet__.add("presencePenalty");
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            this.__explicitlySet__.add("seed");
            return this;
        }

        public Builder isEcho(Boolean isEcho) {
            this.isEcho = isEcho;
            this.__explicitlySet__.add("isEcho");
            return this;
        }

        public Builder tools(List<CohereTool> tools) {
            this.tools = tools;
            this.__explicitlySet__.add("tools");
            return this;
        }

        public Builder toolResults(List<CohereToolResult> toolResults) {
            this.toolResults = toolResults;
            this.__explicitlySet__.add("toolResults");
            return this;
        }

        public Builder isForceSingleStep(Boolean isForceSingleStep) {
            this.isForceSingleStep = isForceSingleStep;
            this.__explicitlySet__.add("isForceSingleStep");
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            this.__explicitlySet__.add("stopSequences");
            return this;
        }

        public Builder isRawPrompting(Boolean isRawPrompting) {
            this.isRawPrompting = isRawPrompting;
            this.__explicitlySet__.add("isRawPrompting");
            return this;
        }

        public Builder citationQuality(CitationQuality citationQuality) {
            this.citationQuality = citationQuality;
            this.__explicitlySet__.add("citationQuality");
            return this;
        }

        public CohereChatRequest build() {
            CohereChatRequest model = new CohereChatRequest(this.message, this.chatHistory, this.documents, this.isSearchQueriesOnly, this.preambleOverride, this.isStream, this.maxTokens, this.temperature, this.topK, this.topP, this.promptTruncation, this.frequencyPenalty, this.presencePenalty, this.seed, this.isEcho, this.tools, this.toolResults, this.isForceSingleStep, this.stopSequences, this.isRawPrompting, this.citationQuality);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CohereChatRequest model) {
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("chatHistory")) {
                this.chatHistory(model.getChatHistory());
            }
            if (model.wasPropertyExplicitlySet("documents")) {
                this.documents(model.getDocuments());
            }
            if (model.wasPropertyExplicitlySet("isSearchQueriesOnly")) {
                this.isSearchQueriesOnly(model.getIsSearchQueriesOnly());
            }
            if (model.wasPropertyExplicitlySet("preambleOverride")) {
                this.preambleOverride(model.getPreambleOverride());
            }
            if (model.wasPropertyExplicitlySet("isStream")) {
                this.isStream(model.getIsStream());
            }
            if (model.wasPropertyExplicitlySet("maxTokens")) {
                this.maxTokens(model.getMaxTokens());
            }
            if (model.wasPropertyExplicitlySet("temperature")) {
                this.temperature(model.getTemperature());
            }
            if (model.wasPropertyExplicitlySet("topK")) {
                this.topK(model.getTopK());
            }
            if (model.wasPropertyExplicitlySet("topP")) {
                this.topP(model.getTopP());
            }
            if (model.wasPropertyExplicitlySet("promptTruncation")) {
                this.promptTruncation(model.getPromptTruncation());
            }
            if (model.wasPropertyExplicitlySet("frequencyPenalty")) {
                this.frequencyPenalty(model.getFrequencyPenalty());
            }
            if (model.wasPropertyExplicitlySet("presencePenalty")) {
                this.presencePenalty(model.getPresencePenalty());
            }
            if (model.wasPropertyExplicitlySet("seed")) {
                this.seed(model.getSeed());
            }
            if (model.wasPropertyExplicitlySet("isEcho")) {
                this.isEcho(model.getIsEcho());
            }
            if (model.wasPropertyExplicitlySet("tools")) {
                this.tools(model.getTools());
            }
            if (model.wasPropertyExplicitlySet("toolResults")) {
                this.toolResults(model.getToolResults());
            }
            if (model.wasPropertyExplicitlySet("isForceSingleStep")) {
                this.isForceSingleStep(model.getIsForceSingleStep());
            }
            if (model.wasPropertyExplicitlySet("stopSequences")) {
                this.stopSequences(model.getStopSequences());
            }
            if (model.wasPropertyExplicitlySet("isRawPrompting")) {
                this.isRawPrompting(model.getIsRawPrompting());
            }
            if (model.wasPropertyExplicitlySet("citationQuality")) {
                this.citationQuality(model.getCitationQuality());
            }
            return this;
        }
    }
}

