/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.BaseChatResponse;
import com.oracle.bmc.generativeaiinference.model.Citation;
import com.oracle.bmc.generativeaiinference.model.CohereMessage;
import com.oracle.bmc.generativeaiinference.model.CohereToolCall;
import com.oracle.bmc.generativeaiinference.model.SearchQuery;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="apiFormat")
@JsonFilter(value="explicitlySetFilter")
public final class CohereChatResponse
extends BaseChatResponse {
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="chatHistory")
    private final List<CohereMessage> chatHistory;
    @JsonProperty(value="citations")
    private final List<Citation> citations;
    @JsonProperty(value="isSearchRequired")
    private final Boolean isSearchRequired;
    @JsonProperty(value="finishReason")
    private final FinishReason finishReason;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="searchQueries")
    private final List<SearchQuery> searchQueries;
    @JsonProperty(value="documents")
    private final List<Object> documents;
    @JsonProperty(value="toolCalls")
    private final List<CohereToolCall> toolCalls;
    @JsonProperty(value="prompt")
    private final String prompt;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CohereChatResponse(String text, List<CohereMessage> chatHistory, List<Citation> citations, Boolean isSearchRequired, FinishReason finishReason, String errorMessage, List<SearchQuery> searchQueries, List<Object> documents, List<CohereToolCall> toolCalls, String prompt) {
        this.text = text;
        this.chatHistory = chatHistory;
        this.citations = citations;
        this.isSearchRequired = isSearchRequired;
        this.finishReason = finishReason;
        this.errorMessage = errorMessage;
        this.searchQueries = searchQueries;
        this.documents = documents;
        this.toolCalls = toolCalls;
        this.prompt = prompt;
    }

    public String getText() {
        return this.text;
    }

    public List<CohereMessage> getChatHistory() {
        return this.chatHistory;
    }

    public List<Citation> getCitations() {
        return this.citations;
    }

    public Boolean getIsSearchRequired() {
        return this.isSearchRequired;
    }

    public FinishReason getFinishReason() {
        return this.finishReason;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<SearchQuery> getSearchQueries() {
        return this.searchQueries;
    }

    public List<Object> getDocuments() {
        return this.documents;
    }

    public List<CohereToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CohereChatResponse(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", text=").append(String.valueOf(this.text));
        sb.append(", chatHistory=").append(String.valueOf(this.chatHistory));
        sb.append(", citations=").append(String.valueOf(this.citations));
        sb.append(", isSearchRequired=").append(String.valueOf(this.isSearchRequired));
        sb.append(", finishReason=").append(String.valueOf((Object)this.finishReason));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", searchQueries=").append(String.valueOf(this.searchQueries));
        sb.append(", documents=").append(String.valueOf(this.documents));
        sb.append(", toolCalls=").append(String.valueOf(this.toolCalls));
        sb.append(", prompt=").append(String.valueOf(this.prompt));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CohereChatResponse)) {
            return false;
        }
        CohereChatResponse other = (CohereChatResponse)((Object)o);
        return Objects.equals(this.text, other.text) && Objects.equals(this.chatHistory, other.chatHistory) && Objects.equals(this.citations, other.citations) && Objects.equals(this.isSearchRequired, other.isSearchRequired) && Objects.equals((Object)this.finishReason, (Object)other.finishReason) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.searchQueries, other.searchQueries) && Objects.equals(this.documents, other.documents) && Objects.equals(this.toolCalls, other.toolCalls) && Objects.equals(this.prompt, other.prompt) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.text == null ? 43 : this.text.hashCode());
        result = result * 59 + (this.chatHistory == null ? 43 : this.chatHistory.hashCode());
        result = result * 59 + (this.citations == null ? 43 : this.citations.hashCode());
        result = result * 59 + (this.isSearchRequired == null ? 43 : this.isSearchRequired.hashCode());
        result = result * 59 + (this.finishReason == null ? 43 : this.finishReason.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.searchQueries == null ? 43 : this.searchQueries.hashCode());
        result = result * 59 + (this.documents == null ? 43 : this.documents.hashCode());
        result = result * 59 + (this.toolCalls == null ? 43 : this.toolCalls.hashCode());
        result = result * 59 + (this.prompt == null ? 43 : this.prompt.hashCode());
        return result;
    }

    public static enum FinishReason implements BmcEnum
    {
        Complete("COMPLETE"),
        ErrorToxic("ERROR_TOXIC"),
        ErrorLimit("ERROR_LIMIT"),
        Error("ERROR"),
        UserCancel("USER_CANCEL"),
        MaxTokens("MAX_TOKENS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FinishReason> map;

        private FinishReason(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FinishReason create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FinishReason', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FinishReason.class);
            map = new HashMap<String, FinishReason>();
            for (FinishReason v : FinishReason.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="chatHistory")
        private List<CohereMessage> chatHistory;
        @JsonProperty(value="citations")
        private List<Citation> citations;
        @JsonProperty(value="isSearchRequired")
        private Boolean isSearchRequired;
        @JsonProperty(value="finishReason")
        private FinishReason finishReason;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="searchQueries")
        private List<SearchQuery> searchQueries;
        @JsonProperty(value="documents")
        private List<Object> documents;
        @JsonProperty(value="toolCalls")
        private List<CohereToolCall> toolCalls;
        @JsonProperty(value="prompt")
        private String prompt;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder text(String text) {
            this.text = text;
            this.__explicitlySet__.add("text");
            return this;
        }

        public Builder chatHistory(List<CohereMessage> chatHistory) {
            this.chatHistory = chatHistory;
            this.__explicitlySet__.add("chatHistory");
            return this;
        }

        public Builder citations(List<Citation> citations) {
            this.citations = citations;
            this.__explicitlySet__.add("citations");
            return this;
        }

        public Builder isSearchRequired(Boolean isSearchRequired) {
            this.isSearchRequired = isSearchRequired;
            this.__explicitlySet__.add("isSearchRequired");
            return this;
        }

        public Builder finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            this.__explicitlySet__.add("finishReason");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder searchQueries(List<SearchQuery> searchQueries) {
            this.searchQueries = searchQueries;
            this.__explicitlySet__.add("searchQueries");
            return this;
        }

        public Builder documents(List<Object> documents) {
            this.documents = documents;
            this.__explicitlySet__.add("documents");
            return this;
        }

        public Builder toolCalls(List<CohereToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            this.__explicitlySet__.add("toolCalls");
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            this.__explicitlySet__.add("prompt");
            return this;
        }

        public CohereChatResponse build() {
            CohereChatResponse model = new CohereChatResponse(this.text, this.chatHistory, this.citations, this.isSearchRequired, this.finishReason, this.errorMessage, this.searchQueries, this.documents, this.toolCalls, this.prompt);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CohereChatResponse model) {
            if (model.wasPropertyExplicitlySet("text")) {
                this.text(model.getText());
            }
            if (model.wasPropertyExplicitlySet("chatHistory")) {
                this.chatHistory(model.getChatHistory());
            }
            if (model.wasPropertyExplicitlySet("citations")) {
                this.citations(model.getCitations());
            }
            if (model.wasPropertyExplicitlySet("isSearchRequired")) {
                this.isSearchRequired(model.getIsSearchRequired());
            }
            if (model.wasPropertyExplicitlySet("finishReason")) {
                this.finishReason(model.getFinishReason());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("searchQueries")) {
                this.searchQueries(model.getSearchQueries());
            }
            if (model.wasPropertyExplicitlySet("documents")) {
                this.documents(model.getDocuments());
            }
            if (model.wasPropertyExplicitlySet("toolCalls")) {
                this.toolCalls(model.getToolCalls());
            }
            if (model.wasPropertyExplicitlySet("prompt")) {
                this.prompt(model.getPrompt());
            }
            return this;
        }
    }
}

