/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.responses;

import com.oracle.bmc.generativeaiinference.model.EmbedTextResult;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EmbedTextResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private EmbedTextResult embedTextResult;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public EmbedTextResult getEmbedTextResult() {
        return this.embedTextResult;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "embedTextResult"})
    private EmbedTextResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, EmbedTextResult embedTextResult) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.embedTextResult = embedTextResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",embedTextResult=").append(String.valueOf((Object)this.embedTextResult));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmbedTextResponse)) {
            return false;
        }
        EmbedTextResponse other = (EmbedTextResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.embedTextResult, (Object)other.embedTextResult);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.embedTextResult == null ? 43 : this.embedTextResult.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<EmbedTextResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private EmbedTextResult embedTextResult;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder embedTextResult(EmbedTextResult embedTextResult) {
            this.embedTextResult = embedTextResult;
            return this;
        }

        public Builder copy(EmbedTextResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.embedTextResult(o.getEmbedTextResult());
            return this;
        }

        public EmbedTextResponse build() {
            return new EmbedTextResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.embedTextResult);
        }
    }
}

