/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.BaseChatRequest;
import com.oracle.bmc.generativeaiinference.model.Message;
import com.oracle.bmc.generativeaiinference.model.Prediction;
import com.oracle.bmc.generativeaiinference.model.ResponseFormat;
import com.oracle.bmc.generativeaiinference.model.StreamOptions;
import com.oracle.bmc.generativeaiinference.model.ToolChoice;
import com.oracle.bmc.generativeaiinference.model.ToolDefinition;
import com.oracle.bmc.generativeaiinference.model.WebSearchOptions;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="apiFormat")
@JsonFilter(value="explicitlySetFilter")
public final class GenericChatRequest
extends BaseChatRequest {
    @JsonProperty(value="messages")
    private final List<Message> messages;
    @JsonProperty(value="reasoningEffort")
    private final ReasoningEffort reasoningEffort;
    @JsonProperty(value="verbosity")
    private final Verbosity verbosity;
    @JsonProperty(value="metadata")
    private final Object metadata;
    @JsonProperty(value="isStream")
    private final Boolean isStream;
    @JsonProperty(value="streamOptions")
    private final StreamOptions streamOptions;
    @JsonProperty(value="numGenerations")
    private final Integer numGenerations;
    @JsonProperty(value="seed")
    private final Integer seed;
    @JsonProperty(value="isEcho")
    private final Boolean isEcho;
    @JsonProperty(value="topK")
    private final Integer topK;
    @JsonProperty(value="topP")
    private final Double topP;
    @JsonProperty(value="temperature")
    private final Double temperature;
    @JsonProperty(value="frequencyPenalty")
    private final Double frequencyPenalty;
    @JsonProperty(value="presencePenalty")
    private final Double presencePenalty;
    @JsonProperty(value="stop")
    private final List<String> stop;
    @JsonProperty(value="logProbs")
    private final Integer logProbs;
    @JsonProperty(value="maxTokens")
    private final Integer maxTokens;
    @JsonProperty(value="maxCompletionTokens")
    private final Integer maxCompletionTokens;
    @JsonProperty(value="logitBias")
    private final Object logitBias;
    @JsonProperty(value="prediction")
    private final Prediction prediction;
    @JsonProperty(value="responseFormat")
    private final ResponseFormat responseFormat;
    @JsonProperty(value="toolChoice")
    private final ToolChoice toolChoice;
    @JsonProperty(value="isParallelToolCalls")
    private final Boolean isParallelToolCalls;
    @JsonProperty(value="tools")
    private final List<ToolDefinition> tools;
    @JsonProperty(value="webSearchOptions")
    private final WebSearchOptions webSearchOptions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GenericChatRequest(List<Message> messages, ReasoningEffort reasoningEffort, Verbosity verbosity, Object metadata, Boolean isStream, StreamOptions streamOptions, Integer numGenerations, Integer seed, Boolean isEcho, Integer topK, Double topP, Double temperature, Double frequencyPenalty, Double presencePenalty, List<String> stop, Integer logProbs, Integer maxTokens, Integer maxCompletionTokens, Object logitBias, Prediction prediction, ResponseFormat responseFormat, ToolChoice toolChoice, Boolean isParallelToolCalls, List<ToolDefinition> tools, WebSearchOptions webSearchOptions) {
        this.messages = messages;
        this.reasoningEffort = reasoningEffort;
        this.verbosity = verbosity;
        this.metadata = metadata;
        this.isStream = isStream;
        this.streamOptions = streamOptions;
        this.numGenerations = numGenerations;
        this.seed = seed;
        this.isEcho = isEcho;
        this.topK = topK;
        this.topP = topP;
        this.temperature = temperature;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.stop = stop;
        this.logProbs = logProbs;
        this.maxTokens = maxTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.logitBias = logitBias;
        this.prediction = prediction;
        this.responseFormat = responseFormat;
        this.toolChoice = toolChoice;
        this.isParallelToolCalls = isParallelToolCalls;
        this.tools = tools;
        this.webSearchOptions = webSearchOptions;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public ReasoningEffort getReasoningEffort() {
        return this.reasoningEffort;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public Boolean getIsStream() {
        return this.isStream;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public Integer getNumGenerations() {
        return this.numGenerations;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Boolean getIsEcho() {
        return this.isEcho;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getLogProbs() {
        return this.logProbs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public Object getLogitBias() {
        return this.logitBias;
    }

    public Prediction getPrediction() {
        return this.prediction;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getIsParallelToolCalls() {
        return this.isParallelToolCalls;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public WebSearchOptions getWebSearchOptions() {
        return this.webSearchOptions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericChatRequest(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", messages=").append(String.valueOf(this.messages));
        sb.append(", reasoningEffort=").append(String.valueOf((Object)this.reasoningEffort));
        sb.append(", verbosity=").append(String.valueOf((Object)this.verbosity));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", isStream=").append(String.valueOf(this.isStream));
        sb.append(", streamOptions=").append(String.valueOf((Object)this.streamOptions));
        sb.append(", numGenerations=").append(String.valueOf(this.numGenerations));
        sb.append(", seed=").append(String.valueOf(this.seed));
        sb.append(", isEcho=").append(String.valueOf(this.isEcho));
        sb.append(", topK=").append(String.valueOf(this.topK));
        sb.append(", topP=").append(String.valueOf(this.topP));
        sb.append(", temperature=").append(String.valueOf(this.temperature));
        sb.append(", frequencyPenalty=").append(String.valueOf(this.frequencyPenalty));
        sb.append(", presencePenalty=").append(String.valueOf(this.presencePenalty));
        sb.append(", stop=").append(String.valueOf(this.stop));
        sb.append(", logProbs=").append(String.valueOf(this.logProbs));
        sb.append(", maxTokens=").append(String.valueOf(this.maxTokens));
        sb.append(", maxCompletionTokens=").append(String.valueOf(this.maxCompletionTokens));
        sb.append(", logitBias=").append(String.valueOf(this.logitBias));
        sb.append(", prediction=").append(String.valueOf((Object)this.prediction));
        sb.append(", responseFormat=").append(String.valueOf((Object)this.responseFormat));
        sb.append(", toolChoice=").append(String.valueOf((Object)this.toolChoice));
        sb.append(", isParallelToolCalls=").append(String.valueOf(this.isParallelToolCalls));
        sb.append(", tools=").append(String.valueOf(this.tools));
        sb.append(", webSearchOptions=").append(String.valueOf((Object)this.webSearchOptions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericChatRequest)) {
            return false;
        }
        GenericChatRequest other = (GenericChatRequest)((Object)o);
        return Objects.equals(this.messages, other.messages) && Objects.equals((Object)this.reasoningEffort, (Object)other.reasoningEffort) && Objects.equals((Object)this.verbosity, (Object)other.verbosity) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.isStream, other.isStream) && Objects.equals((Object)this.streamOptions, (Object)other.streamOptions) && Objects.equals(this.numGenerations, other.numGenerations) && Objects.equals(this.seed, other.seed) && Objects.equals(this.isEcho, other.isEcho) && Objects.equals(this.topK, other.topK) && Objects.equals(this.topP, other.topP) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.stop, other.stop) && Objects.equals(this.logProbs, other.logProbs) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.maxCompletionTokens, other.maxCompletionTokens) && Objects.equals(this.logitBias, other.logitBias) && Objects.equals((Object)this.prediction, (Object)other.prediction) && Objects.equals((Object)this.responseFormat, (Object)other.responseFormat) && Objects.equals((Object)this.toolChoice, (Object)other.toolChoice) && Objects.equals(this.isParallelToolCalls, other.isParallelToolCalls) && Objects.equals(this.tools, other.tools) && Objects.equals((Object)this.webSearchOptions, (Object)other.webSearchOptions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.messages == null ? 43 : this.messages.hashCode());
        result = result * 59 + (this.reasoningEffort == null ? 43 : this.reasoningEffort.hashCode());
        result = result * 59 + (this.verbosity == null ? 43 : this.verbosity.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.isStream == null ? 43 : this.isStream.hashCode());
        result = result * 59 + (this.streamOptions == null ? 43 : this.streamOptions.hashCode());
        result = result * 59 + (this.numGenerations == null ? 43 : this.numGenerations.hashCode());
        result = result * 59 + (this.seed == null ? 43 : this.seed.hashCode());
        result = result * 59 + (this.isEcho == null ? 43 : this.isEcho.hashCode());
        result = result * 59 + (this.topK == null ? 43 : this.topK.hashCode());
        result = result * 59 + (this.topP == null ? 43 : this.topP.hashCode());
        result = result * 59 + (this.temperature == null ? 43 : this.temperature.hashCode());
        result = result * 59 + (this.frequencyPenalty == null ? 43 : this.frequencyPenalty.hashCode());
        result = result * 59 + (this.presencePenalty == null ? 43 : this.presencePenalty.hashCode());
        result = result * 59 + (this.stop == null ? 43 : this.stop.hashCode());
        result = result * 59 + (this.logProbs == null ? 43 : this.logProbs.hashCode());
        result = result * 59 + (this.maxTokens == null ? 43 : this.maxTokens.hashCode());
        result = result * 59 + (this.maxCompletionTokens == null ? 43 : this.maxCompletionTokens.hashCode());
        result = result * 59 + (this.logitBias == null ? 43 : this.logitBias.hashCode());
        result = result * 59 + (this.prediction == null ? 43 : this.prediction.hashCode());
        result = result * 59 + (this.responseFormat == null ? 43 : this.responseFormat.hashCode());
        result = result * 59 + (this.toolChoice == null ? 43 : this.toolChoice.hashCode());
        result = result * 59 + (this.isParallelToolCalls == null ? 43 : this.isParallelToolCalls.hashCode());
        result = result * 59 + (this.tools == null ? 43 : this.tools.hashCode());
        result = result * 59 + (this.webSearchOptions == null ? 43 : this.webSearchOptions.hashCode());
        return result;
    }

    public static enum Verbosity implements BmcEnum
    {
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH");

        private final String value;
        private static Map<String, Verbosity> map;

        private Verbosity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Verbosity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Verbosity: " + key);
        }

        static {
            map = new HashMap<String, Verbosity>();
            for (Verbosity v : Verbosity.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ReasoningEffort implements BmcEnum
    {
        Minimal("MINIMAL"),
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH");

        private final String value;
        private static Map<String, ReasoningEffort> map;

        private ReasoningEffort(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReasoningEffort create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReasoningEffort: " + key);
        }

        static {
            map = new HashMap<String, ReasoningEffort>();
            for (ReasoningEffort v : ReasoningEffort.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="messages")
        private List<Message> messages;
        @JsonProperty(value="reasoningEffort")
        private ReasoningEffort reasoningEffort;
        @JsonProperty(value="verbosity")
        private Verbosity verbosity;
        @JsonProperty(value="metadata")
        private Object metadata;
        @JsonProperty(value="isStream")
        private Boolean isStream;
        @JsonProperty(value="streamOptions")
        private StreamOptions streamOptions;
        @JsonProperty(value="numGenerations")
        private Integer numGenerations;
        @JsonProperty(value="seed")
        private Integer seed;
        @JsonProperty(value="isEcho")
        private Boolean isEcho;
        @JsonProperty(value="topK")
        private Integer topK;
        @JsonProperty(value="topP")
        private Double topP;
        @JsonProperty(value="temperature")
        private Double temperature;
        @JsonProperty(value="frequencyPenalty")
        private Double frequencyPenalty;
        @JsonProperty(value="presencePenalty")
        private Double presencePenalty;
        @JsonProperty(value="stop")
        private List<String> stop;
        @JsonProperty(value="logProbs")
        private Integer logProbs;
        @JsonProperty(value="maxTokens")
        private Integer maxTokens;
        @JsonProperty(value="maxCompletionTokens")
        private Integer maxCompletionTokens;
        @JsonProperty(value="logitBias")
        private Object logitBias;
        @JsonProperty(value="prediction")
        private Prediction prediction;
        @JsonProperty(value="responseFormat")
        private ResponseFormat responseFormat;
        @JsonProperty(value="toolChoice")
        private ToolChoice toolChoice;
        @JsonProperty(value="isParallelToolCalls")
        private Boolean isParallelToolCalls;
        @JsonProperty(value="tools")
        private List<ToolDefinition> tools;
        @JsonProperty(value="webSearchOptions")
        private WebSearchOptions webSearchOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            this.__explicitlySet__.add("messages");
            return this;
        }

        public Builder reasoningEffort(ReasoningEffort reasoningEffort) {
            this.reasoningEffort = reasoningEffort;
            this.__explicitlySet__.add("reasoningEffort");
            return this;
        }

        public Builder verbosity(Verbosity verbosity) {
            this.verbosity = verbosity;
            this.__explicitlySet__.add("verbosity");
            return this;
        }

        public Builder metadata(Object metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder isStream(Boolean isStream) {
            this.isStream = isStream;
            this.__explicitlySet__.add("isStream");
            return this;
        }

        public Builder streamOptions(StreamOptions streamOptions) {
            this.streamOptions = streamOptions;
            this.__explicitlySet__.add("streamOptions");
            return this;
        }

        public Builder numGenerations(Integer numGenerations) {
            this.numGenerations = numGenerations;
            this.__explicitlySet__.add("numGenerations");
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            this.__explicitlySet__.add("seed");
            return this;
        }

        public Builder isEcho(Boolean isEcho) {
            this.isEcho = isEcho;
            this.__explicitlySet__.add("isEcho");
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            this.__explicitlySet__.add("topK");
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            this.__explicitlySet__.add("topP");
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            this.__explicitlySet__.add("temperature");
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            this.__explicitlySet__.add("frequencyPenalty");
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            this.__explicitlySet__.add("presencePenalty");
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            this.__explicitlySet__.add("stop");
            return this;
        }

        public Builder logProbs(Integer logProbs) {
            this.logProbs = logProbs;
            this.__explicitlySet__.add("logProbs");
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            this.__explicitlySet__.add("maxTokens");
            return this;
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            this.__explicitlySet__.add("maxCompletionTokens");
            return this;
        }

        public Builder logitBias(Object logitBias) {
            this.logitBias = logitBias;
            this.__explicitlySet__.add("logitBias");
            return this;
        }

        public Builder prediction(Prediction prediction) {
            this.prediction = prediction;
            this.__explicitlySet__.add("prediction");
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            this.__explicitlySet__.add("responseFormat");
            return this;
        }

        public Builder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            this.__explicitlySet__.add("toolChoice");
            return this;
        }

        public Builder isParallelToolCalls(Boolean isParallelToolCalls) {
            this.isParallelToolCalls = isParallelToolCalls;
            this.__explicitlySet__.add("isParallelToolCalls");
            return this;
        }

        public Builder tools(List<ToolDefinition> tools) {
            this.tools = tools;
            this.__explicitlySet__.add("tools");
            return this;
        }

        public Builder webSearchOptions(WebSearchOptions webSearchOptions) {
            this.webSearchOptions = webSearchOptions;
            this.__explicitlySet__.add("webSearchOptions");
            return this;
        }

        public GenericChatRequest build() {
            GenericChatRequest model = new GenericChatRequest(this.messages, this.reasoningEffort, this.verbosity, this.metadata, this.isStream, this.streamOptions, this.numGenerations, this.seed, this.isEcho, this.topK, this.topP, this.temperature, this.frequencyPenalty, this.presencePenalty, this.stop, this.logProbs, this.maxTokens, this.maxCompletionTokens, this.logitBias, this.prediction, this.responseFormat, this.toolChoice, this.isParallelToolCalls, this.tools, this.webSearchOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenericChatRequest model) {
            if (model.wasPropertyExplicitlySet("messages")) {
                this.messages(model.getMessages());
            }
            if (model.wasPropertyExplicitlySet("reasoningEffort")) {
                this.reasoningEffort(model.getReasoningEffort());
            }
            if (model.wasPropertyExplicitlySet("verbosity")) {
                this.verbosity(model.getVerbosity());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("isStream")) {
                this.isStream(model.getIsStream());
            }
            if (model.wasPropertyExplicitlySet("streamOptions")) {
                this.streamOptions(model.getStreamOptions());
            }
            if (model.wasPropertyExplicitlySet("numGenerations")) {
                this.numGenerations(model.getNumGenerations());
            }
            if (model.wasPropertyExplicitlySet("seed")) {
                this.seed(model.getSeed());
            }
            if (model.wasPropertyExplicitlySet("isEcho")) {
                this.isEcho(model.getIsEcho());
            }
            if (model.wasPropertyExplicitlySet("topK")) {
                this.topK(model.getTopK());
            }
            if (model.wasPropertyExplicitlySet("topP")) {
                this.topP(model.getTopP());
            }
            if (model.wasPropertyExplicitlySet("temperature")) {
                this.temperature(model.getTemperature());
            }
            if (model.wasPropertyExplicitlySet("frequencyPenalty")) {
                this.frequencyPenalty(model.getFrequencyPenalty());
            }
            if (model.wasPropertyExplicitlySet("presencePenalty")) {
                this.presencePenalty(model.getPresencePenalty());
            }
            if (model.wasPropertyExplicitlySet("stop")) {
                this.stop(model.getStop());
            }
            if (model.wasPropertyExplicitlySet("logProbs")) {
                this.logProbs(model.getLogProbs());
            }
            if (model.wasPropertyExplicitlySet("maxTokens")) {
                this.maxTokens(model.getMaxTokens());
            }
            if (model.wasPropertyExplicitlySet("maxCompletionTokens")) {
                this.maxCompletionTokens(model.getMaxCompletionTokens());
            }
            if (model.wasPropertyExplicitlySet("logitBias")) {
                this.logitBias(model.getLogitBias());
            }
            if (model.wasPropertyExplicitlySet("prediction")) {
                this.prediction(model.getPrediction());
            }
            if (model.wasPropertyExplicitlySet("responseFormat")) {
                this.responseFormat(model.getResponseFormat());
            }
            if (model.wasPropertyExplicitlySet("toolChoice")) {
                this.toolChoice(model.getToolChoice());
            }
            if (model.wasPropertyExplicitlySet("isParallelToolCalls")) {
                this.isParallelToolCalls(model.getIsParallelToolCalls());
            }
            if (model.wasPropertyExplicitlySet("tools")) {
                this.tools(model.getTools());
            }
            if (model.wasPropertyExplicitlySet("webSearchOptions")) {
                this.webSearchOptions(model.getWebSearchOptions());
            }
            return this;
        }
    }
}

