/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.ApproximateLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WebSearchOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="searchContextSize")
    private final SearchContextSize searchContextSize;
    @JsonProperty(value="userLocation")
    private final ApproximateLocation userLocation;

    @Deprecated
    @ConstructorProperties(value={"searchContextSize", "userLocation"})
    public WebSearchOptions(SearchContextSize searchContextSize, ApproximateLocation userLocation) {
        this.searchContextSize = searchContextSize;
        this.userLocation = userLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public SearchContextSize getSearchContextSize() {
        return this.searchContextSize;
    }

    public ApproximateLocation getUserLocation() {
        return this.userLocation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WebSearchOptions(");
        sb.append("super=").append(super.toString());
        sb.append("searchContextSize=").append(String.valueOf((Object)this.searchContextSize));
        sb.append(", userLocation=").append(String.valueOf((Object)this.userLocation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSearchOptions)) {
            return false;
        }
        WebSearchOptions other = (WebSearchOptions)((Object)o);
        return Objects.equals((Object)this.searchContextSize, (Object)other.searchContextSize) && Objects.equals((Object)this.userLocation, (Object)other.userLocation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.searchContextSize == null ? 43 : this.searchContextSize.hashCode());
        result = result * 59 + (this.userLocation == null ? 43 : this.userLocation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SearchContextSize implements BmcEnum
    {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW");

        private final String value;
        private static Map<String, SearchContextSize> map;

        private SearchContextSize(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SearchContextSize create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SearchContextSize: " + key);
        }

        static {
            map = new HashMap<String, SearchContextSize>();
            for (SearchContextSize v : SearchContextSize.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="searchContextSize")
        private SearchContextSize searchContextSize;
        @JsonProperty(value="userLocation")
        private ApproximateLocation userLocation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder searchContextSize(SearchContextSize searchContextSize) {
            this.searchContextSize = searchContextSize;
            this.__explicitlySet__.add("searchContextSize");
            return this;
        }

        public Builder userLocation(ApproximateLocation userLocation) {
            this.userLocation = userLocation;
            this.__explicitlySet__.add("userLocation");
            return this;
        }

        public WebSearchOptions build() {
            WebSearchOptions model = new WebSearchOptions(this.searchContextSize, this.userLocation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WebSearchOptions model) {
            if (model.wasPropertyExplicitlySet("searchContextSize")) {
                this.searchContextSize(model.getSearchContextSize());
            }
            if (model.wasPropertyExplicitlySet("userLocation")) {
                this.userLocation(model.getUserLocation());
            }
            return this;
        }
    }
}

