/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.globallydistributeddatabase.ShardedDatabaseServiceAsync;
import com.oracle.bmc.globallydistributeddatabase.model.ConnectionString;
import com.oracle.bmc.globallydistributeddatabase.model.PrevalidateShardedDatabaseResult;
import com.oracle.bmc.globallydistributeddatabase.model.PrivateEndpoint;
import com.oracle.bmc.globallydistributeddatabase.model.PrivateEndpointCollection;
import com.oracle.bmc.globallydistributeddatabase.model.ShardableCloudAutonomousVmClusters;
import com.oracle.bmc.globallydistributeddatabase.model.ShardedDatabase;
import com.oracle.bmc.globallydistributeddatabase.model.ShardedDatabaseCollection;
import com.oracle.bmc.globallydistributeddatabase.model.WorkRequest;
import com.oracle.bmc.globallydistributeddatabase.model.WorkRequestErrorCollection;
import com.oracle.bmc.globallydistributeddatabase.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.globallydistributeddatabase.model.WorkRequestSummaryCollection;
import com.oracle.bmc.globallydistributeddatabase.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ChangeShardedDatabaseCompartmentRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ConfigureShardedDatabaseGsmsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ConfigureShardingRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.CreateShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.DeleteShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.DownloadGsmCertificateSigningRequestRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.FetchConnectionStringRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.FetchShardableCloudAutonomousVmClustersRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.GenerateGsmCertificateSigningRequestRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.GenerateWalletRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.GetShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.GetWorkRequestRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListShardedDatabasesRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListWorkRequestsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.PatchShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.PrevalidateShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ReinstateProxyInstanceRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.StartShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.StopShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.UpdateShardedDatabaseRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.UploadSignedCertificateAndGenerateWalletRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ValidateNetworkRequest;
import com.oracle.bmc.globallydistributeddatabase.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ChangeShardedDatabaseCompartmentResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ConfigureShardedDatabaseGsmsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ConfigureShardingResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.CreateShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.DeleteShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.DownloadGsmCertificateSigningRequestResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.FetchConnectionStringResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.FetchShardableCloudAutonomousVmClustersResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.GenerateGsmCertificateSigningRequestResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.GenerateWalletResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.GetShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.GetWorkRequestResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListShardedDatabasesResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListWorkRequestsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.PatchShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.PrevalidateShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ReinstateProxyInstanceResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.StartShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.StopShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.UpdateShardedDatabaseResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.UploadSignedCertificateAndGenerateWalletResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ValidateNetworkResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedDatabaseServiceAsyncClient
extends BaseAsyncClient
implements ShardedDatabaseServiceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SHARDEDDATABASESERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://globaldb.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDatabaseServiceAsyncClient.class);

    ShardedDatabaseServiceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    ShardedDatabaseServiceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ShardedDatabaseServiceAsyncClient", (String)"downloadGsmCertificateSigningRequest,generateWallet"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangePrivateEndpointCompartmentResponse> changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request, AsyncHandler<ChangePrivateEndpointCompartmentRequest, ChangePrivateEndpointCompartmentResponse> handler) {
        Objects.requireNonNull(request.getChangePrivateEndpointCompartmentDetails(), "changePrivateEndpointCompartmentDetails is required");
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ChangePrivateEndpointCompartmentResponse::builder).logger(LOG, "changePrivateEndpointCompartment").serviceDetails("ShardedDatabaseService", "ChangePrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/PrivateEndpoint/ChangePrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangePrivateEndpointCompartmentRequest::builder).basePath("/20230301").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangePrivateEndpointCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangePrivateEndpointCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeShardedDatabaseCompartmentResponse> changeShardedDatabaseCompartment(ChangeShardedDatabaseCompartmentRequest request, AsyncHandler<ChangeShardedDatabaseCompartmentRequest, ChangeShardedDatabaseCompartmentResponse> handler) {
        Objects.requireNonNull(request.getChangeShardedDatabaseCompartmentDetails(), "changeShardedDatabaseCompartmentDetails is required");
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ChangeShardedDatabaseCompartmentResponse::builder).logger(LOG, "changeShardedDatabaseCompartment").serviceDetails("ShardedDatabaseService", "ChangeShardedDatabaseCompartment", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/ChangeShardedDatabaseCompartment").method(Method.POST).requestBuilder(ChangeShardedDatabaseCompartmentRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeShardedDatabaseCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeShardedDatabaseCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ConfigureShardedDatabaseGsmsResponse> configureShardedDatabaseGsms(ConfigureShardedDatabaseGsmsRequest request, AsyncHandler<ConfigureShardedDatabaseGsmsRequest, ConfigureShardedDatabaseGsmsResponse> handler) {
        Objects.requireNonNull(request.getConfigureShardedDatabaseGsmsDetails(), "configureShardedDatabaseGsmsDetails is required");
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ConfigureShardedDatabaseGsmsResponse::builder).logger(LOG, "configureShardedDatabaseGsms").serviceDetails("ShardedDatabaseService", "ConfigureShardedDatabaseGsms", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/ConfigureShardedDatabaseGsms").method(Method.POST).requestBuilder(ConfigureShardedDatabaseGsmsRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("configureGsms").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", ConfigureShardedDatabaseGsmsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ConfigureShardedDatabaseGsmsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ConfigureShardingResponse> configureSharding(ConfigureShardingRequest request, AsyncHandler<ConfigureShardingRequest, ConfigureShardingResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ConfigureShardingResponse::builder).logger(LOG, "configureSharding").serviceDetails("ShardedDatabaseService", "ConfigureSharding", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/ConfigureSharding").method(Method.POST).requestBuilder(ConfigureShardingRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("configureSharding").appendQueryParam("isRebalanceRequired", (Object)request.getIsRebalanceRequired()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", ConfigureShardingResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ConfigureShardingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePrivateEndpointResponse> createPrivateEndpoint(CreatePrivateEndpointRequest request, AsyncHandler<CreatePrivateEndpointRequest, CreatePrivateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreatePrivateEndpointDetails(), "createPrivateEndpointDetails is required");
        return this.clientCall(request, CreatePrivateEndpointResponse::builder).logger(LOG, "createPrivateEndpoint").serviceDetails("ShardedDatabaseService", "CreatePrivateEndpoint", "").method(Method.POST).requestBuilder(CreatePrivateEndpointRequest::builder).basePath("/20230301").appendPathParam("privateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PrivateEndpoint.class, CreatePrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("opc-work-request-id", CreatePrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreatePrivateEndpointResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateShardedDatabaseResponse> createShardedDatabase(CreateShardedDatabaseRequest request, AsyncHandler<CreateShardedDatabaseRequest, CreateShardedDatabaseResponse> handler) {
        Objects.requireNonNull(request.getCreateShardedDatabaseDetails(), "createShardedDatabaseDetails is required");
        return this.clientCall(request, CreateShardedDatabaseResponse::builder).logger(LOG, "createShardedDatabase").serviceDetails("ShardedDatabaseService", "CreateShardedDatabase", "").method(Method.POST).requestBuilder(CreateShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ShardedDatabase.class, CreateShardedDatabaseResponse.Builder::shardedDatabase).handleResponseHeaderString("opc-work-request-id", CreateShardedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateShardedDatabaseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateShardedDatabaseResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeletePrivateEndpointResponse> deletePrivateEndpoint(DeletePrivateEndpointRequest request, AsyncHandler<DeletePrivateEndpointRequest, DeletePrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePrivateEndpointResponse::builder).logger(LOG, "deletePrivateEndpoint").serviceDetails("ShardedDatabaseService", "DeletePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/PrivateEndpoint/DeletePrivateEndpoint").method(Method.DELETE).requestBuilder(DeletePrivateEndpointRequest::builder).basePath("/20230301").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeletePrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteShardedDatabaseResponse> deleteShardedDatabase(DeleteShardedDatabaseRequest request, AsyncHandler<DeleteShardedDatabaseRequest, DeleteShardedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteShardedDatabaseResponse::builder).logger(LOG, "deleteShardedDatabase").serviceDetails("ShardedDatabaseService", "DeleteShardedDatabase", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/DeleteShardedDatabase").method(Method.DELETE).requestBuilder(DeleteShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteShardedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteShardedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DownloadGsmCertificateSigningRequestResponse> downloadGsmCertificateSigningRequest(DownloadGsmCertificateSigningRequestRequest request, AsyncHandler<DownloadGsmCertificateSigningRequestRequest, DownloadGsmCertificateSigningRequestResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DownloadGsmCertificateSigningRequestResponse::builder).logger(LOG, "downloadGsmCertificateSigningRequest").serviceDetails("ShardedDatabaseService", "DownloadGsmCertificateSigningRequest", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/DownloadGsmCertificateSigningRequest").method(Method.POST).requestBuilder(DownloadGsmCertificateSigningRequestRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("downloadGsmCertificateSigningRequest").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(InputStream.class, DownloadGsmCertificateSigningRequestResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", DownloadGsmCertificateSigningRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DownloadGsmCertificateSigningRequestResponse.Builder::etag).handleResponseHeaderLong("content-length", DownloadGsmCertificateSigningRequestResponse.Builder::contentLength).handleResponseHeaderDate("last-modified", DownloadGsmCertificateSigningRequestResponse.Builder::lastModified).callAsync(handler);
    }

    @Override
    public Future<FetchConnectionStringResponse> fetchConnectionString(FetchConnectionStringRequest request, AsyncHandler<FetchConnectionStringRequest, FetchConnectionStringResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, FetchConnectionStringResponse::builder).logger(LOG, "fetchConnectionString").serviceDetails("ShardedDatabaseService", "FetchConnectionString", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/FetchConnectionString").method(Method.POST).requestBuilder(FetchConnectionStringRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("getConnectionString").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(ConnectionString.class, FetchConnectionStringResponse.Builder::connectionString).handleResponseHeaderString("opc-request-id", FetchConnectionStringResponse.Builder::opcRequestId).handleResponseHeaderString("etag", FetchConnectionStringResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<FetchShardableCloudAutonomousVmClustersResponse> fetchShardableCloudAutonomousVmClusters(FetchShardableCloudAutonomousVmClustersRequest request, AsyncHandler<FetchShardableCloudAutonomousVmClustersRequest, FetchShardableCloudAutonomousVmClustersResponse> handler) {
        Objects.requireNonNull(request.getFetchShardableCloudAutonomousVmClustersDetails(), "fetchShardableCloudAutonomousVmClustersDetails is required");
        return this.clientCall(request, FetchShardableCloudAutonomousVmClustersResponse::builder).logger(LOG, "fetchShardableCloudAutonomousVmClusters").serviceDetails("ShardedDatabaseService", "FetchShardableCloudAutonomousVmClusters", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/FetchShardableCloudAutonomousVmClusters").method(Method.POST).requestBuilder(FetchShardableCloudAutonomousVmClustersRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam("actions").appendPathParam("listShardableCloudAutonomousVmClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ShardableCloudAutonomousVmClusters.class, FetchShardableCloudAutonomousVmClustersResponse.Builder::shardableCloudAutonomousVmClusters).handleResponseHeaderString("opc-request-id", FetchShardableCloudAutonomousVmClustersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateGsmCertificateSigningRequestResponse> generateGsmCertificateSigningRequest(GenerateGsmCertificateSigningRequestRequest request, AsyncHandler<GenerateGsmCertificateSigningRequestRequest, GenerateGsmCertificateSigningRequestResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateGsmCertificateSigningRequestResponse::builder).logger(LOG, "generateGsmCertificateSigningRequest").serviceDetails("ShardedDatabaseService", "GenerateGsmCertificateSigningRequest", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/GenerateGsmCertificateSigningRequest").method(Method.POST).requestBuilder(GenerateGsmCertificateSigningRequestRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("generateGsmCertificateSigningRequest").appendQueryParam("caBundleId", (Object)request.getCaBundleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", GenerateGsmCertificateSigningRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GenerateGsmCertificateSigningRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateWalletResponse> generateWallet(GenerateWalletRequest request, AsyncHandler<GenerateWalletRequest, GenerateWalletResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenerateWalletDetails(), "generateWalletDetails is required");
        return this.clientCall(request, GenerateWalletResponse::builder).logger(LOG, "generateWallet").serviceDetails("ShardedDatabaseService", "GenerateWallet", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/GenerateWallet").method(Method.POST).requestBuilder(GenerateWalletRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("generateWallet").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InputStream.class, GenerateWalletResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GenerateWalletResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GenerateWalletResponse.Builder::etag).handleResponseHeaderLong("content-length", GenerateWalletResponse.Builder::contentLength).handleResponseHeaderDate("last-modified", GenerateWalletResponse.Builder::lastModified).callAsync(handler);
    }

    @Override
    public Future<GetPrivateEndpointResponse> getPrivateEndpoint(GetPrivateEndpointRequest request, AsyncHandler<GetPrivateEndpointRequest, GetPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrivateEndpointResponse::builder).logger(LOG, "getPrivateEndpoint").serviceDetails("ShardedDatabaseService", "GetPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/PrivateEndpoint/GetPrivateEndpoint").method(Method.GET).requestBuilder(GetPrivateEndpointRequest::builder).basePath("/20230301").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateEndpoint.class, GetPrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("opc-request-id", GetPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetPrivateEndpointResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetShardedDatabaseResponse> getShardedDatabase(GetShardedDatabaseRequest request, AsyncHandler<GetShardedDatabaseRequest, GetShardedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetShardedDatabaseResponse::builder).logger(LOG, "getShardedDatabase").serviceDetails("ShardedDatabaseService", "GetShardedDatabase", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/GetShardedDatabase").method(Method.GET).requestBuilder(GetShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendQueryParam("metadata", (Object)request.getMetadata()).accept(new String[]{"application/json"}).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ShardedDatabase.class, GetShardedDatabaseResponse.Builder::shardedDatabase).handleResponseHeaderString("opc-request-id", GetShardedDatabaseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetShardedDatabaseResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ShardedDatabaseService", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20230301").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListPrivateEndpointsResponse> listPrivateEndpoints(ListPrivateEndpointsRequest request, AsyncHandler<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListPrivateEndpointsResponse::builder).logger(LOG, "listPrivateEndpoints").serviceDetails("ShardedDatabaseService", "ListPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/PrivateEndpointCollection/ListPrivateEndpoints").method(Method.GET).requestBuilder(ListPrivateEndpointsRequest::builder).basePath("/20230301").appendPathParam("privateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateEndpointCollection.class, ListPrivateEndpointsResponse.Builder::privateEndpointCollection).handleResponseHeaderString("opc-request-id", ListPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPrivateEndpointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListShardedDatabasesResponse> listShardedDatabases(ListShardedDatabasesRequest request, AsyncHandler<ListShardedDatabasesRequest, ListShardedDatabasesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListShardedDatabasesResponse::builder).logger(LOG, "listShardedDatabases").serviceDetails("ShardedDatabaseService", "ListShardedDatabases", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabaseCollection/ListShardedDatabases").method(Method.GET).requestBuilder(ListShardedDatabasesRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ShardedDatabaseCollection.class, ListShardedDatabasesResponse.Builder::shardedDatabaseCollection).handleResponseHeaderString("opc-request-id", ListShardedDatabasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListShardedDatabasesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ShardedDatabaseService", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20230301").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ShardedDatabaseService", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20230301").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ShardedDatabaseService", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20230301").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PatchShardedDatabaseResponse> patchShardedDatabase(PatchShardedDatabaseRequest request, AsyncHandler<PatchShardedDatabaseRequest, PatchShardedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchShardedDatabaseDetails(), "patchShardedDatabaseDetails is required");
        return this.clientCall(request, PatchShardedDatabaseResponse::builder).logger(LOG, "patchShardedDatabase").serviceDetails("ShardedDatabaseService", "PatchShardedDatabase", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/PatchShardedDatabase").method(Method.PATCH).requestBuilder(PatchShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", PatchShardedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PatchShardedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<PrevalidateShardedDatabaseResponse> prevalidateShardedDatabase(PrevalidateShardedDatabaseRequest request, AsyncHandler<PrevalidateShardedDatabaseRequest, PrevalidateShardedDatabaseResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getPrevalidateShardedDatabaseDetails(), "prevalidateShardedDatabaseDetails is required");
        return this.clientCall(request, PrevalidateShardedDatabaseResponse::builder).logger(LOG, "prevalidateShardedDatabase").serviceDetails("ShardedDatabaseService", "PrevalidateShardedDatabase", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/PrevalidateShardedDatabase").method(Method.POST).requestBuilder(PrevalidateShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam("actions").appendPathParam("prevalidate").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PrevalidateShardedDatabaseResult.class, PrevalidateShardedDatabaseResponse.Builder::prevalidateShardedDatabaseResult).handleResponseHeaderString("opc-request-id", PrevalidateShardedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ReinstateProxyInstanceResponse> reinstateProxyInstance(ReinstateProxyInstanceRequest request, AsyncHandler<ReinstateProxyInstanceRequest, ReinstateProxyInstanceResponse> handler) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ReinstateProxyInstanceResponse::builder).logger(LOG, "reinstateProxyInstance").serviceDetails("ShardedDatabaseService", "ReinstateProxyInstance", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/PrivateEndpoint/ReinstateProxyInstance").method(Method.POST).requestBuilder(ReinstateProxyInstanceRequest::builder).basePath("/20230301").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).appendPathParam("actions").appendPathParam("reinstateProxyInstance").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", ReinstateProxyInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ReinstateProxyInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartShardedDatabaseResponse> startShardedDatabase(StartShardedDatabaseRequest request, AsyncHandler<StartShardedDatabaseRequest, StartShardedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartShardedDatabaseResponse::builder).logger(LOG, "startShardedDatabase").serviceDetails("ShardedDatabaseService", "StartShardedDatabase", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/StartShardedDatabase").method(Method.POST).requestBuilder(StartShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("startDatabase").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", StartShardedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartShardedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopShardedDatabaseResponse> stopShardedDatabase(StopShardedDatabaseRequest request, AsyncHandler<StopShardedDatabaseRequest, StopShardedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopShardedDatabaseResponse::builder).logger(LOG, "stopShardedDatabase").serviceDetails("ShardedDatabaseService", "StopShardedDatabase", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/StopShardedDatabase").method(Method.POST).requestBuilder(StopShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("stopDatabase").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", StopShardedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopShardedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePrivateEndpointResponse> updatePrivateEndpoint(UpdatePrivateEndpointRequest request, AsyncHandler<UpdatePrivateEndpointRequest, UpdatePrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePrivateEndpointDetails(), "updatePrivateEndpointDetails is required");
        return this.clientCall(request, UpdatePrivateEndpointResponse::builder).logger(LOG, "updatePrivateEndpoint").serviceDetails("ShardedDatabaseService", "UpdatePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/PrivateEndpoint/UpdatePrivateEndpoint").method(Method.PUT).requestBuilder(UpdatePrivateEndpointRequest::builder).basePath("/20230301").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PrivateEndpoint.class, UpdatePrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("opc-request-id", UpdatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdatePrivateEndpointResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateShardedDatabaseResponse> updateShardedDatabase(UpdateShardedDatabaseRequest request, AsyncHandler<UpdateShardedDatabaseRequest, UpdateShardedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateShardedDatabaseDetails(), "updateShardedDatabaseDetails is required");
        return this.clientCall(request, UpdateShardedDatabaseResponse::builder).logger(LOG, "updateShardedDatabase").serviceDetails("ShardedDatabaseService", "UpdateShardedDatabase", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/UpdateShardedDatabase").method(Method.PUT).requestBuilder(UpdateShardedDatabaseRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ShardedDatabase.class, UpdateShardedDatabaseResponse.Builder::shardedDatabase).handleResponseHeaderString("opc-request-id", UpdateShardedDatabaseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateShardedDatabaseResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UploadSignedCertificateAndGenerateWalletResponse> uploadSignedCertificateAndGenerateWallet(UploadSignedCertificateAndGenerateWalletRequest request, AsyncHandler<UploadSignedCertificateAndGenerateWalletRequest, UploadSignedCertificateAndGenerateWalletResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadSignedCertificateAndGenerateWalletDetails(), "uploadSignedCertificateAndGenerateWalletDetails is required");
        return this.clientCall(request, UploadSignedCertificateAndGenerateWalletResponse::builder).logger(LOG, "uploadSignedCertificateAndGenerateWallet").serviceDetails("ShardedDatabaseService", "UploadSignedCertificateAndGenerateWallet", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/UploadSignedCertificateAndGenerateWallet").method(Method.POST).requestBuilder(UploadSignedCertificateAndGenerateWalletRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("uploadSignedCertificateAndGenerateWallet").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UploadSignedCertificateAndGenerateWalletResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UploadSignedCertificateAndGenerateWalletResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ValidateNetworkResponse> validateNetwork(ValidateNetworkRequest request, AsyncHandler<ValidateNetworkRequest, ValidateNetworkResponse> handler) {
        Validate.notBlank((String)request.getShardedDatabaseId(), (String)"shardedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ValidateNetworkResponse::builder).logger(LOG, "validateNetwork").serviceDetails("ShardedDatabaseService", "ValidateNetwork", "https://docs.oracle.com/iaas/api/#/en/globally-distributed-autonomous-database/20230301/ShardedDatabase/ValidateNetwork").method(Method.POST).requestBuilder(ValidateNetworkRequest::builder).basePath("/20230301").appendPathParam("shardedDatabases").appendPathParam(request.getShardedDatabaseId()).appendPathParam("actions").appendPathParam("validateNetwork").appendQueryParam("isSurrogate", (Object)request.getIsSurrogate()).appendQueryParam("resourceName", (Object)request.getResourceName()).appendQueryParam("isPrimary", (Object)request.getIsPrimary()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", ValidateNetworkResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ValidateNetworkResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ShardedDatabaseServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ShardedDatabaseServiceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ShardedDatabaseServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ShardedDatabaseServiceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ShardedDatabaseServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ShardedDatabaseServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ShardedDatabaseServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ShardedDatabaseServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ShardedDatabaseServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ShardedDatabaseServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ShardedDatabaseServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ShardedDatabaseServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ShardedDatabaseServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ShardedDatabaseServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ShardedDatabaseServiceAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "globallydistributeddatabase";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"globallydistributeddatabase");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ShardedDatabaseServiceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ShardedDatabaseServiceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

