/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase;

import com.oracle.bmc.globallydistributeddatabase.ShardedDatabaseService;
import com.oracle.bmc.globallydistributeddatabase.model.PrivateEndpointSummary;
import com.oracle.bmc.globallydistributeddatabase.model.ShardedDatabaseSummary;
import com.oracle.bmc.globallydistributeddatabase.model.WorkRequestError;
import com.oracle.bmc.globallydistributeddatabase.model.WorkRequestLogEntry;
import com.oracle.bmc.globallydistributeddatabase.model.WorkRequestSummary;
import com.oracle.bmc.globallydistributeddatabase.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListShardedDatabasesRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.globallydistributeddatabase.requests.ListWorkRequestsRequest;
import com.oracle.bmc.globallydistributeddatabase.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListShardedDatabasesResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.globallydistributeddatabase.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ShardedDatabaseServicePaginators {
    private final ShardedDatabaseService client;

    public ShardedDatabaseServicePaginators(ShardedDatabaseService client) {
        this.client = client;
    }

    public Iterable<ListPrivateEndpointsResponse> listPrivateEndpointsResponseIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            @Override
            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            @Override
            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            @Override
            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listPrivateEndpoints(request);
            }
        });
    }

    public Iterable<PrivateEndpointSummary> listPrivateEndpointsRecordIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            @Override
            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            @Override
            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            @Override
            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listPrivateEndpoints(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, List<PrivateEndpointSummary>>(){

            @Override
            public List<PrivateEndpointSummary> apply(ListPrivateEndpointsResponse response) {
                return response.getPrivateEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListShardedDatabasesResponse> listShardedDatabasesResponseIterator(final ListShardedDatabasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListShardedDatabasesRequest.Builder>(){

            @Override
            public ListShardedDatabasesRequest.Builder get() {
                return ListShardedDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShardedDatabasesResponse, String>(){

            @Override
            public String apply(ListShardedDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShardedDatabasesRequest.Builder>, ListShardedDatabasesRequest>(){

            @Override
            public ListShardedDatabasesRequest apply(RequestBuilderAndToken<ListShardedDatabasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListShardedDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShardedDatabasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListShardedDatabasesRequest, ListShardedDatabasesResponse>(){

            @Override
            public ListShardedDatabasesResponse apply(ListShardedDatabasesRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listShardedDatabases(request);
            }
        });
    }

    public Iterable<ShardedDatabaseSummary> listShardedDatabasesRecordIterator(final ListShardedDatabasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListShardedDatabasesRequest.Builder>(){

            @Override
            public ListShardedDatabasesRequest.Builder get() {
                return ListShardedDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShardedDatabasesResponse, String>(){

            @Override
            public String apply(ListShardedDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShardedDatabasesRequest.Builder>, ListShardedDatabasesRequest>(){

            @Override
            public ListShardedDatabasesRequest apply(RequestBuilderAndToken<ListShardedDatabasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListShardedDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShardedDatabasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListShardedDatabasesRequest, ListShardedDatabasesResponse>(){

            @Override
            public ListShardedDatabasesResponse apply(ListShardedDatabasesRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listShardedDatabases(request);
            }
        }, (Function)new Function<ListShardedDatabasesResponse, List<ShardedDatabaseSummary>>(){

            @Override
            public List<ShardedDatabaseSummary> apply(ListShardedDatabasesResponse response) {
                return response.getShardedDatabaseCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ShardedDatabaseServicePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

