/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.globallydistributeddatabase.model.ConnectionString;
import com.oracle.bmc.globallydistributeddatabase.model.DedicatedCatalogDetails;
import com.oracle.bmc.globallydistributeddatabase.model.DedicatedShardDetails;
import com.oracle.bmc.globallydistributeddatabase.model.GsmDetails;
import com.oracle.bmc.globallydistributeddatabase.model.ShardedDatabase;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dbDeploymentType")
@JsonFilter(value="explicitlySetFilter")
public final class DedicatedShardedDatabase
extends ShardedDatabase {
    @JsonProperty(value="replicationMethod")
    private final ReplicationMethod replicationMethod;
    @JsonProperty(value="replicationFactor")
    private final Integer replicationFactor;
    @JsonProperty(value="replicationUnit")
    private final Integer replicationUnit;
    @JsonProperty(value="clusterCertificateCommonName")
    private final String clusterCertificateCommonName;
    @JsonProperty(value="characterSet")
    private final String characterSet;
    @JsonProperty(value="ncharacterSet")
    private final String ncharacterSet;
    @JsonProperty(value="chunks")
    private final Integer chunks;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="shardingMethod")
    private final ShardingMethod shardingMethod;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="listenerPort")
    private final Integer listenerPort;
    @JsonProperty(value="listenerPortTls")
    private final Integer listenerPortTls;
    @JsonProperty(value="onsPortLocal")
    private final Integer onsPortLocal;
    @JsonProperty(value="onsPortRemote")
    private final Integer onsPortRemote;
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonProperty(value="privateEndpoint")
    private final String privateEndpoint;
    @JsonProperty(value="connectionStrings")
    private final ConnectionString connectionStrings;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="gsms")
    private final List<GsmDetails> gsms;
    @JsonProperty(value="shardDetails")
    private final List<DedicatedShardDetails> shardDetails;
    @JsonProperty(value="catalogDetails")
    private final List<DedicatedCatalogDetails> catalogDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DedicatedShardedDatabase(String id, String compartmentId, String displayName, Date timeCreated, Date timeUpdated, ShardedDatabase.LifecycleState lifecycleState, String lifecycleStateDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, ReplicationMethod replicationMethod, Integer replicationFactor, Integer replicationUnit, String clusterCertificateCommonName, String characterSet, String ncharacterSet, Integer chunks, DbWorkload dbWorkload, ShardingMethod shardingMethod, String dbVersion, Integer listenerPort, Integer listenerPortTls, Integer onsPortLocal, Integer onsPortRemote, String prefix, String privateEndpoint, ConnectionString connectionStrings, String timeZone, List<GsmDetails> gsms, List<DedicatedShardDetails> shardDetails, List<DedicatedCatalogDetails> catalogDetails) {
        super(id, compartmentId, displayName, timeCreated, timeUpdated, lifecycleState, lifecycleStateDetails, freeformTags, definedTags, systemTags);
        this.replicationMethod = replicationMethod;
        this.replicationFactor = replicationFactor;
        this.replicationUnit = replicationUnit;
        this.clusterCertificateCommonName = clusterCertificateCommonName;
        this.characterSet = characterSet;
        this.ncharacterSet = ncharacterSet;
        this.chunks = chunks;
        this.dbWorkload = dbWorkload;
        this.shardingMethod = shardingMethod;
        this.dbVersion = dbVersion;
        this.listenerPort = listenerPort;
        this.listenerPortTls = listenerPortTls;
        this.onsPortLocal = onsPortLocal;
        this.onsPortRemote = onsPortRemote;
        this.prefix = prefix;
        this.privateEndpoint = privateEndpoint;
        this.connectionStrings = connectionStrings;
        this.timeZone = timeZone;
        this.gsms = gsms;
        this.shardDetails = shardDetails;
        this.catalogDetails = catalogDetails;
    }

    public ReplicationMethod getReplicationMethod() {
        return this.replicationMethod;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public Integer getReplicationUnit() {
        return this.replicationUnit;
    }

    public String getClusterCertificateCommonName() {
        return this.clusterCertificateCommonName;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getNcharacterSet() {
        return this.ncharacterSet;
    }

    public Integer getChunks() {
        return this.chunks;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public ShardingMethod getShardingMethod() {
        return this.shardingMethod;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public Integer getListenerPort() {
        return this.listenerPort;
    }

    public Integer getListenerPortTls() {
        return this.listenerPortTls;
    }

    public Integer getOnsPortLocal() {
        return this.onsPortLocal;
    }

    public Integer getOnsPortRemote() {
        return this.onsPortRemote;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPrivateEndpoint() {
        return this.privateEndpoint;
    }

    public ConnectionString getConnectionStrings() {
        return this.connectionStrings;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public List<GsmDetails> getGsms() {
        return this.gsms;
    }

    public List<DedicatedShardDetails> getShardDetails() {
        return this.shardDetails;
    }

    public List<DedicatedCatalogDetails> getCatalogDetails() {
        return this.catalogDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DedicatedShardedDatabase(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", replicationMethod=").append(String.valueOf((Object)this.replicationMethod));
        sb.append(", replicationFactor=").append(String.valueOf(this.replicationFactor));
        sb.append(", replicationUnit=").append(String.valueOf(this.replicationUnit));
        sb.append(", clusterCertificateCommonName=").append(String.valueOf(this.clusterCertificateCommonName));
        sb.append(", characterSet=").append(String.valueOf(this.characterSet));
        sb.append(", ncharacterSet=").append(String.valueOf(this.ncharacterSet));
        sb.append(", chunks=").append(String.valueOf(this.chunks));
        sb.append(", dbWorkload=").append(String.valueOf((Object)this.dbWorkload));
        sb.append(", shardingMethod=").append(String.valueOf((Object)this.shardingMethod));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", listenerPort=").append(String.valueOf(this.listenerPort));
        sb.append(", listenerPortTls=").append(String.valueOf(this.listenerPortTls));
        sb.append(", onsPortLocal=").append(String.valueOf(this.onsPortLocal));
        sb.append(", onsPortRemote=").append(String.valueOf(this.onsPortRemote));
        sb.append(", prefix=").append(String.valueOf(this.prefix));
        sb.append(", privateEndpoint=").append(String.valueOf(this.privateEndpoint));
        sb.append(", connectionStrings=").append(String.valueOf((Object)this.connectionStrings));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", gsms=").append(String.valueOf(this.gsms));
        sb.append(", shardDetails=").append(String.valueOf(this.shardDetails));
        sb.append(", catalogDetails=").append(String.valueOf(this.catalogDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DedicatedShardedDatabase)) {
            return false;
        }
        DedicatedShardedDatabase other = (DedicatedShardedDatabase)((Object)o);
        return Objects.equals((Object)this.replicationMethod, (Object)other.replicationMethod) && Objects.equals(this.replicationFactor, other.replicationFactor) && Objects.equals(this.replicationUnit, other.replicationUnit) && Objects.equals(this.clusterCertificateCommonName, other.clusterCertificateCommonName) && Objects.equals(this.characterSet, other.characterSet) && Objects.equals(this.ncharacterSet, other.ncharacterSet) && Objects.equals(this.chunks, other.chunks) && Objects.equals((Object)this.dbWorkload, (Object)other.dbWorkload) && Objects.equals((Object)this.shardingMethod, (Object)other.shardingMethod) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.listenerPort, other.listenerPort) && Objects.equals(this.listenerPortTls, other.listenerPortTls) && Objects.equals(this.onsPortLocal, other.onsPortLocal) && Objects.equals(this.onsPortRemote, other.onsPortRemote) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.privateEndpoint, other.privateEndpoint) && Objects.equals((Object)this.connectionStrings, (Object)other.connectionStrings) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.gsms, other.gsms) && Objects.equals(this.shardDetails, other.shardDetails) && Objects.equals(this.catalogDetails, other.catalogDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.replicationMethod == null ? 43 : this.replicationMethod.hashCode());
        result = result * 59 + (this.replicationFactor == null ? 43 : this.replicationFactor.hashCode());
        result = result * 59 + (this.replicationUnit == null ? 43 : this.replicationUnit.hashCode());
        result = result * 59 + (this.clusterCertificateCommonName == null ? 43 : this.clusterCertificateCommonName.hashCode());
        result = result * 59 + (this.characterSet == null ? 43 : this.characterSet.hashCode());
        result = result * 59 + (this.ncharacterSet == null ? 43 : this.ncharacterSet.hashCode());
        result = result * 59 + (this.chunks == null ? 43 : this.chunks.hashCode());
        result = result * 59 + (this.dbWorkload == null ? 43 : this.dbWorkload.hashCode());
        result = result * 59 + (this.shardingMethod == null ? 43 : this.shardingMethod.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.listenerPort == null ? 43 : this.listenerPort.hashCode());
        result = result * 59 + (this.listenerPortTls == null ? 43 : this.listenerPortTls.hashCode());
        result = result * 59 + (this.onsPortLocal == null ? 43 : this.onsPortLocal.hashCode());
        result = result * 59 + (this.onsPortRemote == null ? 43 : this.onsPortRemote.hashCode());
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + (this.privateEndpoint == null ? 43 : this.privateEndpoint.hashCode());
        result = result * 59 + (this.connectionStrings == null ? 43 : this.connectionStrings.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.gsms == null ? 43 : this.gsms.hashCode());
        result = result * 59 + (this.shardDetails == null ? 43 : this.shardDetails.hashCode());
        result = result * 59 + (this.catalogDetails == null ? 43 : this.catalogDetails.hashCode());
        return result;
    }

    public static enum ShardingMethod implements BmcEnum
    {
        User("USER"),
        System("SYSTEM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShardingMethod> map;

        private ShardingMethod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShardingMethod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShardingMethod', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShardingMethod.class);
            map = new HashMap<String, ShardingMethod>();
            for (ShardingMethod v : ShardingMethod.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DbWorkload implements BmcEnum
    {
        Oltp("OLTP"),
        Dw("DW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DbWorkload', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DbWorkload.class);
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ReplicationMethod implements BmcEnum
    {
        Raft("RAFT"),
        Dg("DG"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ReplicationMethod> map;

        private ReplicationMethod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReplicationMethod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ReplicationMethod', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ReplicationMethod.class);
            map = new HashMap<String, ReplicationMethod>();
            for (ReplicationMethod v : ReplicationMethod.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private ShardedDatabase.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="replicationMethod")
        private ReplicationMethod replicationMethod;
        @JsonProperty(value="replicationFactor")
        private Integer replicationFactor;
        @JsonProperty(value="replicationUnit")
        private Integer replicationUnit;
        @JsonProperty(value="clusterCertificateCommonName")
        private String clusterCertificateCommonName;
        @JsonProperty(value="characterSet")
        private String characterSet;
        @JsonProperty(value="ncharacterSet")
        private String ncharacterSet;
        @JsonProperty(value="chunks")
        private Integer chunks;
        @JsonProperty(value="dbWorkload")
        private DbWorkload dbWorkload;
        @JsonProperty(value="shardingMethod")
        private ShardingMethod shardingMethod;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="listenerPort")
        private Integer listenerPort;
        @JsonProperty(value="listenerPortTls")
        private Integer listenerPortTls;
        @JsonProperty(value="onsPortLocal")
        private Integer onsPortLocal;
        @JsonProperty(value="onsPortRemote")
        private Integer onsPortRemote;
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonProperty(value="privateEndpoint")
        private String privateEndpoint;
        @JsonProperty(value="connectionStrings")
        private ConnectionString connectionStrings;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="gsms")
        private List<GsmDetails> gsms;
        @JsonProperty(value="shardDetails")
        private List<DedicatedShardDetails> shardDetails;
        @JsonProperty(value="catalogDetails")
        private List<DedicatedCatalogDetails> catalogDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(ShardedDatabase.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder replicationMethod(ReplicationMethod replicationMethod) {
            this.replicationMethod = replicationMethod;
            this.__explicitlySet__.add("replicationMethod");
            return this;
        }

        public Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            this.__explicitlySet__.add("replicationFactor");
            return this;
        }

        public Builder replicationUnit(Integer replicationUnit) {
            this.replicationUnit = replicationUnit;
            this.__explicitlySet__.add("replicationUnit");
            return this;
        }

        public Builder clusterCertificateCommonName(String clusterCertificateCommonName) {
            this.clusterCertificateCommonName = clusterCertificateCommonName;
            this.__explicitlySet__.add("clusterCertificateCommonName");
            return this;
        }

        public Builder characterSet(String characterSet) {
            this.characterSet = characterSet;
            this.__explicitlySet__.add("characterSet");
            return this;
        }

        public Builder ncharacterSet(String ncharacterSet) {
            this.ncharacterSet = ncharacterSet;
            this.__explicitlySet__.add("ncharacterSet");
            return this;
        }

        public Builder chunks(Integer chunks) {
            this.chunks = chunks;
            this.__explicitlySet__.add("chunks");
            return this;
        }

        public Builder dbWorkload(DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder shardingMethod(ShardingMethod shardingMethod) {
            this.shardingMethod = shardingMethod;
            this.__explicitlySet__.add("shardingMethod");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder listenerPortTls(Integer listenerPortTls) {
            this.listenerPortTls = listenerPortTls;
            this.__explicitlySet__.add("listenerPortTls");
            return this;
        }

        public Builder onsPortLocal(Integer onsPortLocal) {
            this.onsPortLocal = onsPortLocal;
            this.__explicitlySet__.add("onsPortLocal");
            return this;
        }

        public Builder onsPortRemote(Integer onsPortRemote) {
            this.onsPortRemote = onsPortRemote;
            this.__explicitlySet__.add("onsPortRemote");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public Builder privateEndpoint(String privateEndpoint) {
            this.privateEndpoint = privateEndpoint;
            this.__explicitlySet__.add("privateEndpoint");
            return this;
        }

        public Builder connectionStrings(ConnectionString connectionStrings) {
            this.connectionStrings = connectionStrings;
            this.__explicitlySet__.add("connectionStrings");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder gsms(List<GsmDetails> gsms) {
            this.gsms = gsms;
            this.__explicitlySet__.add("gsms");
            return this;
        }

        public Builder shardDetails(List<DedicatedShardDetails> shardDetails) {
            this.shardDetails = shardDetails;
            this.__explicitlySet__.add("shardDetails");
            return this;
        }

        public Builder catalogDetails(List<DedicatedCatalogDetails> catalogDetails) {
            this.catalogDetails = catalogDetails;
            this.__explicitlySet__.add("catalogDetails");
            return this;
        }

        public DedicatedShardedDatabase build() {
            DedicatedShardedDatabase model = new DedicatedShardedDatabase(this.id, this.compartmentId, this.displayName, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleStateDetails, this.freeformTags, this.definedTags, this.systemTags, this.replicationMethod, this.replicationFactor, this.replicationUnit, this.clusterCertificateCommonName, this.characterSet, this.ncharacterSet, this.chunks, this.dbWorkload, this.shardingMethod, this.dbVersion, this.listenerPort, this.listenerPortTls, this.onsPortLocal, this.onsPortRemote, this.prefix, this.privateEndpoint, this.connectionStrings, this.timeZone, this.gsms, this.shardDetails, this.catalogDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DedicatedShardedDatabase model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStateDetails")) {
                this.lifecycleStateDetails(model.getLifecycleStateDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("replicationMethod")) {
                this.replicationMethod(model.getReplicationMethod());
            }
            if (model.wasPropertyExplicitlySet("replicationFactor")) {
                this.replicationFactor(model.getReplicationFactor());
            }
            if (model.wasPropertyExplicitlySet("replicationUnit")) {
                this.replicationUnit(model.getReplicationUnit());
            }
            if (model.wasPropertyExplicitlySet("clusterCertificateCommonName")) {
                this.clusterCertificateCommonName(model.getClusterCertificateCommonName());
            }
            if (model.wasPropertyExplicitlySet("characterSet")) {
                this.characterSet(model.getCharacterSet());
            }
            if (model.wasPropertyExplicitlySet("ncharacterSet")) {
                this.ncharacterSet(model.getNcharacterSet());
            }
            if (model.wasPropertyExplicitlySet("chunks")) {
                this.chunks(model.getChunks());
            }
            if (model.wasPropertyExplicitlySet("dbWorkload")) {
                this.dbWorkload(model.getDbWorkload());
            }
            if (model.wasPropertyExplicitlySet("shardingMethod")) {
                this.shardingMethod(model.getShardingMethod());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("listenerPort")) {
                this.listenerPort(model.getListenerPort());
            }
            if (model.wasPropertyExplicitlySet("listenerPortTls")) {
                this.listenerPortTls(model.getListenerPortTls());
            }
            if (model.wasPropertyExplicitlySet("onsPortLocal")) {
                this.onsPortLocal(model.getOnsPortLocal());
            }
            if (model.wasPropertyExplicitlySet("onsPortRemote")) {
                this.onsPortRemote(model.getOnsPortRemote());
            }
            if (model.wasPropertyExplicitlySet("prefix")) {
                this.prefix(model.getPrefix());
            }
            if (model.wasPropertyExplicitlySet("privateEndpoint")) {
                this.privateEndpoint(model.getPrivateEndpoint());
            }
            if (model.wasPropertyExplicitlySet("connectionStrings")) {
                this.connectionStrings(model.getConnectionStrings());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("gsms")) {
                this.gsms(model.getGsms());
            }
            if (model.wasPropertyExplicitlySet("shardDetails")) {
                this.shardDetails(model.getShardDetails());
            }
            if (model.wasPropertyExplicitlySet("catalogDetails")) {
                this.catalogDetails(model.getCatalogDetails());
            }
            return this;
        }
    }
}

