/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FetchShardableCloudAutonomousVmClustersDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="minimumAvailableCdbCount")
    private final Integer minimumAvailableCdbCount;
    @JsonProperty(value="areDepletedClustersIncluded")
    private final Boolean areDepletedClustersIncluded;
    @JsonProperty(value="regions")
    private final List<String> regions;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "lifecycleState", "lifecycleStateDetails", "minimumAvailableCdbCount", "areDepletedClustersIncluded", "regions"})
    public FetchShardableCloudAutonomousVmClustersDetails(String compartmentId, LifecycleState lifecycleState, String lifecycleStateDetails, Integer minimumAvailableCdbCount, Boolean areDepletedClustersIncluded, List<String> regions) {
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.minimumAvailableCdbCount = minimumAvailableCdbCount;
        this.areDepletedClustersIncluded = areDepletedClustersIncluded;
        this.regions = regions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public Integer getMinimumAvailableCdbCount() {
        return this.minimumAvailableCdbCount;
    }

    public Boolean getAreDepletedClustersIncluded() {
        return this.areDepletedClustersIncluded;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FetchShardableCloudAutonomousVmClustersDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleStateDetails=").append(String.valueOf(this.lifecycleStateDetails));
        sb.append(", minimumAvailableCdbCount=").append(String.valueOf(this.minimumAvailableCdbCount));
        sb.append(", areDepletedClustersIncluded=").append(String.valueOf(this.areDepletedClustersIncluded));
        sb.append(", regions=").append(String.valueOf(this.regions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FetchShardableCloudAutonomousVmClustersDetails)) {
            return false;
        }
        FetchShardableCloudAutonomousVmClustersDetails other = (FetchShardableCloudAutonomousVmClustersDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleStateDetails, other.lifecycleStateDetails) && Objects.equals(this.minimumAvailableCdbCount, other.minimumAvailableCdbCount) && Objects.equals(this.areDepletedClustersIncluded, other.areDepletedClustersIncluded) && Objects.equals(this.regions, other.regions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleStateDetails == null ? 43 : this.lifecycleStateDetails.hashCode());
        result = result * 59 + (this.minimumAvailableCdbCount == null ? 43 : this.minimumAvailableCdbCount.hashCode());
        result = result * 59 + (this.areDepletedClustersIncluded == null ? 43 : this.areDepletedClustersIncluded.hashCode());
        result = result * 59 + (this.regions == null ? 43 : this.regions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Failed("FAILED"),
        NeedsAttention("NEEDS_ATTENTION"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Updating("UPDATING"),
        Creating("CREATING"),
        Unavailable("UNAVAILABLE");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="minimumAvailableCdbCount")
        private Integer minimumAvailableCdbCount;
        @JsonProperty(value="areDepletedClustersIncluded")
        private Boolean areDepletedClustersIncluded;
        @JsonProperty(value="regions")
        private List<String> regions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder minimumAvailableCdbCount(Integer minimumAvailableCdbCount) {
            this.minimumAvailableCdbCount = minimumAvailableCdbCount;
            this.__explicitlySet__.add("minimumAvailableCdbCount");
            return this;
        }

        public Builder areDepletedClustersIncluded(Boolean areDepletedClustersIncluded) {
            this.areDepletedClustersIncluded = areDepletedClustersIncluded;
            this.__explicitlySet__.add("areDepletedClustersIncluded");
            return this;
        }

        public Builder regions(List<String> regions) {
            this.regions = regions;
            this.__explicitlySet__.add("regions");
            return this;
        }

        public FetchShardableCloudAutonomousVmClustersDetails build() {
            FetchShardableCloudAutonomousVmClustersDetails model = new FetchShardableCloudAutonomousVmClustersDetails(this.compartmentId, this.lifecycleState, this.lifecycleStateDetails, this.minimumAvailableCdbCount, this.areDepletedClustersIncluded, this.regions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FetchShardableCloudAutonomousVmClustersDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStateDetails")) {
                this.lifecycleStateDetails(model.getLifecycleStateDetails());
            }
            if (model.wasPropertyExplicitlySet("minimumAvailableCdbCount")) {
                this.minimumAvailableCdbCount(model.getMinimumAvailableCdbCount());
            }
            if (model.wasPropertyExplicitlySet("areDepletedClustersIncluded")) {
                this.areDepletedClustersIncluded(model.getAreDepletedClustersIncluded());
            }
            if (model.wasPropertyExplicitlySet("regions")) {
                this.regions(model.getRegions());
            }
            return this;
        }
    }
}

