/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ShardableCloudAutonomousVmClusterSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="computeModel")
    private final String computeModel;
    @JsonProperty(value="availableContainerDatabases")
    private final Integer availableContainerDatabases;
    @JsonProperty(value="availableCpus")
    private final Float availableCpus;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="autonomousDataStorageSizeInTBs")
    private final Float autonomousDataStorageSizeInTBs;
    @JsonProperty(value="availableAutonomousDataStorageSizeInTBs")
    private final Float availableAutonomousDataStorageSizeInTBs;
    @JsonProperty(value="cloudExadataInfrastructureId")
    private final String cloudExadataInfrastructureId;
    @JsonProperty(value="clusterTimeZone")
    private final String clusterTimeZone;
    @JsonProperty(value="totalContainerDatabases")
    private final Integer totalContainerDatabases;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="licenseModel")
    private final String licenseModel;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
    private final Integer memoryPerOracleComputeUnitInGBs;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="cpuCoreCountPerNode")
    private final Integer cpuCoreCountPerNode;
    @JsonProperty(value="ocpuCount")
    private final Float ocpuCount;
    @JsonProperty(value="reclaimableCpus")
    private final Float reclaimableCpus;
    @JsonProperty(value="provisionableAutonomousContainerDatabases")
    private final Integer provisionableAutonomousContainerDatabases;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "lifecycleState", "lifecycleStateDetails", "displayName", "computeModel", "availableContainerDatabases", "availableCpus", "availabilityDomain", "autonomousDataStorageSizeInTBs", "availableAutonomousDataStorageSizeInTBs", "cloudExadataInfrastructureId", "clusterTimeZone", "totalContainerDatabases", "subnetId", "shape", "nodeCount", "licenseModel", "memorySizeInGBs", "memoryPerOracleComputeUnitInGBs", "cpuCoreCount", "cpuCoreCountPerNode", "ocpuCount", "reclaimableCpus", "provisionableAutonomousContainerDatabases", "freeformTags", "definedTags"})
    public ShardableCloudAutonomousVmClusterSummary(String id, String compartmentId, LifecycleState lifecycleState, String lifecycleStateDetails, String displayName, String computeModel, Integer availableContainerDatabases, Float availableCpus, String availabilityDomain, Float autonomousDataStorageSizeInTBs, Float availableAutonomousDataStorageSizeInTBs, String cloudExadataInfrastructureId, String clusterTimeZone, Integer totalContainerDatabases, String subnetId, String shape, Integer nodeCount, String licenseModel, Integer memorySizeInGBs, Integer memoryPerOracleComputeUnitInGBs, Integer cpuCoreCount, Integer cpuCoreCountPerNode, Float ocpuCount, Float reclaimableCpus, Integer provisionableAutonomousContainerDatabases, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.displayName = displayName;
        this.computeModel = computeModel;
        this.availableContainerDatabases = availableContainerDatabases;
        this.availableCpus = availableCpus;
        this.availabilityDomain = availabilityDomain;
        this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
        this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        this.clusterTimeZone = clusterTimeZone;
        this.totalContainerDatabases = totalContainerDatabases;
        this.subnetId = subnetId;
        this.shape = shape;
        this.nodeCount = nodeCount;
        this.licenseModel = licenseModel;
        this.memorySizeInGBs = memorySizeInGBs;
        this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        this.cpuCoreCount = cpuCoreCount;
        this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        this.ocpuCount = ocpuCount;
        this.reclaimableCpus = reclaimableCpus;
        this.provisionableAutonomousContainerDatabases = provisionableAutonomousContainerDatabases;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getComputeModel() {
        return this.computeModel;
    }

    public Integer getAvailableContainerDatabases() {
        return this.availableContainerDatabases;
    }

    public Float getAvailableCpus() {
        return this.availableCpus;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Float getAutonomousDataStorageSizeInTBs() {
        return this.autonomousDataStorageSizeInTBs;
    }

    public Float getAvailableAutonomousDataStorageSizeInTBs() {
        return this.availableAutonomousDataStorageSizeInTBs;
    }

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public String getClusterTimeZone() {
        return this.clusterTimeZone;
    }

    public Integer getTotalContainerDatabases() {
        return this.totalContainerDatabases;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public Integer getMemoryPerOracleComputeUnitInGBs() {
        return this.memoryPerOracleComputeUnitInGBs;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Integer getCpuCoreCountPerNode() {
        return this.cpuCoreCountPerNode;
    }

    public Float getOcpuCount() {
        return this.ocpuCount;
    }

    public Float getReclaimableCpus() {
        return this.reclaimableCpus;
    }

    public Integer getProvisionableAutonomousContainerDatabases() {
        return this.provisionableAutonomousContainerDatabases;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShardableCloudAutonomousVmClusterSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleStateDetails=").append(String.valueOf(this.lifecycleStateDetails));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", computeModel=").append(String.valueOf(this.computeModel));
        sb.append(", availableContainerDatabases=").append(String.valueOf(this.availableContainerDatabases));
        sb.append(", availableCpus=").append(String.valueOf(this.availableCpus));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", autonomousDataStorageSizeInTBs=").append(String.valueOf(this.autonomousDataStorageSizeInTBs));
        sb.append(", availableAutonomousDataStorageSizeInTBs=").append(String.valueOf(this.availableAutonomousDataStorageSizeInTBs));
        sb.append(", cloudExadataInfrastructureId=").append(String.valueOf(this.cloudExadataInfrastructureId));
        sb.append(", clusterTimeZone=").append(String.valueOf(this.clusterTimeZone));
        sb.append(", totalContainerDatabases=").append(String.valueOf(this.totalContainerDatabases));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", licenseModel=").append(String.valueOf(this.licenseModel));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", memoryPerOracleComputeUnitInGBs=").append(String.valueOf(this.memoryPerOracleComputeUnitInGBs));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", cpuCoreCountPerNode=").append(String.valueOf(this.cpuCoreCountPerNode));
        sb.append(", ocpuCount=").append(String.valueOf(this.ocpuCount));
        sb.append(", reclaimableCpus=").append(String.valueOf(this.reclaimableCpus));
        sb.append(", provisionableAutonomousContainerDatabases=").append(String.valueOf(this.provisionableAutonomousContainerDatabases));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShardableCloudAutonomousVmClusterSummary)) {
            return false;
        }
        ShardableCloudAutonomousVmClusterSummary other = (ShardableCloudAutonomousVmClusterSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleStateDetails, other.lifecycleStateDetails) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.computeModel, other.computeModel) && Objects.equals(this.availableContainerDatabases, other.availableContainerDatabases) && Objects.equals(this.availableCpus, other.availableCpus) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.autonomousDataStorageSizeInTBs, other.autonomousDataStorageSizeInTBs) && Objects.equals(this.availableAutonomousDataStorageSizeInTBs, other.availableAutonomousDataStorageSizeInTBs) && Objects.equals(this.cloudExadataInfrastructureId, other.cloudExadataInfrastructureId) && Objects.equals(this.clusterTimeZone, other.clusterTimeZone) && Objects.equals(this.totalContainerDatabases, other.totalContainerDatabases) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.shape, other.shape) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals(this.licenseModel, other.licenseModel) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.memoryPerOracleComputeUnitInGBs, other.memoryPerOracleComputeUnitInGBs) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.cpuCoreCountPerNode, other.cpuCoreCountPerNode) && Objects.equals(this.ocpuCount, other.ocpuCount) && Objects.equals(this.reclaimableCpus, other.reclaimableCpus) && Objects.equals(this.provisionableAutonomousContainerDatabases, other.provisionableAutonomousContainerDatabases) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleStateDetails == null ? 43 : this.lifecycleStateDetails.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + (this.availableContainerDatabases == null ? 43 : this.availableContainerDatabases.hashCode());
        result = result * 59 + (this.availableCpus == null ? 43 : this.availableCpus.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.autonomousDataStorageSizeInTBs == null ? 43 : this.autonomousDataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.availableAutonomousDataStorageSizeInTBs == null ? 43 : this.availableAutonomousDataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.cloudExadataInfrastructureId == null ? 43 : this.cloudExadataInfrastructureId.hashCode());
        result = result * 59 + (this.clusterTimeZone == null ? 43 : this.clusterTimeZone.hashCode());
        result = result * 59 + (this.totalContainerDatabases == null ? 43 : this.totalContainerDatabases.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.memoryPerOracleComputeUnitInGBs == null ? 43 : this.memoryPerOracleComputeUnitInGBs.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.cpuCoreCountPerNode == null ? 43 : this.cpuCoreCountPerNode.hashCode());
        result = result * 59 + (this.ocpuCount == null ? 43 : this.ocpuCount.hashCode());
        result = result * 59 + (this.reclaimableCpus == null ? 43 : this.reclaimableCpus.hashCode());
        result = result * 59 + (this.provisionableAutonomousContainerDatabases == null ? 43 : this.provisionableAutonomousContainerDatabases.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Failed("FAILED"),
        NeedsAttention("NEEDS_ATTENTION"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Updating("UPDATING"),
        Creating("CREATING"),
        Unavailable("UNAVAILABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="computeModel")
        private String computeModel;
        @JsonProperty(value="availableContainerDatabases")
        private Integer availableContainerDatabases;
        @JsonProperty(value="availableCpus")
        private Float availableCpus;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="autonomousDataStorageSizeInTBs")
        private Float autonomousDataStorageSizeInTBs;
        @JsonProperty(value="availableAutonomousDataStorageSizeInTBs")
        private Float availableAutonomousDataStorageSizeInTBs;
        @JsonProperty(value="cloudExadataInfrastructureId")
        private String cloudExadataInfrastructureId;
        @JsonProperty(value="clusterTimeZone")
        private String clusterTimeZone;
        @JsonProperty(value="totalContainerDatabases")
        private Integer totalContainerDatabases;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="licenseModel")
        private String licenseModel;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
        private Integer memoryPerOracleComputeUnitInGBs;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="cpuCoreCountPerNode")
        private Integer cpuCoreCountPerNode;
        @JsonProperty(value="ocpuCount")
        private Float ocpuCount;
        @JsonProperty(value="reclaimableCpus")
        private Float reclaimableCpus;
        @JsonProperty(value="provisionableAutonomousContainerDatabases")
        private Integer provisionableAutonomousContainerDatabases;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public Builder availableContainerDatabases(Integer availableContainerDatabases) {
            this.availableContainerDatabases = availableContainerDatabases;
            this.__explicitlySet__.add("availableContainerDatabases");
            return this;
        }

        public Builder availableCpus(Float availableCpus) {
            this.availableCpus = availableCpus;
            this.__explicitlySet__.add("availableCpus");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder autonomousDataStorageSizeInTBs(Float autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            this.__explicitlySet__.add("autonomousDataStorageSizeInTBs");
            return this;
        }

        public Builder availableAutonomousDataStorageSizeInTBs(Float availableAutonomousDataStorageSizeInTBs) {
            this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
            this.__explicitlySet__.add("availableAutonomousDataStorageSizeInTBs");
            return this;
        }

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            this.__explicitlySet__.add("cloudExadataInfrastructureId");
            return this;
        }

        public Builder clusterTimeZone(String clusterTimeZone) {
            this.clusterTimeZone = clusterTimeZone;
            this.__explicitlySet__.add("clusterTimeZone");
            return this;
        }

        public Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            this.__explicitlySet__.add("totalContainerDatabases");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            this.__explicitlySet__.add("memoryPerOracleComputeUnitInGBs");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            this.__explicitlySet__.add("cpuCoreCountPerNode");
            return this;
        }

        public Builder ocpuCount(Float ocpuCount) {
            this.ocpuCount = ocpuCount;
            this.__explicitlySet__.add("ocpuCount");
            return this;
        }

        public Builder reclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
            this.__explicitlySet__.add("reclaimableCpus");
            return this;
        }

        public Builder provisionableAutonomousContainerDatabases(Integer provisionableAutonomousContainerDatabases) {
            this.provisionableAutonomousContainerDatabases = provisionableAutonomousContainerDatabases;
            this.__explicitlySet__.add("provisionableAutonomousContainerDatabases");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public ShardableCloudAutonomousVmClusterSummary build() {
            ShardableCloudAutonomousVmClusterSummary model = new ShardableCloudAutonomousVmClusterSummary(this.id, this.compartmentId, this.lifecycleState, this.lifecycleStateDetails, this.displayName, this.computeModel, this.availableContainerDatabases, this.availableCpus, this.availabilityDomain, this.autonomousDataStorageSizeInTBs, this.availableAutonomousDataStorageSizeInTBs, this.cloudExadataInfrastructureId, this.clusterTimeZone, this.totalContainerDatabases, this.subnetId, this.shape, this.nodeCount, this.licenseModel, this.memorySizeInGBs, this.memoryPerOracleComputeUnitInGBs, this.cpuCoreCount, this.cpuCoreCountPerNode, this.ocpuCount, this.reclaimableCpus, this.provisionableAutonomousContainerDatabases, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShardableCloudAutonomousVmClusterSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStateDetails")) {
                this.lifecycleStateDetails(model.getLifecycleStateDetails());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            if (model.wasPropertyExplicitlySet("availableContainerDatabases")) {
                this.availableContainerDatabases(model.getAvailableContainerDatabases());
            }
            if (model.wasPropertyExplicitlySet("availableCpus")) {
                this.availableCpus(model.getAvailableCpus());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("autonomousDataStorageSizeInTBs")) {
                this.autonomousDataStorageSizeInTBs(model.getAutonomousDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("availableAutonomousDataStorageSizeInTBs")) {
                this.availableAutonomousDataStorageSizeInTBs(model.getAvailableAutonomousDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("cloudExadataInfrastructureId")) {
                this.cloudExadataInfrastructureId(model.getCloudExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("clusterTimeZone")) {
                this.clusterTimeZone(model.getClusterTimeZone());
            }
            if (model.wasPropertyExplicitlySet("totalContainerDatabases")) {
                this.totalContainerDatabases(model.getTotalContainerDatabases());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("memoryPerOracleComputeUnitInGBs")) {
                this.memoryPerOracleComputeUnitInGBs(model.getMemoryPerOracleComputeUnitInGBs());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCountPerNode")) {
                this.cpuCoreCountPerNode(model.getCpuCoreCountPerNode());
            }
            if (model.wasPropertyExplicitlySet("ocpuCount")) {
                this.ocpuCount(model.getOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("reclaimableCpus")) {
                this.reclaimableCpus(model.getReclaimableCpus());
            }
            if (model.wasPropertyExplicitlySet("provisionableAutonomousContainerDatabases")) {
                this.provisionableAutonomousContainerDatabases(model.getProvisionableAutonomousContainerDatabases());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

