/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateGsmCertificateSigningRequestRequest
extends BmcRequest<Void> {
    private String shardedDatabaseId;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;
    private String caBundleId;

    public String getShardedDatabaseId() {
        return this.shardedDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getCaBundleId() {
        return this.caBundleId;
    }

    public Builder toBuilder() {
        return new Builder().shardedDatabaseId(this.shardedDatabaseId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).caBundleId(this.caBundleId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",shardedDatabaseId=").append(String.valueOf(this.shardedDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",caBundleId=").append(String.valueOf(this.caBundleId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateGsmCertificateSigningRequestRequest)) {
            return false;
        }
        GenerateGsmCertificateSigningRequestRequest other = (GenerateGsmCertificateSigningRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.shardedDatabaseId, other.shardedDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.caBundleId, other.caBundleId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.shardedDatabaseId == null ? 43 : this.shardedDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.caBundleId == null ? 43 : this.caBundleId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateGsmCertificateSigningRequestRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String shardedDatabaseId = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String caBundleId = null;

        public Builder shardedDatabaseId(String shardedDatabaseId) {
            this.shardedDatabaseId = shardedDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder caBundleId(String caBundleId) {
            this.caBundleId = caBundleId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateGsmCertificateSigningRequestRequest o) {
            this.shardedDatabaseId(o.getShardedDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.caBundleId(o.getCaBundleId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateGsmCertificateSigningRequestRequest build() {
            GenerateGsmCertificateSigningRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GenerateGsmCertificateSigningRequestRequest buildWithoutInvocationCallback() {
            GenerateGsmCertificateSigningRequestRequest request = new GenerateGsmCertificateSigningRequestRequest();
            request.shardedDatabaseId = this.shardedDatabaseId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.caBundleId = this.caBundleId;
            return request;
        }
    }
}

