/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.globallydistributeddatabase.model.GenerateWalletDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateWalletRequest
extends BmcRequest<GenerateWalletDetails> {
    private String shardedDatabaseId;
    private GenerateWalletDetails generateWalletDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getShardedDatabaseId() {
        return this.shardedDatabaseId;
    }

    public GenerateWalletDetails getGenerateWalletDetails() {
        return this.generateWalletDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public GenerateWalletDetails getBody$() {
        return this.generateWalletDetails;
    }

    public Builder toBuilder() {
        return new Builder().shardedDatabaseId(this.shardedDatabaseId).generateWalletDetails(this.generateWalletDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",shardedDatabaseId=").append(String.valueOf(this.shardedDatabaseId));
        sb.append(",generateWalletDetails=").append(String.valueOf((Object)this.generateWalletDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateWalletRequest)) {
            return false;
        }
        GenerateWalletRequest other = (GenerateWalletRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.shardedDatabaseId, other.shardedDatabaseId) && Objects.equals((Object)this.generateWalletDetails, (Object)other.generateWalletDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.shardedDatabaseId == null ? 43 : this.shardedDatabaseId.hashCode());
        result = result * 59 + (this.generateWalletDetails == null ? 43 : this.generateWalletDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateWalletRequest, GenerateWalletDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String shardedDatabaseId = null;
        private GenerateWalletDetails generateWalletDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder shardedDatabaseId(String shardedDatabaseId) {
            this.shardedDatabaseId = shardedDatabaseId;
            return this;
        }

        public Builder generateWalletDetails(GenerateWalletDetails generateWalletDetails) {
            this.generateWalletDetails = generateWalletDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateWalletRequest o) {
            this.shardedDatabaseId(o.getShardedDatabaseId());
            this.generateWalletDetails(o.getGenerateWalletDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateWalletRequest build() {
            GenerateWalletRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(GenerateWalletDetails body) {
            this.generateWalletDetails(body);
            return this;
        }

        public GenerateWalletRequest buildWithoutInvocationCallback() {
            GenerateWalletRequest request = new GenerateWalletRequest();
            request.shardedDatabaseId = this.shardedDatabaseId;
            request.generateWalletDetails = this.generateWalletDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

