/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetShardedDatabaseRequest
extends BmcRequest<Void> {
    private String shardedDatabaseId;
    private String metadata;
    private String ifNoneMatch;
    private String opcRequestId;

    public String getShardedDatabaseId() {
        return this.shardedDatabaseId;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().shardedDatabaseId(this.shardedDatabaseId).metadata(this.metadata).ifNoneMatch(this.ifNoneMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",shardedDatabaseId=").append(String.valueOf(this.shardedDatabaseId));
        sb.append(",metadata=").append(String.valueOf(this.metadata));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetShardedDatabaseRequest)) {
            return false;
        }
        GetShardedDatabaseRequest other = (GetShardedDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.shardedDatabaseId, other.shardedDatabaseId) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.shardedDatabaseId == null ? 43 : this.shardedDatabaseId.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetShardedDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String shardedDatabaseId = null;
        private String metadata = null;
        private String ifNoneMatch = null;
        private String opcRequestId = null;

        public Builder shardedDatabaseId(String shardedDatabaseId) {
            this.shardedDatabaseId = shardedDatabaseId;
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetShardedDatabaseRequest o) {
            this.shardedDatabaseId(o.getShardedDatabaseId());
            this.metadata(o.getMetadata());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetShardedDatabaseRequest build() {
            GetShardedDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetShardedDatabaseRequest buildWithoutInvocationCallback() {
            GetShardedDatabaseRequest request = new GetShardedDatabaseRequest();
            request.shardedDatabaseId = this.shardedDatabaseId;
            request.metadata = this.metadata;
            request.ifNoneMatch = this.ifNoneMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

