/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.globallydistributeddatabase.model.PatchShardedDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PatchShardedDatabaseRequest
extends BmcRequest<PatchShardedDatabaseDetails> {
    private String shardedDatabaseId;
    private PatchShardedDatabaseDetails patchShardedDatabaseDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getShardedDatabaseId() {
        return this.shardedDatabaseId;
    }

    public PatchShardedDatabaseDetails getPatchShardedDatabaseDetails() {
        return this.patchShardedDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PatchShardedDatabaseDetails getBody$() {
        return this.patchShardedDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().shardedDatabaseId(this.shardedDatabaseId).patchShardedDatabaseDetails(this.patchShardedDatabaseDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",shardedDatabaseId=").append(String.valueOf(this.shardedDatabaseId));
        sb.append(",patchShardedDatabaseDetails=").append(String.valueOf((Object)this.patchShardedDatabaseDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchShardedDatabaseRequest)) {
            return false;
        }
        PatchShardedDatabaseRequest other = (PatchShardedDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.shardedDatabaseId, other.shardedDatabaseId) && Objects.equals((Object)this.patchShardedDatabaseDetails, (Object)other.patchShardedDatabaseDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.shardedDatabaseId == null ? 43 : this.shardedDatabaseId.hashCode());
        result = result * 59 + (this.patchShardedDatabaseDetails == null ? 43 : this.patchShardedDatabaseDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PatchShardedDatabaseRequest, PatchShardedDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String shardedDatabaseId = null;
        private PatchShardedDatabaseDetails patchShardedDatabaseDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder shardedDatabaseId(String shardedDatabaseId) {
            this.shardedDatabaseId = shardedDatabaseId;
            return this;
        }

        public Builder patchShardedDatabaseDetails(PatchShardedDatabaseDetails patchShardedDatabaseDetails) {
            this.patchShardedDatabaseDetails = patchShardedDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PatchShardedDatabaseRequest o) {
            this.shardedDatabaseId(o.getShardedDatabaseId());
            this.patchShardedDatabaseDetails(o.getPatchShardedDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PatchShardedDatabaseRequest build() {
            PatchShardedDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PatchShardedDatabaseDetails body) {
            this.patchShardedDatabaseDetails(body);
            return this;
        }

        public PatchShardedDatabaseRequest buildWithoutInvocationCallback() {
            PatchShardedDatabaseRequest request = new PatchShardedDatabaseRequest();
            request.shardedDatabaseId = this.shardedDatabaseId;
            request.patchShardedDatabaseDetails = this.patchShardedDatabaseDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

