/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.globallydistributeddatabase.model.PrevalidateShardedDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PrevalidateShardedDatabaseRequest
extends BmcRequest<PrevalidateShardedDatabaseDetails> {
    private String compartmentId;
    private PrevalidateShardedDatabaseDetails prevalidateShardedDatabaseDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public PrevalidateShardedDatabaseDetails getPrevalidateShardedDatabaseDetails() {
        return this.prevalidateShardedDatabaseDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PrevalidateShardedDatabaseDetails getBody$() {
        return this.prevalidateShardedDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).prevalidateShardedDatabaseDetails(this.prevalidateShardedDatabaseDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",prevalidateShardedDatabaseDetails=").append(String.valueOf((Object)this.prevalidateShardedDatabaseDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrevalidateShardedDatabaseRequest)) {
            return false;
        }
        PrevalidateShardedDatabaseRequest other = (PrevalidateShardedDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.prevalidateShardedDatabaseDetails, (Object)other.prevalidateShardedDatabaseDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.prevalidateShardedDatabaseDetails == null ? 43 : this.prevalidateShardedDatabaseDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PrevalidateShardedDatabaseRequest, PrevalidateShardedDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private PrevalidateShardedDatabaseDetails prevalidateShardedDatabaseDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder prevalidateShardedDatabaseDetails(PrevalidateShardedDatabaseDetails prevalidateShardedDatabaseDetails) {
            this.prevalidateShardedDatabaseDetails = prevalidateShardedDatabaseDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PrevalidateShardedDatabaseRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.prevalidateShardedDatabaseDetails(o.getPrevalidateShardedDatabaseDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PrevalidateShardedDatabaseRequest build() {
            PrevalidateShardedDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PrevalidateShardedDatabaseDetails body) {
            this.prevalidateShardedDatabaseDetails(body);
            return this;
        }

        public PrevalidateShardedDatabaseRequest buildWithoutInvocationCallback() {
            PrevalidateShardedDatabaseRequest request = new PrevalidateShardedDatabaseRequest();
            request.compartmentId = this.compartmentId;
            request.prevalidateShardedDatabaseDetails = this.prevalidateShardedDatabaseDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

