/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ReinstateProxyInstanceRequest
extends BmcRequest<Void> {
    private String privateEndpointId;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().privateEndpointId(this.privateEndpointId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReinstateProxyInstanceRequest)) {
            return false;
        }
        ReinstateProxyInstanceRequest other = (ReinstateProxyInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.privateEndpointId, other.privateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ReinstateProxyInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String privateEndpointId = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ReinstateProxyInstanceRequest o) {
            this.privateEndpointId(o.getPrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ReinstateProxyInstanceRequest build() {
            ReinstateProxyInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ReinstateProxyInstanceRequest buildWithoutInvocationCallback() {
            ReinstateProxyInstanceRequest request = new ReinstateProxyInstanceRequest();
            request.privateEndpointId = this.privateEndpointId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

