/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.globallydistributeddatabase.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidateNetworkRequest
extends BmcRequest<Void> {
    private String shardedDatabaseId;
    private Boolean isSurrogate;
    private String resourceName;
    private Boolean isPrimary;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getShardedDatabaseId() {
        return this.shardedDatabaseId;
    }

    public Boolean getIsSurrogate() {
        return this.isSurrogate;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().shardedDatabaseId(this.shardedDatabaseId).isSurrogate(this.isSurrogate).resourceName(this.resourceName).isPrimary(this.isPrimary).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",shardedDatabaseId=").append(String.valueOf(this.shardedDatabaseId));
        sb.append(",isSurrogate=").append(String.valueOf(this.isSurrogate));
        sb.append(",resourceName=").append(String.valueOf(this.resourceName));
        sb.append(",isPrimary=").append(String.valueOf(this.isPrimary));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidateNetworkRequest)) {
            return false;
        }
        ValidateNetworkRequest other = (ValidateNetworkRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.shardedDatabaseId, other.shardedDatabaseId) && Objects.equals(this.isSurrogate, other.isSurrogate) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.isPrimary, other.isPrimary) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.shardedDatabaseId == null ? 43 : this.shardedDatabaseId.hashCode());
        result = result * 59 + (this.isSurrogate == null ? 43 : this.isSurrogate.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.isPrimary == null ? 43 : this.isPrimary.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateNetworkRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String shardedDatabaseId = null;
        private Boolean isSurrogate = null;
        private String resourceName = null;
        private Boolean isPrimary = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder shardedDatabaseId(String shardedDatabaseId) {
            this.shardedDatabaseId = shardedDatabaseId;
            return this;
        }

        public Builder isSurrogate(Boolean isSurrogate) {
            this.isSurrogate = isSurrogate;
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateNetworkRequest o) {
            this.shardedDatabaseId(o.getShardedDatabaseId());
            this.isSurrogate(o.getIsSurrogate());
            this.resourceName(o.getResourceName());
            this.isPrimary(o.getIsPrimary());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateNetworkRequest build() {
            ValidateNetworkRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ValidateNetworkRequest buildWithoutInvocationCallback() {
            ValidateNetworkRequest request = new ValidateNetworkRequest();
            request.shardedDatabaseId = this.shardedDatabaseId;
            request.isSurrogate = this.isSurrogate;
            request.resourceName = this.resourceName;
            request.isPrimary = this.isPrimary;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

