/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDatabaseRegistrationRequest
extends BmcRequest<Void> {
    private String databaseRegistrationId;
    private String opcRequestId;

    @ConstructorProperties(value={"databaseRegistrationId", "opcRequestId"})
    GetDatabaseRegistrationRequest(String databaseRegistrationId, String opcRequestId) {
        this.databaseRegistrationId = databaseRegistrationId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseRegistrationId() {
        return this.databaseRegistrationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseRegistrationRequest, Void> {
        private String databaseRegistrationId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseRegistrationRequest o) {
            this.databaseRegistrationId(o.getDatabaseRegistrationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseRegistrationRequest build() {
            GetDatabaseRegistrationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseRegistrationId(String databaseRegistrationId) {
            this.databaseRegistrationId = databaseRegistrationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDatabaseRegistrationRequest buildWithoutInvocationCallback() {
            return new GetDatabaseRegistrationRequest(this.databaseRegistrationId, this.opcRequestId);
        }

        public String toString() {
            return "GetDatabaseRegistrationRequest.Builder(databaseRegistrationId=" + this.databaseRegistrationId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

