/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.Connection;
import com.oracle.bmc.goldengate.model.ConnectionSummary;
import com.oracle.bmc.goldengate.model.IngressIpDetails;
import com.oracle.bmc.goldengate.model.NameValuePair;
import com.oracle.bmc.goldengate.model.PostgresqlConnection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class PostgresqlConnectionSummary
extends ConnectionSummary {
    @JsonProperty(value="technologyType")
    private final PostgresqlConnection.TechnologyType technologyType;
    @JsonProperty(value="databaseName")
    private final String databaseName;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="additionalAttributes")
    private final List<NameValuePair> additionalAttributes;
    @JsonProperty(value="securityProtocol")
    private final PostgresqlConnection.SecurityProtocol securityProtocol;
    @JsonProperty(value="sslMode")
    private final PostgresqlConnection.SslMode sslMode;
    @JsonProperty(value="privateIp")
    private final String privateIp;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PostgresqlConnectionSummary(String id, String displayName, String description, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, Connection.LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated, String vaultId, String keyId, String subnetId, List<IngressIpDetails> ingressIps, List<String> nsgIds, PostgresqlConnection.TechnologyType technologyType, String databaseName, String host, Integer port, String username, List<NameValuePair> additionalAttributes, PostgresqlConnection.SecurityProtocol securityProtocol, PostgresqlConnection.SslMode sslMode, String privateIp) {
        super(id, displayName, description, compartmentId, freeformTags, definedTags, systemTags, lifecycleState, lifecycleDetails, timeCreated, timeUpdated, vaultId, keyId, subnetId, ingressIps, nsgIds);
        this.technologyType = technologyType;
        this.databaseName = databaseName;
        this.host = host;
        this.port = port;
        this.username = username;
        this.additionalAttributes = additionalAttributes;
        this.securityProtocol = securityProtocol;
        this.sslMode = sslMode;
        this.privateIp = privateIp;
    }

    public PostgresqlConnection.TechnologyType getTechnologyType() {
        return this.technologyType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public List<NameValuePair> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public PostgresqlConnection.SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public PostgresqlConnection.SslMode getSslMode() {
        return this.sslMode;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PostgresqlConnectionSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", technologyType=").append(String.valueOf((Object)this.technologyType));
        sb.append(", databaseName=").append(String.valueOf(this.databaseName));
        sb.append(", host=").append(String.valueOf(this.host));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", additionalAttributes=").append(String.valueOf(this.additionalAttributes));
        sb.append(", securityProtocol=").append(String.valueOf((Object)this.securityProtocol));
        sb.append(", sslMode=").append(String.valueOf((Object)this.sslMode));
        sb.append(", privateIp=").append(String.valueOf(this.privateIp));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostgresqlConnectionSummary)) {
            return false;
        }
        PostgresqlConnectionSummary other = (PostgresqlConnectionSummary)((Object)o);
        return Objects.equals((Object)this.technologyType, (Object)other.technologyType) && Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port) && Objects.equals(this.username, other.username) && Objects.equals(this.additionalAttributes, other.additionalAttributes) && Objects.equals((Object)this.securityProtocol, (Object)other.securityProtocol) && Objects.equals((Object)this.sslMode, (Object)other.sslMode) && Objects.equals(this.privateIp, other.privateIp) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.technologyType == null ? 43 : this.technologyType.hashCode());
        result = result * 59 + (this.databaseName == null ? 43 : this.databaseName.hashCode());
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.additionalAttributes == null ? 43 : this.additionalAttributes.hashCode());
        result = result * 59 + (this.securityProtocol == null ? 43 : this.securityProtocol.hashCode());
        result = result * 59 + (this.sslMode == null ? 43 : this.sslMode.hashCode());
        result = result * 59 + (this.privateIp == null ? 43 : this.privateIp.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="lifecycleState")
        private Connection.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="ingressIps")
        private List<IngressIpDetails> ingressIps;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="technologyType")
        private PostgresqlConnection.TechnologyType technologyType;
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="additionalAttributes")
        private List<NameValuePair> additionalAttributes;
        @JsonProperty(value="securityProtocol")
        private PostgresqlConnection.SecurityProtocol securityProtocol;
        @JsonProperty(value="sslMode")
        private PostgresqlConnection.SslMode sslMode;
        @JsonProperty(value="privateIp")
        private String privateIp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder lifecycleState(Connection.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder ingressIps(List<IngressIpDetails> ingressIps) {
            this.ingressIps = ingressIps;
            this.__explicitlySet__.add("ingressIps");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder technologyType(PostgresqlConnection.TechnologyType technologyType) {
            this.technologyType = technologyType;
            this.__explicitlySet__.add("technologyType");
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder additionalAttributes(List<NameValuePair> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            this.__explicitlySet__.add("additionalAttributes");
            return this;
        }

        public Builder securityProtocol(PostgresqlConnection.SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
            this.__explicitlySet__.add("securityProtocol");
            return this;
        }

        public Builder sslMode(PostgresqlConnection.SslMode sslMode) {
            this.sslMode = sslMode;
            this.__explicitlySet__.add("sslMode");
            return this;
        }

        public Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            this.__explicitlySet__.add("privateIp");
            return this;
        }

        public PostgresqlConnectionSummary build() {
            PostgresqlConnectionSummary model = new PostgresqlConnectionSummary(this.id, this.displayName, this.description, this.compartmentId, this.freeformTags, this.definedTags, this.systemTags, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.vaultId, this.keyId, this.subnetId, this.ingressIps, this.nsgIds, this.technologyType, this.databaseName, this.host, this.port, this.username, this.additionalAttributes, this.securityProtocol, this.sslMode, this.privateIp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PostgresqlConnectionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("ingressIps")) {
                this.ingressIps(model.getIngressIps());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("technologyType")) {
                this.technologyType(model.getTechnologyType());
            }
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("additionalAttributes")) {
                this.additionalAttributes(model.getAdditionalAttributes());
            }
            if (model.wasPropertyExplicitlySet("securityProtocol")) {
                this.securityProtocol(model.getSecurityProtocol());
            }
            if (model.wasPropertyExplicitlySet("sslMode")) {
                this.sslMode(model.getSslMode());
            }
            if (model.wasPropertyExplicitlySet("privateIp")) {
                this.privateIp(model.getPrivateIp());
            }
            return this;
        }
    }
}

