/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.TestConnectionAssignmentError;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TestConnectionAssignmentResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resultType")
    private final ResultType resultType;
    @JsonProperty(value="error")
    private final TestConnectionAssignmentError error;

    @Deprecated
    @ConstructorProperties(value={"resultType", "error"})
    public TestConnectionAssignmentResult(ResultType resultType, TestConnectionAssignmentError error) {
        this.resultType = resultType;
        this.error = error;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public TestConnectionAssignmentError getError() {
        return this.error;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TestConnectionAssignmentResult(");
        sb.append("super=").append(super.toString());
        sb.append("resultType=").append(String.valueOf((Object)this.resultType));
        sb.append(", error=").append(String.valueOf((Object)this.error));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestConnectionAssignmentResult)) {
            return false;
        }
        TestConnectionAssignmentResult other = (TestConnectionAssignmentResult)((Object)o);
        return Objects.equals((Object)this.resultType, (Object)other.resultType) && Objects.equals((Object)this.error, (Object)other.error) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resultType == null ? 43 : this.resultType.hashCode());
        result = result * 59 + (this.error == null ? 43 : this.error.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResultType implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        TimedOut("TIMED_OUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResultType> map;

        private ResultType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResultType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResultType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResultType.class);
            map = new HashMap<String, ResultType>();
            for (ResultType v : ResultType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resultType")
        private ResultType resultType;
        @JsonProperty(value="error")
        private TestConnectionAssignmentError error;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resultType(ResultType resultType) {
            this.resultType = resultType;
            this.__explicitlySet__.add("resultType");
            return this;
        }

        public Builder error(TestConnectionAssignmentError error) {
            this.error = error;
            this.__explicitlySet__.add("error");
            return this;
        }

        public TestConnectionAssignmentResult build() {
            TestConnectionAssignmentResult model = new TestConnectionAssignmentResult(this.resultType, this.error);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TestConnectionAssignmentResult model) {
            if (model.wasPropertyExplicitlySet("resultType")) {
                this.resultType(model.getResultType());
            }
            if (model.wasPropertyExplicitlySet("error")) {
                this.error(model.getError());
            }
            return this;
        }
    }
}

