/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.KafkaBootstrapServer;
import com.oracle.bmc.goldengate.model.KafkaConnection;
import com.oracle.bmc.goldengate.model.UpdateConnectionDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateKafkaConnectionDetails
extends UpdateConnectionDetails {
    @JsonProperty(value="streamPoolId")
    private final String streamPoolId;
    @JsonProperty(value="bootstrapServers")
    private final List<KafkaBootstrapServer> bootstrapServers;
    @JsonProperty(value="securityProtocol")
    private final KafkaConnection.SecurityProtocol securityProtocol;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="trustStore")
    private final String trustStore;
    @JsonProperty(value="trustStorePassword")
    private final String trustStorePassword;
    @JsonProperty(value="keyStore")
    private final String keyStore;
    @JsonProperty(value="keyStorePassword")
    private final String keyStorePassword;
    @JsonProperty(value="sslKeyPassword")
    private final String sslKeyPassword;
    @JsonProperty(value="consumerProperties")
    private final String consumerProperties;
    @JsonProperty(value="producerProperties")
    private final String producerProperties;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateKafkaConnectionDetails(String displayName, String description, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String vaultId, String keyId, List<String> nsgIds, String streamPoolId, List<KafkaBootstrapServer> bootstrapServers, KafkaConnection.SecurityProtocol securityProtocol, String username, String password, String trustStore, String trustStorePassword, String keyStore, String keyStorePassword, String sslKeyPassword, String consumerProperties, String producerProperties) {
        super(displayName, description, freeformTags, definedTags, vaultId, keyId, nsgIds);
        this.streamPoolId = streamPoolId;
        this.bootstrapServers = bootstrapServers;
        this.securityProtocol = securityProtocol;
        this.username = username;
        this.password = password;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.sslKeyPassword = sslKeyPassword;
        this.consumerProperties = consumerProperties;
        this.producerProperties = producerProperties;
    }

    public String getStreamPoolId() {
        return this.streamPoolId;
    }

    public List<KafkaBootstrapServer> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public KafkaConnection.SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getConsumerProperties() {
        return this.consumerProperties;
    }

    public String getProducerProperties() {
        return this.producerProperties;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateKafkaConnectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", streamPoolId=").append(String.valueOf(this.streamPoolId));
        sb.append(", bootstrapServers=").append(String.valueOf(this.bootstrapServers));
        sb.append(", securityProtocol=").append(String.valueOf((Object)this.securityProtocol));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", password=").append("<redacted>");
        sb.append(", trustStore=").append(String.valueOf(this.trustStore));
        sb.append(", trustStorePassword=").append("<redacted>");
        sb.append(", keyStore=").append(String.valueOf(this.keyStore));
        sb.append(", keyStorePassword=").append("<redacted>");
        sb.append(", sslKeyPassword=").append("<redacted>");
        sb.append(", consumerProperties=").append(String.valueOf(this.consumerProperties));
        sb.append(", producerProperties=").append(String.valueOf(this.producerProperties));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateKafkaConnectionDetails)) {
            return false;
        }
        UpdateKafkaConnectionDetails other = (UpdateKafkaConnectionDetails)((Object)o);
        return Objects.equals(this.streamPoolId, other.streamPoolId) && Objects.equals(this.bootstrapServers, other.bootstrapServers) && Objects.equals((Object)this.securityProtocol, (Object)other.securityProtocol) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.trustStore, other.trustStore) && Objects.equals(this.trustStorePassword, other.trustStorePassword) && Objects.equals(this.keyStore, other.keyStore) && Objects.equals(this.keyStorePassword, other.keyStorePassword) && Objects.equals(this.sslKeyPassword, other.sslKeyPassword) && Objects.equals(this.consumerProperties, other.consumerProperties) && Objects.equals(this.producerProperties, other.producerProperties) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamPoolId == null ? 43 : this.streamPoolId.hashCode());
        result = result * 59 + (this.bootstrapServers == null ? 43 : this.bootstrapServers.hashCode());
        result = result * 59 + (this.securityProtocol == null ? 43 : this.securityProtocol.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.trustStore == null ? 43 : this.trustStore.hashCode());
        result = result * 59 + (this.trustStorePassword == null ? 43 : this.trustStorePassword.hashCode());
        result = result * 59 + (this.keyStore == null ? 43 : this.keyStore.hashCode());
        result = result * 59 + (this.keyStorePassword == null ? 43 : this.keyStorePassword.hashCode());
        result = result * 59 + (this.sslKeyPassword == null ? 43 : this.sslKeyPassword.hashCode());
        result = result * 59 + (this.consumerProperties == null ? 43 : this.consumerProperties.hashCode());
        result = result * 59 + (this.producerProperties == null ? 43 : this.producerProperties.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="streamPoolId")
        private String streamPoolId;
        @JsonProperty(value="bootstrapServers")
        private List<KafkaBootstrapServer> bootstrapServers;
        @JsonProperty(value="securityProtocol")
        private KafkaConnection.SecurityProtocol securityProtocol;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="trustStore")
        private String trustStore;
        @JsonProperty(value="trustStorePassword")
        private String trustStorePassword;
        @JsonProperty(value="keyStore")
        private String keyStore;
        @JsonProperty(value="keyStorePassword")
        private String keyStorePassword;
        @JsonProperty(value="sslKeyPassword")
        private String sslKeyPassword;
        @JsonProperty(value="consumerProperties")
        private String consumerProperties;
        @JsonProperty(value="producerProperties")
        private String producerProperties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder streamPoolId(String streamPoolId) {
            this.streamPoolId = streamPoolId;
            this.__explicitlySet__.add("streamPoolId");
            return this;
        }

        public Builder bootstrapServers(List<KafkaBootstrapServer> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            this.__explicitlySet__.add("bootstrapServers");
            return this;
        }

        public Builder securityProtocol(KafkaConnection.SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
            this.__explicitlySet__.add("securityProtocol");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder trustStore(String trustStore) {
            this.trustStore = trustStore;
            this.__explicitlySet__.add("trustStore");
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            this.__explicitlySet__.add("trustStorePassword");
            return this;
        }

        public Builder keyStore(String keyStore) {
            this.keyStore = keyStore;
            this.__explicitlySet__.add("keyStore");
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            this.__explicitlySet__.add("keyStorePassword");
            return this;
        }

        public Builder sslKeyPassword(String sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
            this.__explicitlySet__.add("sslKeyPassword");
            return this;
        }

        public Builder consumerProperties(String consumerProperties) {
            this.consumerProperties = consumerProperties;
            this.__explicitlySet__.add("consumerProperties");
            return this;
        }

        public Builder producerProperties(String producerProperties) {
            this.producerProperties = producerProperties;
            this.__explicitlySet__.add("producerProperties");
            return this;
        }

        public UpdateKafkaConnectionDetails build() {
            UpdateKafkaConnectionDetails model = new UpdateKafkaConnectionDetails(this.displayName, this.description, this.freeformTags, this.definedTags, this.vaultId, this.keyId, this.nsgIds, this.streamPoolId, this.bootstrapServers, this.securityProtocol, this.username, this.password, this.trustStore, this.trustStorePassword, this.keyStore, this.keyStorePassword, this.sslKeyPassword, this.consumerProperties, this.producerProperties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateKafkaConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("streamPoolId")) {
                this.streamPoolId(model.getStreamPoolId());
            }
            if (model.wasPropertyExplicitlySet("bootstrapServers")) {
                this.bootstrapServers(model.getBootstrapServers());
            }
            if (model.wasPropertyExplicitlySet("securityProtocol")) {
                this.securityProtocol(model.getSecurityProtocol());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("trustStore")) {
                this.trustStore(model.getTrustStore());
            }
            if (model.wasPropertyExplicitlySet("trustStorePassword")) {
                this.trustStorePassword(model.getTrustStorePassword());
            }
            if (model.wasPropertyExplicitlySet("keyStore")) {
                this.keyStore(model.getKeyStore());
            }
            if (model.wasPropertyExplicitlySet("keyStorePassword")) {
                this.keyStorePassword(model.getKeyStorePassword());
            }
            if (model.wasPropertyExplicitlySet("sslKeyPassword")) {
                this.sslKeyPassword(model.getSslKeyPassword());
            }
            if (model.wasPropertyExplicitlySet("consumerProperties")) {
                this.consumerProperties(model.getConsumerProperties());
            }
            if (model.wasPropertyExplicitlySet("producerProperties")) {
                this.producerProperties(model.getProducerProperties());
            }
            return this;
        }
    }
}

