/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.goldengate.model.ExportDeploymentWalletDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ExportDeploymentWalletRequest
extends BmcRequest<ExportDeploymentWalletDetails> {
    private String deploymentId;
    private ExportDeploymentWalletDetails exportDeploymentWalletDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public ExportDeploymentWalletDetails getExportDeploymentWalletDetails() {
        return this.exportDeploymentWalletDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ExportDeploymentWalletDetails getBody$() {
        return this.exportDeploymentWalletDetails;
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).exportDeploymentWalletDetails(this.exportDeploymentWalletDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(",exportDeploymentWalletDetails=").append(String.valueOf((Object)this.exportDeploymentWalletDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportDeploymentWalletRequest)) {
            return false;
        }
        ExportDeploymentWalletRequest other = (ExportDeploymentWalletRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals((Object)this.exportDeploymentWalletDetails, (Object)other.exportDeploymentWalletDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        result = result * 59 + (this.exportDeploymentWalletDetails == null ? 43 : this.exportDeploymentWalletDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportDeploymentWalletRequest, ExportDeploymentWalletDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentId = null;
        private ExportDeploymentWalletDetails exportDeploymentWalletDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder exportDeploymentWalletDetails(ExportDeploymentWalletDetails exportDeploymentWalletDetails) {
            this.exportDeploymentWalletDetails = exportDeploymentWalletDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportDeploymentWalletRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.exportDeploymentWalletDetails(o.getExportDeploymentWalletDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportDeploymentWalletRequest build() {
            ExportDeploymentWalletRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportDeploymentWalletDetails body) {
            this.exportDeploymentWalletDetails(body);
            return this;
        }

        public ExportDeploymentWalletRequest buildWithoutInvocationCallback() {
            ExportDeploymentWalletRequest request = new ExportDeploymentWalletRequest();
            request.deploymentId = this.deploymentId;
            request.exportDeploymentWalletDetails = this.exportDeploymentWalletDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

