/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.goldengate.model.ImportDeploymentWalletDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ImportDeploymentWalletRequest
extends BmcRequest<ImportDeploymentWalletDetails> {
    private String deploymentId;
    private ImportDeploymentWalletDetails importDeploymentWalletDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public ImportDeploymentWalletDetails getImportDeploymentWalletDetails() {
        return this.importDeploymentWalletDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ImportDeploymentWalletDetails getBody$() {
        return this.importDeploymentWalletDetails;
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).importDeploymentWalletDetails(this.importDeploymentWalletDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(",importDeploymentWalletDetails=").append(String.valueOf((Object)this.importDeploymentWalletDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportDeploymentWalletRequest)) {
            return false;
        }
        ImportDeploymentWalletRequest other = (ImportDeploymentWalletRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals((Object)this.importDeploymentWalletDetails, (Object)other.importDeploymentWalletDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        result = result * 59 + (this.importDeploymentWalletDetails == null ? 43 : this.importDeploymentWalletDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportDeploymentWalletRequest, ImportDeploymentWalletDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentId = null;
        private ImportDeploymentWalletDetails importDeploymentWalletDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder importDeploymentWalletDetails(ImportDeploymentWalletDetails importDeploymentWalletDetails) {
            this.importDeploymentWalletDetails = importDeploymentWalletDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportDeploymentWalletRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.importDeploymentWalletDetails(o.getImportDeploymentWalletDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportDeploymentWalletRequest build() {
            ImportDeploymentWalletRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportDeploymentWalletDetails body) {
            this.importDeploymentWalletDetails(body);
            return this;
        }

        public ImportDeploymentWalletRequest buildWithoutInvocationCallback() {
            ImportDeploymentWalletRequest request = new ImportDeploymentWalletRequest();
            request.deploymentId = this.deploymentId;
            request.importDeploymentWalletDetails = this.importDeploymentWalletDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

