/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.goldengate.GoldenGateAsync;
import com.oracle.bmc.goldengate.model.Certificate;
import com.oracle.bmc.goldengate.model.CertificateCollection;
import com.oracle.bmc.goldengate.model.Connection;
import com.oracle.bmc.goldengate.model.ConnectionAssignment;
import com.oracle.bmc.goldengate.model.ConnectionAssignmentCollection;
import com.oracle.bmc.goldengate.model.ConnectionCollection;
import com.oracle.bmc.goldengate.model.DatabaseRegistration;
import com.oracle.bmc.goldengate.model.DatabaseRegistrationCollection;
import com.oracle.bmc.goldengate.model.Deployment;
import com.oracle.bmc.goldengate.model.DeploymentBackup;
import com.oracle.bmc.goldengate.model.DeploymentBackupCollection;
import com.oracle.bmc.goldengate.model.DeploymentCollection;
import com.oracle.bmc.goldengate.model.DeploymentMessageCollection;
import com.oracle.bmc.goldengate.model.DeploymentTypeCollection;
import com.oracle.bmc.goldengate.model.DeploymentUpgrade;
import com.oracle.bmc.goldengate.model.DeploymentUpgradeCollection;
import com.oracle.bmc.goldengate.model.DeploymentVersionCollection;
import com.oracle.bmc.goldengate.model.DeploymentWalletExistsResponseDetails;
import com.oracle.bmc.goldengate.model.DeploymentWalletsOperationCollection;
import com.oracle.bmc.goldengate.model.TestConnectionAssignmentResult;
import com.oracle.bmc.goldengate.model.TrailFileCollection;
import com.oracle.bmc.goldengate.model.TrailSequenceCollection;
import com.oracle.bmc.goldengate.model.WorkRequest;
import com.oracle.bmc.goldengate.model.WorkRequestError;
import com.oracle.bmc.goldengate.model.WorkRequestLogEntry;
import com.oracle.bmc.goldengate.requests.CancelDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CancelDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.CancelSnoozeDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.ChangeConnectionCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDatabaseRegistrationCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentBackupCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentCompartmentRequest;
import com.oracle.bmc.goldengate.requests.CollectDeploymentDiagnosticRequest;
import com.oracle.bmc.goldengate.requests.CopyDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CreateCertificateRequest;
import com.oracle.bmc.goldengate.requests.CreateConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.CreateConnectionRequest;
import com.oracle.bmc.goldengate.requests.CreateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.DeleteCertificateRequest;
import com.oracle.bmc.goldengate.requests.DeleteConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.DeleteConnectionRequest;
import com.oracle.bmc.goldengate.requests.DeleteDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentRequest;
import com.oracle.bmc.goldengate.requests.DeploymentWalletExistsRequest;
import com.oracle.bmc.goldengate.requests.ExportDeploymentWalletRequest;
import com.oracle.bmc.goldengate.requests.GetCertificateRequest;
import com.oracle.bmc.goldengate.requests.GetConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.GetConnectionRequest;
import com.oracle.bmc.goldengate.requests.GetDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.GetWorkRequestRequest;
import com.oracle.bmc.goldengate.requests.ImportDeploymentWalletRequest;
import com.oracle.bmc.goldengate.requests.ListCertificatesRequest;
import com.oracle.bmc.goldengate.requests.ListConnectionAssignmentsRequest;
import com.oracle.bmc.goldengate.requests.ListConnectionsRequest;
import com.oracle.bmc.goldengate.requests.ListDatabaseRegistrationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentBackupsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentTypesRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentUpgradesRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentVersionsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentWalletsOperationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentsRequest;
import com.oracle.bmc.goldengate.requests.ListMessagesRequest;
import com.oracle.bmc.goldengate.requests.ListTrailFilesRequest;
import com.oracle.bmc.goldengate.requests.ListTrailSequencesRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.goldengate.requests.RescheduleDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.RestoreDeploymentRequest;
import com.oracle.bmc.goldengate.requests.RollbackDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.SnoozeDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.StartDeploymentRequest;
import com.oracle.bmc.goldengate.requests.StopDeploymentRequest;
import com.oracle.bmc.goldengate.requests.TestConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.UpdateConnectionRequest;
import com.oracle.bmc.goldengate.requests.UpdateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpgradeDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpgradeDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.responses.CancelDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CancelDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.CancelSnoozeDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.ChangeConnectionCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDatabaseRegistrationCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentBackupCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentCompartmentResponse;
import com.oracle.bmc.goldengate.responses.CollectDeploymentDiagnosticResponse;
import com.oracle.bmc.goldengate.responses.CopyDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CreateCertificateResponse;
import com.oracle.bmc.goldengate.responses.CreateConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.CreateConnectionResponse;
import com.oracle.bmc.goldengate.responses.CreateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.DeleteCertificateResponse;
import com.oracle.bmc.goldengate.responses.DeleteConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.DeleteConnectionResponse;
import com.oracle.bmc.goldengate.responses.DeleteDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentResponse;
import com.oracle.bmc.goldengate.responses.DeploymentWalletExistsResponse;
import com.oracle.bmc.goldengate.responses.ExportDeploymentWalletResponse;
import com.oracle.bmc.goldengate.responses.GetCertificateResponse;
import com.oracle.bmc.goldengate.responses.GetConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.GetConnectionResponse;
import com.oracle.bmc.goldengate.responses.GetDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.GetWorkRequestResponse;
import com.oracle.bmc.goldengate.responses.ImportDeploymentWalletResponse;
import com.oracle.bmc.goldengate.responses.ListCertificatesResponse;
import com.oracle.bmc.goldengate.responses.ListConnectionAssignmentsResponse;
import com.oracle.bmc.goldengate.responses.ListConnectionsResponse;
import com.oracle.bmc.goldengate.responses.ListDatabaseRegistrationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentBackupsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentTypesResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentUpgradesResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentVersionsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentWalletsOperationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentsResponse;
import com.oracle.bmc.goldengate.responses.ListMessagesResponse;
import com.oracle.bmc.goldengate.responses.ListTrailFilesResponse;
import com.oracle.bmc.goldengate.responses.ListTrailSequencesResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.goldengate.responses.RescheduleDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.RestoreDeploymentResponse;
import com.oracle.bmc.goldengate.responses.RollbackDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.SnoozeDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.StartDeploymentResponse;
import com.oracle.bmc.goldengate.responses.StopDeploymentResponse;
import com.oracle.bmc.goldengate.responses.TestConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.UpdateConnectionResponse;
import com.oracle.bmc.goldengate.responses.UpdateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpgradeDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpgradeDeploymentUpgradeResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldenGateAsyncClient
extends BaseAsyncClient
implements GoldenGateAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GOLDENGATE").serviceEndpointPrefix("").serviceEndpointTemplate("https://goldengate.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GoldenGateAsyncClient.class);

    GoldenGateAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelDeploymentBackupResponse> cancelDeploymentBackup(CancelDeploymentBackupRequest request, AsyncHandler<CancelDeploymentBackupRequest, CancelDeploymentBackupResponse> handler) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelDeploymentBackupDetails(), "cancelDeploymentBackupDetails is required");
        return this.clientCall(request, CancelDeploymentBackupResponse::builder).logger(LOG, "cancelDeploymentBackup").serviceDetails("GoldenGate", "CancelDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/CancelDeploymentBackup").method(Method.POST).requestBuilder(CancelDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CancelDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CancelDeploymentBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelDeploymentUpgradeResponse> cancelDeploymentUpgrade(CancelDeploymentUpgradeRequest request, AsyncHandler<CancelDeploymentUpgradeRequest, CancelDeploymentUpgradeResponse> handler) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelDeploymentUpgradeDetails(), "cancelDeploymentUpgradeDetails is required");
        return this.clientCall(request, CancelDeploymentUpgradeResponse::builder).logger(LOG, "cancelDeploymentUpgrade").serviceDetails("GoldenGate", "CancelDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/CancelDeploymentUpgrade").method(Method.POST).requestBuilder(CancelDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DeploymentUpgrade.class, CancelDeploymentUpgradeResponse.Builder::deploymentUpgrade).handleResponseHeaderString("etag", CancelDeploymentUpgradeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelDeploymentUpgradeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelSnoozeDeploymentUpgradeResponse> cancelSnoozeDeploymentUpgrade(CancelSnoozeDeploymentUpgradeRequest request, AsyncHandler<CancelSnoozeDeploymentUpgradeRequest, CancelSnoozeDeploymentUpgradeResponse> handler) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelSnoozeDeploymentUpgradeDetails(), "cancelSnoozeDeploymentUpgradeDetails is required");
        return this.clientCall(request, CancelSnoozeDeploymentUpgradeResponse::builder).logger(LOG, "cancelSnoozeDeploymentUpgrade").serviceDetails("GoldenGate", "CancelSnoozeDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/CancelSnoozeDeploymentUpgrade").method(Method.POST).requestBuilder(CancelSnoozeDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("cancelSnooze").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CancelSnoozeDeploymentUpgradeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeConnectionCompartmentResponse> changeConnectionCompartment(ChangeConnectionCompartmentRequest request, AsyncHandler<ChangeConnectionCompartmentRequest, ChangeConnectionCompartmentResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConnectionCompartmentDetails(), "changeConnectionCompartmentDetails is required");
        return this.clientCall(request, ChangeConnectionCompartmentResponse::builder).logger(LOG, "changeConnectionCompartment").serviceDetails("GoldenGate", "ChangeConnectionCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/ChangeConnectionCompartment").method(Method.POST).requestBuilder(ChangeConnectionCompartmentRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeConnectionCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeConnectionCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDatabaseRegistrationCompartmentResponse> changeDatabaseRegistrationCompartment(ChangeDatabaseRegistrationCompartmentRequest request, AsyncHandler<ChangeDatabaseRegistrationCompartmentRequest, ChangeDatabaseRegistrationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatabaseRegistrationCompartmentDetails(), "changeDatabaseRegistrationCompartmentDetails is required");
        return this.clientCall(request, ChangeDatabaseRegistrationCompartmentResponse::builder).logger(LOG, "changeDatabaseRegistrationCompartment").serviceDetails("GoldenGate", "ChangeDatabaseRegistrationCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/ChangeDatabaseRegistrationCompartment").method(Method.POST).requestBuilder(ChangeDatabaseRegistrationCompartmentRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDatabaseRegistrationCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDatabaseRegistrationCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", ChangeDatabaseRegistrationCompartmentResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<ChangeDeploymentBackupCompartmentResponse> changeDeploymentBackupCompartment(ChangeDeploymentBackupCompartmentRequest request, AsyncHandler<ChangeDeploymentBackupCompartmentRequest, ChangeDeploymentBackupCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDeploymentBackupCompartmentDetails(), "changeDeploymentBackupCompartmentDetails is required");
        return this.clientCall(request, ChangeDeploymentBackupCompartmentResponse::builder).logger(LOG, "changeDeploymentBackupCompartment").serviceDetails("GoldenGate", "ChangeDeploymentBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/ChangeDeploymentBackupCompartment").method(Method.POST).requestBuilder(ChangeDeploymentBackupCompartmentRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDeploymentBackupCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDeploymentCompartmentResponse> changeDeploymentCompartment(ChangeDeploymentCompartmentRequest request, AsyncHandler<ChangeDeploymentCompartmentRequest, ChangeDeploymentCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDeploymentCompartmentDetails(), "changeDeploymentCompartmentDetails is required");
        return this.clientCall(request, ChangeDeploymentCompartmentResponse::builder).logger(LOG, "changeDeploymentCompartment").serviceDetails("GoldenGate", "ChangeDeploymentCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ChangeDeploymentCompartment").method(Method.POST).requestBuilder(ChangeDeploymentCompartmentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDeploymentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDeploymentCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CollectDeploymentDiagnosticResponse> collectDeploymentDiagnostic(CollectDeploymentDiagnosticRequest request, AsyncHandler<CollectDeploymentDiagnosticRequest, CollectDeploymentDiagnosticResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCollectDeploymentDiagnosticDetails(), "collectDeploymentDiagnosticDetails is required");
        return this.clientCall(request, CollectDeploymentDiagnosticResponse::builder).logger(LOG, "collectDeploymentDiagnostic").serviceDetails("GoldenGate", "CollectDeploymentDiagnostic", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/CollectDeploymentDiagnostic").method(Method.POST).requestBuilder(CollectDeploymentDiagnosticRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("collectDiagnostics").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CollectDeploymentDiagnosticResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CollectDeploymentDiagnosticResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CopyDeploymentBackupResponse> copyDeploymentBackup(CopyDeploymentBackupRequest request, AsyncHandler<CopyDeploymentBackupRequest, CopyDeploymentBackupResponse> handler) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCopyDeploymentBackupDetails(), "copyDeploymentBackupDetails is required");
        return this.clientCall(request, CopyDeploymentBackupResponse::builder).logger(LOG, "copyDeploymentBackup").serviceDetails("GoldenGate", "CopyDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/CopyDeploymentBackup").method(Method.POST).requestBuilder(CopyDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("copyToBucket").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CopyDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CopyDeploymentBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        Objects.requireNonNull(request.getCreateCertificateDetails(), "createCertificateDetails is required");
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateCertificateResponse::builder).logger(LOG, "createCertificate").serviceDetails("GoldenGate", "CreateCertificate", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/CertificateCollection/CreateCertificate").method(Method.POST).requestBuilder(CreateCertificateRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("GoldenGate", "CreateConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/CreateConnection").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("opc-work-request-id", CreateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionAssignmentResponse> createConnectionAssignment(CreateConnectionAssignmentRequest request, AsyncHandler<CreateConnectionAssignmentRequest, CreateConnectionAssignmentResponse> handler) {
        Objects.requireNonNull(request.getCreateConnectionAssignmentDetails(), "createConnectionAssignmentDetails is required");
        return this.clientCall(request, CreateConnectionAssignmentResponse::builder).logger(LOG, "createConnectionAssignment").serviceDetails("GoldenGate", "CreateConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/CreateConnectionAssignment").method(Method.POST).requestBuilder(CreateConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ConnectionAssignment.class, CreateConnectionAssignmentResponse.Builder::connectionAssignment).handleResponseHeaderString("opc-work-request-id", CreateConnectionAssignmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateConnectionAssignmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectionAssignmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateDatabaseRegistrationResponse> createDatabaseRegistration(CreateDatabaseRegistrationRequest request, AsyncHandler<CreateDatabaseRegistrationRequest, CreateDatabaseRegistrationResponse> handler) {
        Objects.requireNonNull(request.getCreateDatabaseRegistrationDetails(), "createDatabaseRegistrationDetails is required");
        return this.clientCall(request, CreateDatabaseRegistrationResponse::builder).logger(LOG, "createDatabaseRegistration").serviceDetails("GoldenGate", "CreateDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/CreateDatabaseRegistration").method(Method.POST).requestBuilder(CreateDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DatabaseRegistration.class, CreateDatabaseRegistrationResponse.Builder::databaseRegistration).handleResponseHeaderString("opc-work-request-id", CreateDatabaseRegistrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDatabaseRegistrationResponse.Builder::etag).handleResponseHeaderString("sunset", CreateDatabaseRegistrationResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest request, AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handler) {
        Objects.requireNonNull(request.getCreateDeploymentDetails(), "createDeploymentDetails is required");
        return this.clientCall(request, CreateDeploymentResponse::builder).logger(LOG, "createDeployment").serviceDetails("GoldenGate", "CreateDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/CreateDeployment").method(Method.POST).requestBuilder(CreateDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Deployment.class, CreateDeploymentResponse.Builder::deployment).handleResponseHeaderString("opc-work-request-id", CreateDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeploymentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDeploymentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateDeploymentBackupResponse> createDeploymentBackup(CreateDeploymentBackupRequest request, AsyncHandler<CreateDeploymentBackupRequest, CreateDeploymentBackupResponse> handler) {
        Objects.requireNonNull(request.getCreateDeploymentBackupDetails(), "createDeploymentBackupDetails is required");
        return this.clientCall(request, CreateDeploymentBackupResponse::builder).logger(LOG, "createDeploymentBackup").serviceDetails("GoldenGate", "CreateDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/CreateDeploymentBackup").method(Method.POST).requestBuilder(CreateDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeploymentBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCertificateKey(), (String)"certificateKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCertificateResponse::builder).logger(LOG, "deleteCertificate").serviceDetails("GoldenGate", "DeleteCertificate", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Certificate/DeleteCertificate").method(Method.DELETE).requestBuilder(DeleteCertificateRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").appendPathParam(request.getCertificateKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("GoldenGate", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectionAssignmentResponse> deleteConnectionAssignment(DeleteConnectionAssignmentRequest request, AsyncHandler<DeleteConnectionAssignmentRequest, DeleteConnectionAssignmentResponse> handler) {
        Validate.notBlank((String)request.getConnectionAssignmentId(), (String)"connectionAssignmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectionAssignmentResponse::builder).logger(LOG, "deleteConnectionAssignment").serviceDetails("GoldenGate", "DeleteConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/DeleteConnectionAssignment").method(Method.DELETE).requestBuilder(DeleteConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendPathParam(request.getConnectionAssignmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteConnectionAssignmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteConnectionAssignmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDatabaseRegistrationResponse> deleteDatabaseRegistration(DeleteDatabaseRegistrationRequest request, AsyncHandler<DeleteDatabaseRegistrationRequest, DeleteDatabaseRegistrationResponse> handler) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDatabaseRegistrationResponse::builder).logger(LOG, "deleteDatabaseRegistration").serviceDetails("GoldenGate", "DeleteDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/DeleteDatabaseRegistration").method(Method.DELETE).requestBuilder(DeleteDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDatabaseRegistrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", DeleteDatabaseRegistrationResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest request, AsyncHandler<DeleteDeploymentRequest, DeleteDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDeploymentResponse::builder).logger(LOG, "deleteDeployment").serviceDetails("GoldenGate", "DeleteDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/DeleteDeployment").method(Method.DELETE).requestBuilder(DeleteDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDeploymentBackupResponse> deleteDeploymentBackup(DeleteDeploymentBackupRequest request, AsyncHandler<DeleteDeploymentBackupRequest, DeleteDeploymentBackupResponse> handler) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDeploymentBackupResponse::builder).logger(LOG, "deleteDeploymentBackup").serviceDetails("GoldenGate", "DeleteDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/DeleteDeploymentBackup").method(Method.DELETE).requestBuilder(DeleteDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeploymentBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeploymentWalletExistsResponse> deploymentWalletExists(DeploymentWalletExistsRequest request, AsyncHandler<DeploymentWalletExistsRequest, DeploymentWalletExistsResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeploymentWalletExistsDetails(), "deploymentWalletExistsDetails is required");
        return this.clientCall(request, DeploymentWalletExistsResponse::builder).logger(LOG, "deploymentWalletExists").serviceDetails("GoldenGate", "DeploymentWalletExists", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/DeploymentWalletExists").method(Method.POST).requestBuilder(DeploymentWalletExistsRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("walletExists").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DeploymentWalletExistsResponseDetails.class, DeploymentWalletExistsResponse.Builder::deploymentWalletExistsResponseDetails).handleResponseHeaderString("opc-request-id", DeploymentWalletExistsResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DeploymentWalletExistsResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ExportDeploymentWalletResponse> exportDeploymentWallet(ExportDeploymentWalletRequest request, AsyncHandler<ExportDeploymentWalletRequest, ExportDeploymentWalletResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportDeploymentWalletDetails(), "exportDeploymentWalletDetails is required");
        return this.clientCall(request, ExportDeploymentWalletResponse::builder).logger(LOG, "exportDeploymentWallet").serviceDetails("GoldenGate", "ExportDeploymentWallet", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ExportDeploymentWallet").method(Method.POST).requestBuilder(ExportDeploymentWalletRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("exportWallet").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ExportDeploymentWalletResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ExportDeploymentWalletResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCertificateResponse> getCertificate(GetCertificateRequest request, AsyncHandler<GetCertificateRequest, GetCertificateResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCertificateKey(), (String)"certificateKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCertificateResponse::builder).logger(LOG, "getCertificate").serviceDetails("GoldenGate", "GetCertificate", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Certificate/GetCertificate").method(Method.GET).requestBuilder(GetCertificateRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").appendPathParam(request.getCertificateKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Certificate.class, GetCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", GetCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("GoldenGate", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectionAssignmentResponse> getConnectionAssignment(GetConnectionAssignmentRequest request, AsyncHandler<GetConnectionAssignmentRequest, GetConnectionAssignmentResponse> handler) {
        Validate.notBlank((String)request.getConnectionAssignmentId(), (String)"connectionAssignmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionAssignmentResponse::builder).logger(LOG, "getConnectionAssignment").serviceDetails("GoldenGate", "GetConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/GetConnectionAssignment").method(Method.GET).requestBuilder(GetConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendPathParam(request.getConnectionAssignmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionAssignment.class, GetConnectionAssignmentResponse.Builder::connectionAssignment).handleResponseHeaderString("etag", GetConnectionAssignmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionAssignmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDatabaseRegistrationResponse> getDatabaseRegistration(GetDatabaseRegistrationRequest request, AsyncHandler<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> handler) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDatabaseRegistrationResponse::builder).logger(LOG, "getDatabaseRegistration").serviceDetails("GoldenGate", "GetDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/GetDatabaseRegistration").method(Method.GET).requestBuilder(GetDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseRegistration.class, GetDatabaseRegistrationResponse.Builder::databaseRegistration).handleResponseHeaderString("etag", GetDatabaseRegistrationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", GetDatabaseRegistrationResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<GetDeploymentResponse> getDeployment(GetDeploymentRequest request, AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeploymentResponse::builder).logger(LOG, "getDeployment").serviceDetails("GoldenGate", "GetDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/GetDeployment").method(Method.GET).requestBuilder(GetDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Deployment.class, GetDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", GetDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDeploymentBackupResponse> getDeploymentBackup(GetDeploymentBackupRequest request, AsyncHandler<GetDeploymentBackupRequest, GetDeploymentBackupResponse> handler) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeploymentBackupResponse::builder).logger(LOG, "getDeploymentBackup").serviceDetails("GoldenGate", "GetDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/GetDeploymentBackup").method(Method.GET).requestBuilder(GetDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentBackup.class, GetDeploymentBackupResponse.Builder::deploymentBackup).handleResponseHeaderString("etag", GetDeploymentBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDeploymentUpgradeResponse> getDeploymentUpgrade(GetDeploymentUpgradeRequest request, AsyncHandler<GetDeploymentUpgradeRequest, GetDeploymentUpgradeResponse> handler) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeploymentUpgradeResponse::builder).logger(LOG, "getDeploymentUpgrade").serviceDetails("GoldenGate", "GetDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/GetDeploymentUpgrade").method(Method.GET).requestBuilder(GetDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentUpgrade.class, GetDeploymentUpgradeResponse.Builder::deploymentUpgrade).handleResponseHeaderString("etag", GetDeploymentUpgradeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentUpgradeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("GoldenGate", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ImportDeploymentWalletResponse> importDeploymentWallet(ImportDeploymentWalletRequest request, AsyncHandler<ImportDeploymentWalletRequest, ImportDeploymentWalletResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportDeploymentWalletDetails(), "importDeploymentWalletDetails is required");
        return this.clientCall(request, ImportDeploymentWalletResponse::builder).logger(LOG, "importDeploymentWallet").serviceDetails("GoldenGate", "ImportDeploymentWallet", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ImportDeploymentWallet").method(Method.POST).requestBuilder(ImportDeploymentWalletRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("importWallet").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ImportDeploymentWalletResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportDeploymentWalletResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListCertificatesResponse::builder).logger(LOG, "listCertificates").serviceDetails("GoldenGate", "ListCertificates", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/CertificateCollection/ListCertificates").method(Method.GET).requestBuilder(ListCertificatesRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateCollection.class, ListCertificatesResponse.Builder::certificateCollection).handleResponseHeaderString("opc-request-id", ListCertificatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCertificatesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListConnectionAssignmentsResponse> listConnectionAssignments(ListConnectionAssignmentsRequest request, AsyncHandler<ListConnectionAssignmentsRequest, ListConnectionAssignmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListConnectionAssignmentsResponse::builder).logger(LOG, "listConnectionAssignments").serviceDetails("GoldenGate", "ListConnectionAssignments", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/ListConnectionAssignments").method(Method.GET).requestBuilder(ListConnectionAssignmentsRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("connectionId", (Object)request.getConnectionId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionAssignmentCollection.class, ListConnectionAssignmentsResponse.Builder::connectionAssignmentCollection).handleResponseHeaderString("opc-request-id", ListConnectionAssignmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionAssignmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("GoldenGate", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20200407").appendPathParam("connections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("technologyType", request.getTechnologyType(), CollectionFormatType.Multi).appendListQueryParam("connectionType", request.getConnectionType(), CollectionFormatType.Multi).appendQueryParam("assignedDeploymentId", (Object)request.getAssignedDeploymentId()).appendQueryParam("assignableDeploymentId", (Object)request.getAssignableDeploymentId()).appendEnumQueryParam("assignableDeploymentType", (BmcEnum)request.getAssignableDeploymentType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionCollection.class, ListConnectionsResponse.Builder::connectionCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDatabaseRegistrationsResponse> listDatabaseRegistrations(ListDatabaseRegistrationsRequest request, AsyncHandler<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDatabaseRegistrationsResponse::builder).logger(LOG, "listDatabaseRegistrations").serviceDetails("GoldenGate", "ListDatabaseRegistrations", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/ListDatabaseRegistrations").method(Method.GET).requestBuilder(ListDatabaseRegistrationsRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseRegistrationCollection.class, ListDatabaseRegistrationsResponse.Builder::databaseRegistrationCollection).handleResponseHeaderString("opc-request-id", ListDatabaseRegistrationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDatabaseRegistrationsResponse.Builder::opcNextPage).handleResponseHeaderString("sunset", ListDatabaseRegistrationsResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<ListDeploymentBackupsResponse> listDeploymentBackups(ListDeploymentBackupsRequest request, AsyncHandler<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDeploymentBackupsResponse::builder).logger(LOG, "listDeploymentBackups").serviceDetails("GoldenGate", "ListDeploymentBackups", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/ListDeploymentBackups").method(Method.GET).requestBuilder(ListDeploymentBackupsRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentBackupCollection.class, ListDeploymentBackupsResponse.Builder::deploymentBackupCollection).handleResponseHeaderString("opc-request-id", ListDeploymentBackupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentBackupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeploymentTypesResponse> listDeploymentTypes(ListDeploymentTypesRequest request, AsyncHandler<ListDeploymentTypesRequest, ListDeploymentTypesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDeploymentTypesResponse::builder).logger(LOG, "listDeploymentTypes").serviceDetails("GoldenGate", "ListDeploymentTypes", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentTypeCollection/ListDeploymentTypes").method(Method.GET).requestBuilder(ListDeploymentTypesRequest::builder).basePath("/20200407").appendPathParam("deploymentTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("deploymentType", (BmcEnum)request.getDeploymentType()).appendQueryParam("oggVersion", (Object)request.getOggVersion()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentTypeCollection.class, ListDeploymentTypesResponse.Builder::deploymentTypeCollection).handleResponseHeaderString("opc-request-id", ListDeploymentTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeploymentUpgradesResponse> listDeploymentUpgrades(ListDeploymentUpgradesRequest request, AsyncHandler<ListDeploymentUpgradesRequest, ListDeploymentUpgradesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDeploymentUpgradesResponse::builder).logger(LOG, "listDeploymentUpgrades").serviceDetails("GoldenGate", "ListDeploymentUpgrades", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/ListDeploymentUpgrades").method(Method.GET).requestBuilder(ListDeploymentUpgradesRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentUpgradeCollection.class, ListDeploymentUpgradesResponse.Builder::deploymentUpgradeCollection).handleResponseHeaderString("opc-request-id", ListDeploymentUpgradesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentUpgradesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeploymentVersionsResponse> listDeploymentVersions(ListDeploymentVersionsRequest request, AsyncHandler<ListDeploymentVersionsRequest, ListDeploymentVersionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDeploymentVersionsResponse::builder).logger(LOG, "listDeploymentVersions").serviceDetails("GoldenGate", "ListDeploymentVersions", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentVersionCollection/ListDeploymentVersions").method(Method.GET).requestBuilder(ListDeploymentVersionsRequest::builder).basePath("/20200407").appendPathParam("deploymentVersions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendEnumQueryParam("deploymentType", (BmcEnum)request.getDeploymentType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentVersionCollection.class, ListDeploymentVersionsResponse.Builder::deploymentVersionCollection).handleResponseHeaderString("opc-request-id", ListDeploymentVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentVersionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeploymentWalletsOperationsResponse> listDeploymentWalletsOperations(ListDeploymentWalletsOperationsRequest request, AsyncHandler<ListDeploymentWalletsOperationsRequest, ListDeploymentWalletsOperationsResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDeploymentWalletsOperationsResponse::builder).logger(LOG, "listDeploymentWalletsOperations").serviceDetails("GoldenGate", "ListDeploymentWalletsOperations", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentWalletsOperationSummary/ListDeploymentWalletsOperations").method(Method.GET).requestBuilder(ListDeploymentWalletsOperationsRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("deploymentWalletsOperations").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentWalletsOperationCollection.class, ListDeploymentWalletsOperationsResponse.Builder::deploymentWalletsOperationCollection).handleResponseHeaderString("opc-request-id", ListDeploymentWalletsOperationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentWalletsOperationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest request, AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDeploymentsResponse::builder).logger(LOG, "listDeployments").serviceDetails("GoldenGate", "ListDeployments", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ListDeployments").method(Method.GET).requestBuilder(ListDeploymentsRequest::builder).basePath("/20200407").appendPathParam("deployments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("supportedConnectionType", (BmcEnum)request.getSupportedConnectionType()).appendQueryParam("assignedConnectionId", (Object)request.getAssignedConnectionId()).appendQueryParam("assignableConnectionId", (Object)request.getAssignableConnectionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lifecycleSubState", (BmcEnum)request.getLifecycleSubState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("fqdn", (Object)request.getFqdn()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentCollection.class, ListDeploymentsResponse.Builder::deploymentCollection).handleResponseHeaderString("opc-request-id", ListDeploymentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMessagesResponse> listMessages(ListMessagesRequest request, AsyncHandler<ListMessagesRequest, ListMessagesResponse> handler) {
        Objects.requireNonNull(request.getDeploymentId(), "deploymentId is required");
        return this.clientCall(request, ListMessagesResponse::builder).logger(LOG, "listMessages").serviceDetails("GoldenGate", "ListMessages", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/MessageSummary/ListMessages").method(Method.GET).requestBuilder(ListMessagesRequest::builder).basePath("/20200407").appendPathParam("messages").appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentMessageCollection.class, ListMessagesResponse.Builder::deploymentMessageCollection).handleResponseHeaderString("opc-request-id", ListMessagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListTrailFilesResponse> listTrailFiles(ListTrailFilesRequest request, AsyncHandler<ListTrailFilesRequest, ListTrailFilesResponse> handler) {
        Objects.requireNonNull(request.getDeploymentId(), "deploymentId is required");
        return this.clientCall(request, ListTrailFilesResponse::builder).logger(LOG, "listTrailFiles").serviceDetails("GoldenGate", "ListTrailFiles", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/TrailFileSummary/ListTrailFiles").method(Method.GET).requestBuilder(ListTrailFilesRequest::builder).basePath("/20200407").appendPathParam("trailFiles").appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("trailFileId", (Object)request.getTrailFileId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TrailFileCollection.class, ListTrailFilesResponse.Builder::trailFileCollection).handleResponseHeaderString("opc-request-id", ListTrailFilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTrailFilesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTrailSequencesResponse> listTrailSequences(ListTrailSequencesRequest request, AsyncHandler<ListTrailSequencesRequest, ListTrailSequencesResponse> handler) {
        Objects.requireNonNull(request.getDeploymentId(), "deploymentId is required");
        Objects.requireNonNull(request.getTrailFileId(), "trailFileId is required");
        return this.clientCall(request, ListTrailSequencesResponse::builder).logger(LOG, "listTrailSequences").serviceDetails("GoldenGate", "ListTrailSequences", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/TrailSequenceSummary/ListTrailSequences").method(Method.GET).requestBuilder(ListTrailSequencesRequest::builder).basePath("/20200407").appendPathParam("trailSequences").appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("trailFileId", (Object)request.getTrailFileId()).appendQueryParam("trailSequenceId", (Object)request.getTrailSequenceId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TrailSequenceCollection.class, ListTrailSequencesResponse.Builder::trailSequenceCollection).handleResponseHeaderString("opc-request-id", ListTrailSequencesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTrailSequencesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("GoldenGate", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("GoldenGate", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("GoldenGate", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RescheduleDeploymentUpgradeResponse> rescheduleDeploymentUpgrade(RescheduleDeploymentUpgradeRequest request, AsyncHandler<RescheduleDeploymentUpgradeRequest, RescheduleDeploymentUpgradeResponse> handler) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRescheduleDeploymentUpgradeDetails(), "rescheduleDeploymentUpgradeDetails is required");
        return this.clientCall(request, RescheduleDeploymentUpgradeResponse::builder).logger(LOG, "rescheduleDeploymentUpgrade").serviceDetails("GoldenGate", "RescheduleDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/RescheduleDeploymentUpgrade").method(Method.POST).requestBuilder(RescheduleDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("reschedule").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DeploymentUpgrade.class, RescheduleDeploymentUpgradeResponse.Builder::deploymentUpgrade).handleResponseHeaderString("etag", RescheduleDeploymentUpgradeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RescheduleDeploymentUpgradeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RestoreDeploymentResponse> restoreDeployment(RestoreDeploymentRequest request, AsyncHandler<RestoreDeploymentRequest, RestoreDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestoreDeploymentDetails(), "restoreDeploymentDetails is required");
        return this.clientCall(request, RestoreDeploymentResponse::builder).logger(LOG, "restoreDeployment").serviceDetails("GoldenGate", "RestoreDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/RestoreDeployment").method(Method.POST).requestBuilder(RestoreDeploymentRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("restore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", RestoreDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RestoreDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RollbackDeploymentUpgradeResponse> rollbackDeploymentUpgrade(RollbackDeploymentUpgradeRequest request, AsyncHandler<RollbackDeploymentUpgradeRequest, RollbackDeploymentUpgradeResponse> handler) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRollbackDeploymentUpgradeDetails(), "rollbackDeploymentUpgradeDetails is required");
        return this.clientCall(request, RollbackDeploymentUpgradeResponse::builder).logger(LOG, "rollbackDeploymentUpgrade").serviceDetails("GoldenGate", "RollbackDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/RollbackDeploymentUpgrade").method(Method.POST).requestBuilder(RollbackDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("rollback").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", RollbackDeploymentUpgradeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RollbackDeploymentUpgradeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SnoozeDeploymentUpgradeResponse> snoozeDeploymentUpgrade(SnoozeDeploymentUpgradeRequest request, AsyncHandler<SnoozeDeploymentUpgradeRequest, SnoozeDeploymentUpgradeResponse> handler) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSnoozeDeploymentUpgradeDetails(), "snoozeDeploymentUpgradeDetails is required");
        return this.clientCall(request, SnoozeDeploymentUpgradeResponse::builder).logger(LOG, "snoozeDeploymentUpgrade").serviceDetails("GoldenGate", "SnoozeDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/SnoozeDeploymentUpgrade").method(Method.POST).requestBuilder(SnoozeDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("snooze").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", SnoozeDeploymentUpgradeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartDeploymentResponse> startDeployment(StartDeploymentRequest request, AsyncHandler<StartDeploymentRequest, StartDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartDeploymentDetails(), "startDeploymentDetails is required");
        return this.clientCall(request, StartDeploymentResponse::builder).logger(LOG, "startDeployment").serviceDetails("GoldenGate", "StartDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/StartDeployment").method(Method.POST).requestBuilder(StartDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", StartDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopDeploymentResponse> stopDeployment(StopDeploymentRequest request, AsyncHandler<StopDeploymentRequest, StopDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStopDeploymentDetails(), "stopDeploymentDetails is required");
        return this.clientCall(request, StopDeploymentResponse::builder).logger(LOG, "stopDeployment").serviceDetails("GoldenGate", "StopDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/StopDeployment").method(Method.POST).requestBuilder(StopDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", StopDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<TestConnectionAssignmentResponse> testConnectionAssignment(TestConnectionAssignmentRequest request, AsyncHandler<TestConnectionAssignmentRequest, TestConnectionAssignmentResponse> handler) {
        Validate.notBlank((String)request.getConnectionAssignmentId(), (String)"connectionAssignmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTestConnectionAssignmentDetails(), "testConnectionAssignmentDetails is required");
        return this.clientCall(request, TestConnectionAssignmentResponse::builder).logger(LOG, "testConnectionAssignment").serviceDetails("GoldenGate", "TestConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/TestConnectionAssignment").method(Method.POST).requestBuilder(TestConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendPathParam(request.getConnectionAssignmentId()).appendPathParam("actions").appendPathParam("test").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TestConnectionAssignmentResult.class, TestConnectionAssignmentResponse.Builder::testConnectionAssignmentResult).handleResponseHeaderString("opc-request-id", TestConnectionAssignmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", TestConnectionAssignmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("GoldenGate", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDatabaseRegistrationResponse> updateDatabaseRegistration(UpdateDatabaseRegistrationRequest request, AsyncHandler<UpdateDatabaseRegistrationRequest, UpdateDatabaseRegistrationResponse> handler) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDatabaseRegistrationDetails(), "updateDatabaseRegistrationDetails is required");
        return this.clientCall(request, UpdateDatabaseRegistrationResponse::builder).logger(LOG, "updateDatabaseRegistration").serviceDetails("GoldenGate", "UpdateDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/UpdateDatabaseRegistration").method(Method.PUT).requestBuilder(UpdateDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDatabaseRegistrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", UpdateDatabaseRegistrationResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest request, AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeploymentDetails(), "updateDeploymentDetails is required");
        return this.clientCall(request, UpdateDeploymentResponse::builder).logger(LOG, "updateDeployment").serviceDetails("GoldenGate", "UpdateDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/UpdateDeployment").method(Method.PUT).requestBuilder(UpdateDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDeploymentBackupResponse> updateDeploymentBackup(UpdateDeploymentBackupRequest request, AsyncHandler<UpdateDeploymentBackupRequest, UpdateDeploymentBackupResponse> handler) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeploymentBackupDetails(), "updateDeploymentBackupDetails is required");
        return this.clientCall(request, UpdateDeploymentBackupResponse::builder).logger(LOG, "updateDeploymentBackup").serviceDetails("GoldenGate", "UpdateDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/UpdateDeploymentBackup").method(Method.PUT).requestBuilder(UpdateDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeploymentBackup.class, UpdateDeploymentBackupResponse.Builder::deploymentBackup).handleResponseHeaderString("etag", UpdateDeploymentBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDeploymentBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpgradeDeploymentResponse> upgradeDeployment(UpgradeDeploymentRequest request, AsyncHandler<UpgradeDeploymentRequest, UpgradeDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpgradeDeploymentDetails(), "upgradeDeploymentDetails is required");
        return this.clientCall(request, UpgradeDeploymentResponse::builder).logger(LOG, "upgradeDeployment").serviceDetails("GoldenGate", "UpgradeDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/UpgradeDeployment").method(Method.POST).requestBuilder(UpgradeDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("upgrade").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpgradeDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpgradeDeploymentUpgradeResponse> upgradeDeploymentUpgrade(UpgradeDeploymentUpgradeRequest request, AsyncHandler<UpgradeDeploymentUpgradeRequest, UpgradeDeploymentUpgradeResponse> handler) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpgradeDeploymentUpgradeDetails(), "upgradeDeploymentUpgradeDetails is required");
        return this.clientCall(request, UpgradeDeploymentUpgradeResponse::builder).logger(LOG, "upgradeDeploymentUpgrade").serviceDetails("GoldenGate", "UpgradeDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/UpgradeDeploymentUpgrade").method(Method.POST).requestBuilder(UpgradeDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("upgrade").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpgradeDeploymentUpgradeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeDeploymentUpgradeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public GoldenGateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GoldenGateAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GoldenGateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GoldenGateAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GoldenGateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GoldenGateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GoldenGateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GoldenGateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GoldenGateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GoldenGateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GoldenGateAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "goldengate";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"goldengate");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public GoldenGateAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GoldenGateAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

