/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.CreateConnectionDetails;
import com.oracle.bmc.goldengate.model.GoogleCloudStorageConnection;
import com.oracle.bmc.goldengate.model.RoutingMethod;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateGoogleCloudStorageConnectionDetails
extends CreateConnectionDetails {
    @JsonProperty(value="technologyType")
    private final GoogleCloudStorageConnection.TechnologyType technologyType;
    @JsonProperty(value="serviceAccountKeyFile")
    private final String serviceAccountKeyFile;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateGoogleCloudStorageConnectionDetails(String displayName, String description, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String vaultId, String keyId, List<String> nsgIds, String subnetId, RoutingMethod routingMethod, GoogleCloudStorageConnection.TechnologyType technologyType, String serviceAccountKeyFile) {
        super(displayName, description, compartmentId, freeformTags, definedTags, vaultId, keyId, nsgIds, subnetId, routingMethod);
        this.technologyType = technologyType;
        this.serviceAccountKeyFile = serviceAccountKeyFile;
    }

    public GoogleCloudStorageConnection.TechnologyType getTechnologyType() {
        return this.technologyType;
    }

    public String getServiceAccountKeyFile() {
        return this.serviceAccountKeyFile;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateGoogleCloudStorageConnectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", technologyType=").append(String.valueOf((Object)this.technologyType));
        sb.append(", serviceAccountKeyFile=").append(String.valueOf(this.serviceAccountKeyFile));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateGoogleCloudStorageConnectionDetails)) {
            return false;
        }
        CreateGoogleCloudStorageConnectionDetails other = (CreateGoogleCloudStorageConnectionDetails)((Object)o);
        return Objects.equals((Object)this.technologyType, (Object)other.technologyType) && Objects.equals(this.serviceAccountKeyFile, other.serviceAccountKeyFile) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.technologyType == null ? 43 : this.technologyType.hashCode());
        result = result * 59 + (this.serviceAccountKeyFile == null ? 43 : this.serviceAccountKeyFile.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="routingMethod")
        private RoutingMethod routingMethod;
        @JsonProperty(value="technologyType")
        private GoogleCloudStorageConnection.TechnologyType technologyType;
        @JsonProperty(value="serviceAccountKeyFile")
        private String serviceAccountKeyFile;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder routingMethod(RoutingMethod routingMethod) {
            this.routingMethod = routingMethod;
            this.__explicitlySet__.add("routingMethod");
            return this;
        }

        public Builder technologyType(GoogleCloudStorageConnection.TechnologyType technologyType) {
            this.technologyType = technologyType;
            this.__explicitlySet__.add("technologyType");
            return this;
        }

        public Builder serviceAccountKeyFile(String serviceAccountKeyFile) {
            this.serviceAccountKeyFile = serviceAccountKeyFile;
            this.__explicitlySet__.add("serviceAccountKeyFile");
            return this;
        }

        public CreateGoogleCloudStorageConnectionDetails build() {
            CreateGoogleCloudStorageConnectionDetails model = new CreateGoogleCloudStorageConnectionDetails(this.displayName, this.description, this.compartmentId, this.freeformTags, this.definedTags, this.vaultId, this.keyId, this.nsgIds, this.subnetId, this.routingMethod, this.technologyType, this.serviceAccountKeyFile);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateGoogleCloudStorageConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("routingMethod")) {
                this.routingMethod(model.getRoutingMethod());
            }
            if (model.wasPropertyExplicitlySet("technologyType")) {
                this.technologyType(model.getTechnologyType());
            }
            if (model.wasPropertyExplicitlySet("serviceAccountKeyFile")) {
                this.serviceAccountKeyFile(model.getServiceAccountKeyFile());
            }
            return this;
        }
    }
}

