/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.ConnectionType;
import com.oracle.bmc.goldengate.model.DeploymentType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeploymentTypeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="category")
    private final Category category;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="connectionTypes")
    private final List<ConnectionType> connectionTypes;
    @JsonProperty(value="sourceTechnologies")
    private final List<String> sourceTechnologies;
    @JsonProperty(value="targetTechnologies")
    private final List<String> targetTechnologies;
    @JsonProperty(value="oggVersion")
    private final String oggVersion;
    @JsonProperty(value="supportedTechnologiesUrl")
    private final String supportedTechnologiesUrl;
    @JsonProperty(value="defaultUsername")
    private final String defaultUsername;

    @Deprecated
    @ConstructorProperties(value={"category", "displayName", "deploymentType", "connectionTypes", "sourceTechnologies", "targetTechnologies", "oggVersion", "supportedTechnologiesUrl", "defaultUsername"})
    public DeploymentTypeSummary(Category category, String displayName, DeploymentType deploymentType, List<ConnectionType> connectionTypes, List<String> sourceTechnologies, List<String> targetTechnologies, String oggVersion, String supportedTechnologiesUrl, String defaultUsername) {
        this.category = category;
        this.displayName = displayName;
        this.deploymentType = deploymentType;
        this.connectionTypes = connectionTypes;
        this.sourceTechnologies = sourceTechnologies;
        this.targetTechnologies = targetTechnologies;
        this.oggVersion = oggVersion;
        this.supportedTechnologiesUrl = supportedTechnologiesUrl;
        this.defaultUsername = defaultUsername;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public List<ConnectionType> getConnectionTypes() {
        return this.connectionTypes;
    }

    public List<String> getSourceTechnologies() {
        return this.sourceTechnologies;
    }

    public List<String> getTargetTechnologies() {
        return this.targetTechnologies;
    }

    public String getOggVersion() {
        return this.oggVersion;
    }

    public String getSupportedTechnologiesUrl() {
        return this.supportedTechnologiesUrl;
    }

    public String getDefaultUsername() {
        return this.defaultUsername;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeploymentTypeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("category=").append(String.valueOf((Object)this.category));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", connectionTypes=").append(String.valueOf(this.connectionTypes));
        sb.append(", sourceTechnologies=").append(String.valueOf(this.sourceTechnologies));
        sb.append(", targetTechnologies=").append(String.valueOf(this.targetTechnologies));
        sb.append(", oggVersion=").append(String.valueOf(this.oggVersion));
        sb.append(", supportedTechnologiesUrl=").append(String.valueOf(this.supportedTechnologiesUrl));
        sb.append(", defaultUsername=").append(String.valueOf(this.defaultUsername));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentTypeSummary)) {
            return false;
        }
        DeploymentTypeSummary other = (DeploymentTypeSummary)((Object)o);
        return Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.connectionTypes, other.connectionTypes) && Objects.equals(this.sourceTechnologies, other.sourceTechnologies) && Objects.equals(this.targetTechnologies, other.targetTechnologies) && Objects.equals(this.oggVersion, other.oggVersion) && Objects.equals(this.supportedTechnologiesUrl, other.supportedTechnologiesUrl) && Objects.equals(this.defaultUsername, other.defaultUsername) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.connectionTypes == null ? 43 : this.connectionTypes.hashCode());
        result = result * 59 + (this.sourceTechnologies == null ? 43 : this.sourceTechnologies.hashCode());
        result = result * 59 + (this.targetTechnologies == null ? 43 : this.targetTechnologies.hashCode());
        result = result * 59 + (this.oggVersion == null ? 43 : this.oggVersion.hashCode());
        result = result * 59 + (this.supportedTechnologiesUrl == null ? 43 : this.supportedTechnologiesUrl.hashCode());
        result = result * 59 + (this.defaultUsername == null ? 43 : this.defaultUsername.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Category implements BmcEnum
    {
        DataReplication("DATA_REPLICATION"),
        StreamAnalytics("STREAM_ANALYTICS"),
        DataTransforms("DATA_TRANSFORMS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Category', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Category.class);
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="connectionTypes")
        private List<ConnectionType> connectionTypes;
        @JsonProperty(value="sourceTechnologies")
        private List<String> sourceTechnologies;
        @JsonProperty(value="targetTechnologies")
        private List<String> targetTechnologies;
        @JsonProperty(value="oggVersion")
        private String oggVersion;
        @JsonProperty(value="supportedTechnologiesUrl")
        private String supportedTechnologiesUrl;
        @JsonProperty(value="defaultUsername")
        private String defaultUsername;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder connectionTypes(List<ConnectionType> connectionTypes) {
            this.connectionTypes = connectionTypes;
            this.__explicitlySet__.add("connectionTypes");
            return this;
        }

        public Builder sourceTechnologies(List<String> sourceTechnologies) {
            this.sourceTechnologies = sourceTechnologies;
            this.__explicitlySet__.add("sourceTechnologies");
            return this;
        }

        public Builder targetTechnologies(List<String> targetTechnologies) {
            this.targetTechnologies = targetTechnologies;
            this.__explicitlySet__.add("targetTechnologies");
            return this;
        }

        public Builder oggVersion(String oggVersion) {
            this.oggVersion = oggVersion;
            this.__explicitlySet__.add("oggVersion");
            return this;
        }

        public Builder supportedTechnologiesUrl(String supportedTechnologiesUrl) {
            this.supportedTechnologiesUrl = supportedTechnologiesUrl;
            this.__explicitlySet__.add("supportedTechnologiesUrl");
            return this;
        }

        public Builder defaultUsername(String defaultUsername) {
            this.defaultUsername = defaultUsername;
            this.__explicitlySet__.add("defaultUsername");
            return this;
        }

        public DeploymentTypeSummary build() {
            DeploymentTypeSummary model = new DeploymentTypeSummary(this.category, this.displayName, this.deploymentType, this.connectionTypes, this.sourceTechnologies, this.targetTechnologies, this.oggVersion, this.supportedTechnologiesUrl, this.defaultUsername);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeploymentTypeSummary model) {
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("connectionTypes")) {
                this.connectionTypes(model.getConnectionTypes());
            }
            if (model.wasPropertyExplicitlySet("sourceTechnologies")) {
                this.sourceTechnologies(model.getSourceTechnologies());
            }
            if (model.wasPropertyExplicitlySet("targetTechnologies")) {
                this.targetTechnologies(model.getTargetTechnologies());
            }
            if (model.wasPropertyExplicitlySet("oggVersion")) {
                this.oggVersion(model.getOggVersion());
            }
            if (model.wasPropertyExplicitlySet("supportedTechnologiesUrl")) {
                this.supportedTechnologiesUrl(model.getSupportedTechnologiesUrl());
            }
            if (model.wasPropertyExplicitlySet("defaultUsername")) {
                this.defaultUsername(model.getDefaultUsername());
            }
            return this;
        }
    }
}

