/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDatabaseRegistrationRequest
extends BmcRequest<Void> {
    private String databaseRegistrationId;
    private String opcRequestId;

    public String getDatabaseRegistrationId() {
        return this.databaseRegistrationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().databaseRegistrationId(this.databaseRegistrationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseRegistrationId=").append(String.valueOf(this.databaseRegistrationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseRegistrationRequest)) {
            return false;
        }
        GetDatabaseRegistrationRequest other = (GetDatabaseRegistrationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseRegistrationId, other.databaseRegistrationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseRegistrationId == null ? 43 : this.databaseRegistrationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseRegistrationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseRegistrationId = null;
        private String opcRequestId = null;

        public Builder databaseRegistrationId(String databaseRegistrationId) {
            this.databaseRegistrationId = databaseRegistrationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseRegistrationRequest o) {
            this.databaseRegistrationId(o.getDatabaseRegistrationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseRegistrationRequest build() {
            GetDatabaseRegistrationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseRegistrationRequest buildWithoutInvocationCallback() {
            GetDatabaseRegistrationRequest request = new GetDatabaseRegistrationRequest();
            request.databaseRegistrationId = this.databaseRegistrationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

