/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.goldengate.model.Connection;
import com.oracle.bmc.goldengate.model.ConnectionType;
import com.oracle.bmc.goldengate.model.DeploymentType;
import com.oracle.bmc.goldengate.model.SortOrder;
import com.oracle.bmc.goldengate.model.TechnologyType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListConnectionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<TechnologyType> technologyType;
    private List<ConnectionType> connectionType;
    private String assignedDeploymentId;
    private String assignableDeploymentId;
    private DeploymentType assignableDeploymentType;
    private Connection.LifecycleState lifecycleState;
    private String displayName;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<TechnologyType> getTechnologyType() {
        return this.technologyType;
    }

    public List<ConnectionType> getConnectionType() {
        return this.connectionType;
    }

    public String getAssignedDeploymentId() {
        return this.assignedDeploymentId;
    }

    public String getAssignableDeploymentId() {
        return this.assignableDeploymentId;
    }

    public DeploymentType getAssignableDeploymentType() {
        return this.assignableDeploymentType;
    }

    public Connection.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).technologyType(this.technologyType).connectionType(this.connectionType).assignedDeploymentId(this.assignedDeploymentId).assignableDeploymentId(this.assignableDeploymentId).assignableDeploymentType(this.assignableDeploymentType).lifecycleState(this.lifecycleState).displayName(this.displayName).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",technologyType=").append(String.valueOf(this.technologyType));
        sb.append(",connectionType=").append(String.valueOf(this.connectionType));
        sb.append(",assignedDeploymentId=").append(String.valueOf(this.assignedDeploymentId));
        sb.append(",assignableDeploymentId=").append(String.valueOf(this.assignableDeploymentId));
        sb.append(",assignableDeploymentType=").append(String.valueOf((Object)this.assignableDeploymentType));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListConnectionsRequest)) {
            return false;
        }
        ListConnectionsRequest other = (ListConnectionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.technologyType, other.technologyType) && Objects.equals(this.connectionType, other.connectionType) && Objects.equals(this.assignedDeploymentId, other.assignedDeploymentId) && Objects.equals(this.assignableDeploymentId, other.assignableDeploymentId) && Objects.equals((Object)this.assignableDeploymentType, (Object)other.assignableDeploymentType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.technologyType == null ? 43 : this.technologyType.hashCode());
        result = result * 59 + (this.connectionType == null ? 43 : this.connectionType.hashCode());
        result = result * 59 + (this.assignedDeploymentId == null ? 43 : this.assignedDeploymentId.hashCode());
        result = result * 59 + (this.assignableDeploymentId == null ? 43 : this.assignableDeploymentId.hashCode());
        result = result * 59 + (this.assignableDeploymentType == null ? 43 : this.assignableDeploymentType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListConnectionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<TechnologyType> technologyType = null;
        private List<ConnectionType> connectionType = null;
        private String assignedDeploymentId = null;
        private String assignableDeploymentId = null;
        private DeploymentType assignableDeploymentType = null;
        private Connection.LifecycleState lifecycleState = null;
        private String displayName = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder technologyType(List<TechnologyType> technologyType) {
            this.technologyType = technologyType;
            return this;
        }

        public Builder technologyType(TechnologyType singularValue) {
            return this.technologyType(Arrays.asList(singularValue));
        }

        public Builder connectionType(List<ConnectionType> connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder connectionType(ConnectionType singularValue) {
            return this.connectionType(Arrays.asList(singularValue));
        }

        public Builder assignedDeploymentId(String assignedDeploymentId) {
            this.assignedDeploymentId = assignedDeploymentId;
            return this;
        }

        public Builder assignableDeploymentId(String assignableDeploymentId) {
            this.assignableDeploymentId = assignableDeploymentId;
            return this;
        }

        public Builder assignableDeploymentType(DeploymentType assignableDeploymentType) {
            this.assignableDeploymentType = assignableDeploymentType;
            return this;
        }

        public Builder lifecycleState(Connection.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListConnectionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.technologyType(o.getTechnologyType());
            this.connectionType(o.getConnectionType());
            this.assignedDeploymentId(o.getAssignedDeploymentId());
            this.assignableDeploymentId(o.getAssignableDeploymentId());
            this.assignableDeploymentType(o.getAssignableDeploymentType());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListConnectionsRequest build() {
            ListConnectionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListConnectionsRequest buildWithoutInvocationCallback() {
            ListConnectionsRequest request = new ListConnectionsRequest();
            request.compartmentId = this.compartmentId;
            request.technologyType = this.technologyType;
            request.connectionType = this.connectionType;
            request.assignedDeploymentId = this.assignedDeploymentId;
            request.assignableDeploymentId = this.assignableDeploymentId;
            request.assignableDeploymentType = this.assignableDeploymentType;
            request.lifecycleState = this.lifecycleState;
            request.displayName = this.displayName;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

