/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.goldengate.model.RestoreDeploymentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RestoreDeploymentRequest
extends BmcRequest<RestoreDeploymentDetails> {
    private String deploymentBackupId;
    private RestoreDeploymentDetails restoreDeploymentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDeploymentBackupId() {
        return this.deploymentBackupId;
    }

    public RestoreDeploymentDetails getRestoreDeploymentDetails() {
        return this.restoreDeploymentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public RestoreDeploymentDetails getBody$() {
        return this.restoreDeploymentDetails;
    }

    public Builder toBuilder() {
        return new Builder().deploymentBackupId(this.deploymentBackupId).restoreDeploymentDetails(this.restoreDeploymentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentBackupId=").append(String.valueOf(this.deploymentBackupId));
        sb.append(",restoreDeploymentDetails=").append(String.valueOf((Object)this.restoreDeploymentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestoreDeploymentRequest)) {
            return false;
        }
        RestoreDeploymentRequest other = (RestoreDeploymentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentBackupId, other.deploymentBackupId) && Objects.equals((Object)this.restoreDeploymentDetails, (Object)other.restoreDeploymentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentBackupId == null ? 43 : this.deploymentBackupId.hashCode());
        result = result * 59 + (this.restoreDeploymentDetails == null ? 43 : this.restoreDeploymentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreDeploymentRequest, RestoreDeploymentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentBackupId = null;
        private RestoreDeploymentDetails restoreDeploymentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder deploymentBackupId(String deploymentBackupId) {
            this.deploymentBackupId = deploymentBackupId;
            return this;
        }

        public Builder restoreDeploymentDetails(RestoreDeploymentDetails restoreDeploymentDetails) {
            this.restoreDeploymentDetails = restoreDeploymentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreDeploymentRequest o) {
            this.deploymentBackupId(o.getDeploymentBackupId());
            this.restoreDeploymentDetails(o.getRestoreDeploymentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreDeploymentRequest build() {
            RestoreDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RestoreDeploymentDetails body) {
            this.restoreDeploymentDetails(body);
            return this;
        }

        public RestoreDeploymentRequest buildWithoutInvocationCallback() {
            RestoreDeploymentRequest request = new RestoreDeploymentRequest();
            request.deploymentBackupId = this.deploymentBackupId;
            request.restoreDeploymentDetails = this.restoreDeploymentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

