/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.oracle.bmc.goldengate.GoldenGate;
import com.oracle.bmc.goldengate.model.CertificateSummary;
import com.oracle.bmc.goldengate.model.ConnectionAssignmentSummary;
import com.oracle.bmc.goldengate.model.ConnectionSummary;
import com.oracle.bmc.goldengate.model.DatabaseRegistrationSummary;
import com.oracle.bmc.goldengate.model.DeploymentBackupSummary;
import com.oracle.bmc.goldengate.model.DeploymentSummary;
import com.oracle.bmc.goldengate.model.DeploymentTypeSummary;
import com.oracle.bmc.goldengate.model.DeploymentUpgradeSummary;
import com.oracle.bmc.goldengate.model.DeploymentVersionSummary;
import com.oracle.bmc.goldengate.model.DeploymentWalletsOperationSummary;
import com.oracle.bmc.goldengate.model.TrailFileSummary;
import com.oracle.bmc.goldengate.model.TrailSequenceSummary;
import com.oracle.bmc.goldengate.model.WorkRequest;
import com.oracle.bmc.goldengate.model.WorkRequestError;
import com.oracle.bmc.goldengate.model.WorkRequestLogEntry;
import com.oracle.bmc.goldengate.requests.ListCertificatesRequest;
import com.oracle.bmc.goldengate.requests.ListConnectionAssignmentsRequest;
import com.oracle.bmc.goldengate.requests.ListConnectionsRequest;
import com.oracle.bmc.goldengate.requests.ListDatabaseRegistrationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentBackupsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentTypesRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentUpgradesRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentVersionsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentWalletsOperationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentsRequest;
import com.oracle.bmc.goldengate.requests.ListTrailFilesRequest;
import com.oracle.bmc.goldengate.requests.ListTrailSequencesRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.goldengate.responses.ListCertificatesResponse;
import com.oracle.bmc.goldengate.responses.ListConnectionAssignmentsResponse;
import com.oracle.bmc.goldengate.responses.ListConnectionsResponse;
import com.oracle.bmc.goldengate.responses.ListDatabaseRegistrationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentBackupsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentTypesResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentUpgradesResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentVersionsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentWalletsOperationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentsResponse;
import com.oracle.bmc.goldengate.responses.ListTrailFilesResponse;
import com.oracle.bmc.goldengate.responses.ListTrailSequencesResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class GoldenGatePaginators {
    private final GoldenGate client;

    public GoldenGatePaginators(GoldenGate client) {
        this.client = client;
    }

    public Iterable<ListCertificatesResponse> listCertificatesResponseIterator(final ListCertificatesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            @Override
            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            @Override
            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            @Override
            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            @Override
            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return GoldenGatePaginators.this.client.listCertificates(request);
            }
        });
    }

    public Iterable<CertificateSummary> listCertificatesRecordIterator(final ListCertificatesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            @Override
            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            @Override
            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            @Override
            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            @Override
            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return GoldenGatePaginators.this.client.listCertificates(request);
            }
        }, (Function)new Function<ListCertificatesResponse, List<CertificateSummary>>(){

            @Override
            public List<CertificateSummary> apply(ListCertificatesResponse response) {
                return response.getCertificateCollection().getItems();
            }
        });
    }

    public Iterable<ListConnectionAssignmentsResponse> listConnectionAssignmentsResponseIterator(final ListConnectionAssignmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectionAssignmentsRequest.Builder>(){

            @Override
            public ListConnectionAssignmentsRequest.Builder get() {
                return ListConnectionAssignmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionAssignmentsResponse, String>(){

            @Override
            public String apply(ListConnectionAssignmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionAssignmentsRequest.Builder>, ListConnectionAssignmentsRequest>(){

            @Override
            public ListConnectionAssignmentsRequest apply(RequestBuilderAndToken<ListConnectionAssignmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionAssignmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionAssignmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionAssignmentsRequest, ListConnectionAssignmentsResponse>(){

            @Override
            public ListConnectionAssignmentsResponse apply(ListConnectionAssignmentsRequest request) {
                return GoldenGatePaginators.this.client.listConnectionAssignments(request);
            }
        });
    }

    public Iterable<ConnectionAssignmentSummary> listConnectionAssignmentsRecordIterator(final ListConnectionAssignmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectionAssignmentsRequest.Builder>(){

            @Override
            public ListConnectionAssignmentsRequest.Builder get() {
                return ListConnectionAssignmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionAssignmentsResponse, String>(){

            @Override
            public String apply(ListConnectionAssignmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionAssignmentsRequest.Builder>, ListConnectionAssignmentsRequest>(){

            @Override
            public ListConnectionAssignmentsRequest apply(RequestBuilderAndToken<ListConnectionAssignmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionAssignmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionAssignmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionAssignmentsRequest, ListConnectionAssignmentsResponse>(){

            @Override
            public ListConnectionAssignmentsResponse apply(ListConnectionAssignmentsRequest request) {
                return GoldenGatePaginators.this.client.listConnectionAssignments(request);
            }
        }, (Function)new Function<ListConnectionAssignmentsResponse, List<ConnectionAssignmentSummary>>(){

            @Override
            public List<ConnectionAssignmentSummary> apply(ListConnectionAssignmentsResponse response) {
                return response.getConnectionAssignmentCollection().getItems();
            }
        });
    }

    public Iterable<ListConnectionsResponse> listConnectionsResponseIterator(final ListConnectionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return GoldenGatePaginators.this.client.listConnections(request);
            }
        });
    }

    public Iterable<ConnectionSummary> listConnectionsRecordIterator(final ListConnectionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return GoldenGatePaginators.this.client.listConnections(request);
            }
        }, (Function)new Function<ListConnectionsResponse, List<ConnectionSummary>>(){

            @Override
            public List<ConnectionSummary> apply(ListConnectionsResponse response) {
                return response.getConnectionCollection().getItems();
            }
        });
    }

    public Iterable<ListDatabaseRegistrationsResponse> listDatabaseRegistrationsResponseIterator(final ListDatabaseRegistrationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatabaseRegistrationsRequest.Builder>(){

            @Override
            public ListDatabaseRegistrationsRequest.Builder get() {
                return ListDatabaseRegistrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseRegistrationsResponse, String>(){

            @Override
            public String apply(ListDatabaseRegistrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder>, ListDatabaseRegistrationsRequest>(){

            @Override
            public ListDatabaseRegistrationsRequest apply(RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse>(){

            @Override
            public ListDatabaseRegistrationsResponse apply(ListDatabaseRegistrationsRequest request) {
                return GoldenGatePaginators.this.client.listDatabaseRegistrations(request);
            }
        });
    }

    public Iterable<DatabaseRegistrationSummary> listDatabaseRegistrationsRecordIterator(final ListDatabaseRegistrationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatabaseRegistrationsRequest.Builder>(){

            @Override
            public ListDatabaseRegistrationsRequest.Builder get() {
                return ListDatabaseRegistrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseRegistrationsResponse, String>(){

            @Override
            public String apply(ListDatabaseRegistrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder>, ListDatabaseRegistrationsRequest>(){

            @Override
            public ListDatabaseRegistrationsRequest apply(RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse>(){

            @Override
            public ListDatabaseRegistrationsResponse apply(ListDatabaseRegistrationsRequest request) {
                return GoldenGatePaginators.this.client.listDatabaseRegistrations(request);
            }
        }, (Function)new Function<ListDatabaseRegistrationsResponse, List<DatabaseRegistrationSummary>>(){

            @Override
            public List<DatabaseRegistrationSummary> apply(ListDatabaseRegistrationsResponse response) {
                return response.getDatabaseRegistrationCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentBackupsResponse> listDeploymentBackupsResponseIterator(final ListDeploymentBackupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentBackupsRequest.Builder>(){

            @Override
            public ListDeploymentBackupsRequest.Builder get() {
                return ListDeploymentBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentBackupsResponse, String>(){

            @Override
            public String apply(ListDeploymentBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder>, ListDeploymentBackupsRequest>(){

            @Override
            public ListDeploymentBackupsRequest apply(RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse>(){

            @Override
            public ListDeploymentBackupsResponse apply(ListDeploymentBackupsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentBackups(request);
            }
        });
    }

    public Iterable<DeploymentBackupSummary> listDeploymentBackupsRecordIterator(final ListDeploymentBackupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentBackupsRequest.Builder>(){

            @Override
            public ListDeploymentBackupsRequest.Builder get() {
                return ListDeploymentBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentBackupsResponse, String>(){

            @Override
            public String apply(ListDeploymentBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder>, ListDeploymentBackupsRequest>(){

            @Override
            public ListDeploymentBackupsRequest apply(RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse>(){

            @Override
            public ListDeploymentBackupsResponse apply(ListDeploymentBackupsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentBackups(request);
            }
        }, (Function)new Function<ListDeploymentBackupsResponse, List<DeploymentBackupSummary>>(){

            @Override
            public List<DeploymentBackupSummary> apply(ListDeploymentBackupsResponse response) {
                return response.getDeploymentBackupCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentTypesResponse> listDeploymentTypesResponseIterator(final ListDeploymentTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentTypesRequest.Builder>(){

            @Override
            public ListDeploymentTypesRequest.Builder get() {
                return ListDeploymentTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentTypesResponse, String>(){

            @Override
            public String apply(ListDeploymentTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentTypesRequest.Builder>, ListDeploymentTypesRequest>(){

            @Override
            public ListDeploymentTypesRequest apply(RequestBuilderAndToken<ListDeploymentTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentTypesRequest, ListDeploymentTypesResponse>(){

            @Override
            public ListDeploymentTypesResponse apply(ListDeploymentTypesRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentTypes(request);
            }
        });
    }

    public Iterable<DeploymentTypeSummary> listDeploymentTypesRecordIterator(final ListDeploymentTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentTypesRequest.Builder>(){

            @Override
            public ListDeploymentTypesRequest.Builder get() {
                return ListDeploymentTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentTypesResponse, String>(){

            @Override
            public String apply(ListDeploymentTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentTypesRequest.Builder>, ListDeploymentTypesRequest>(){

            @Override
            public ListDeploymentTypesRequest apply(RequestBuilderAndToken<ListDeploymentTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentTypesRequest, ListDeploymentTypesResponse>(){

            @Override
            public ListDeploymentTypesResponse apply(ListDeploymentTypesRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentTypes(request);
            }
        }, (Function)new Function<ListDeploymentTypesResponse, List<DeploymentTypeSummary>>(){

            @Override
            public List<DeploymentTypeSummary> apply(ListDeploymentTypesResponse response) {
                return response.getDeploymentTypeCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentUpgradesResponse> listDeploymentUpgradesResponseIterator(final ListDeploymentUpgradesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentUpgradesRequest.Builder>(){

            @Override
            public ListDeploymentUpgradesRequest.Builder get() {
                return ListDeploymentUpgradesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentUpgradesResponse, String>(){

            @Override
            public String apply(ListDeploymentUpgradesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentUpgradesRequest.Builder>, ListDeploymentUpgradesRequest>(){

            @Override
            public ListDeploymentUpgradesRequest apply(RequestBuilderAndToken<ListDeploymentUpgradesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentUpgradesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentUpgradesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentUpgradesRequest, ListDeploymentUpgradesResponse>(){

            @Override
            public ListDeploymentUpgradesResponse apply(ListDeploymentUpgradesRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentUpgrades(request);
            }
        });
    }

    public Iterable<DeploymentUpgradeSummary> listDeploymentUpgradesRecordIterator(final ListDeploymentUpgradesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentUpgradesRequest.Builder>(){

            @Override
            public ListDeploymentUpgradesRequest.Builder get() {
                return ListDeploymentUpgradesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentUpgradesResponse, String>(){

            @Override
            public String apply(ListDeploymentUpgradesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentUpgradesRequest.Builder>, ListDeploymentUpgradesRequest>(){

            @Override
            public ListDeploymentUpgradesRequest apply(RequestBuilderAndToken<ListDeploymentUpgradesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentUpgradesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentUpgradesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentUpgradesRequest, ListDeploymentUpgradesResponse>(){

            @Override
            public ListDeploymentUpgradesResponse apply(ListDeploymentUpgradesRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentUpgrades(request);
            }
        }, (Function)new Function<ListDeploymentUpgradesResponse, List<DeploymentUpgradeSummary>>(){

            @Override
            public List<DeploymentUpgradeSummary> apply(ListDeploymentUpgradesResponse response) {
                return response.getDeploymentUpgradeCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentVersionsResponse> listDeploymentVersionsResponseIterator(final ListDeploymentVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentVersionsRequest.Builder>(){

            @Override
            public ListDeploymentVersionsRequest.Builder get() {
                return ListDeploymentVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentVersionsResponse, String>(){

            @Override
            public String apply(ListDeploymentVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentVersionsRequest.Builder>, ListDeploymentVersionsRequest>(){

            @Override
            public ListDeploymentVersionsRequest apply(RequestBuilderAndToken<ListDeploymentVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentVersionsRequest, ListDeploymentVersionsResponse>(){

            @Override
            public ListDeploymentVersionsResponse apply(ListDeploymentVersionsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentVersions(request);
            }
        });
    }

    public Iterable<DeploymentVersionSummary> listDeploymentVersionsRecordIterator(final ListDeploymentVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentVersionsRequest.Builder>(){

            @Override
            public ListDeploymentVersionsRequest.Builder get() {
                return ListDeploymentVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentVersionsResponse, String>(){

            @Override
            public String apply(ListDeploymentVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentVersionsRequest.Builder>, ListDeploymentVersionsRequest>(){

            @Override
            public ListDeploymentVersionsRequest apply(RequestBuilderAndToken<ListDeploymentVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentVersionsRequest, ListDeploymentVersionsResponse>(){

            @Override
            public ListDeploymentVersionsResponse apply(ListDeploymentVersionsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentVersions(request);
            }
        }, (Function)new Function<ListDeploymentVersionsResponse, List<DeploymentVersionSummary>>(){

            @Override
            public List<DeploymentVersionSummary> apply(ListDeploymentVersionsResponse response) {
                return response.getDeploymentVersionCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentWalletsOperationsResponse> listDeploymentWalletsOperationsResponseIterator(final ListDeploymentWalletsOperationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentWalletsOperationsRequest.Builder>(){

            @Override
            public ListDeploymentWalletsOperationsRequest.Builder get() {
                return ListDeploymentWalletsOperationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentWalletsOperationsResponse, String>(){

            @Override
            public String apply(ListDeploymentWalletsOperationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentWalletsOperationsRequest.Builder>, ListDeploymentWalletsOperationsRequest>(){

            @Override
            public ListDeploymentWalletsOperationsRequest apply(RequestBuilderAndToken<ListDeploymentWalletsOperationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentWalletsOperationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentWalletsOperationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentWalletsOperationsRequest, ListDeploymentWalletsOperationsResponse>(){

            @Override
            public ListDeploymentWalletsOperationsResponse apply(ListDeploymentWalletsOperationsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentWalletsOperations(request);
            }
        });
    }

    public Iterable<DeploymentWalletsOperationSummary> listDeploymentWalletsOperationsRecordIterator(final ListDeploymentWalletsOperationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentWalletsOperationsRequest.Builder>(){

            @Override
            public ListDeploymentWalletsOperationsRequest.Builder get() {
                return ListDeploymentWalletsOperationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentWalletsOperationsResponse, String>(){

            @Override
            public String apply(ListDeploymentWalletsOperationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentWalletsOperationsRequest.Builder>, ListDeploymentWalletsOperationsRequest>(){

            @Override
            public ListDeploymentWalletsOperationsRequest apply(RequestBuilderAndToken<ListDeploymentWalletsOperationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentWalletsOperationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentWalletsOperationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentWalletsOperationsRequest, ListDeploymentWalletsOperationsResponse>(){

            @Override
            public ListDeploymentWalletsOperationsResponse apply(ListDeploymentWalletsOperationsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentWalletsOperations(request);
            }
        }, (Function)new Function<ListDeploymentWalletsOperationsResponse, List<DeploymentWalletsOperationSummary>>(){

            @Override
            public List<DeploymentWalletsOperationSummary> apply(ListDeploymentWalletsOperationsResponse response) {
                return response.getDeploymentWalletsOperationCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentsResponse> listDeploymentsResponseIterator(final ListDeploymentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            @Override
            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            @Override
            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            @Override
            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            @Override
            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return GoldenGatePaginators.this.client.listDeployments(request);
            }
        });
    }

    public Iterable<DeploymentSummary> listDeploymentsRecordIterator(final ListDeploymentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            @Override
            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            @Override
            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            @Override
            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            @Override
            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return GoldenGatePaginators.this.client.listDeployments(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, List<DeploymentSummary>>(){

            @Override
            public List<DeploymentSummary> apply(ListDeploymentsResponse response) {
                return response.getDeploymentCollection().getItems();
            }
        });
    }

    public Iterable<ListTrailFilesResponse> listTrailFilesResponseIterator(final ListTrailFilesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTrailFilesRequest.Builder>(){

            @Override
            public ListTrailFilesRequest.Builder get() {
                return ListTrailFilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTrailFilesResponse, String>(){

            @Override
            public String apply(ListTrailFilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTrailFilesRequest.Builder>, ListTrailFilesRequest>(){

            @Override
            public ListTrailFilesRequest apply(RequestBuilderAndToken<ListTrailFilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTrailFilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTrailFilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTrailFilesRequest, ListTrailFilesResponse>(){

            @Override
            public ListTrailFilesResponse apply(ListTrailFilesRequest request) {
                return GoldenGatePaginators.this.client.listTrailFiles(request);
            }
        });
    }

    public Iterable<TrailFileSummary> listTrailFilesRecordIterator(final ListTrailFilesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTrailFilesRequest.Builder>(){

            @Override
            public ListTrailFilesRequest.Builder get() {
                return ListTrailFilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTrailFilesResponse, String>(){

            @Override
            public String apply(ListTrailFilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTrailFilesRequest.Builder>, ListTrailFilesRequest>(){

            @Override
            public ListTrailFilesRequest apply(RequestBuilderAndToken<ListTrailFilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTrailFilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTrailFilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTrailFilesRequest, ListTrailFilesResponse>(){

            @Override
            public ListTrailFilesResponse apply(ListTrailFilesRequest request) {
                return GoldenGatePaginators.this.client.listTrailFiles(request);
            }
        }, (Function)new Function<ListTrailFilesResponse, List<TrailFileSummary>>(){

            @Override
            public List<TrailFileSummary> apply(ListTrailFilesResponse response) {
                return response.getTrailFileCollection().getItems();
            }
        });
    }

    public Iterable<ListTrailSequencesResponse> listTrailSequencesResponseIterator(final ListTrailSequencesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTrailSequencesRequest.Builder>(){

            @Override
            public ListTrailSequencesRequest.Builder get() {
                return ListTrailSequencesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTrailSequencesResponse, String>(){

            @Override
            public String apply(ListTrailSequencesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTrailSequencesRequest.Builder>, ListTrailSequencesRequest>(){

            @Override
            public ListTrailSequencesRequest apply(RequestBuilderAndToken<ListTrailSequencesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTrailSequencesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTrailSequencesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTrailSequencesRequest, ListTrailSequencesResponse>(){

            @Override
            public ListTrailSequencesResponse apply(ListTrailSequencesRequest request) {
                return GoldenGatePaginators.this.client.listTrailSequences(request);
            }
        });
    }

    public Iterable<TrailSequenceSummary> listTrailSequencesRecordIterator(final ListTrailSequencesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTrailSequencesRequest.Builder>(){

            @Override
            public ListTrailSequencesRequest.Builder get() {
                return ListTrailSequencesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTrailSequencesResponse, String>(){

            @Override
            public String apply(ListTrailSequencesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTrailSequencesRequest.Builder>, ListTrailSequencesRequest>(){

            @Override
            public ListTrailSequencesRequest apply(RequestBuilderAndToken<ListTrailSequencesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTrailSequencesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTrailSequencesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTrailSequencesRequest, ListTrailSequencesResponse>(){

            @Override
            public ListTrailSequencesResponse apply(ListTrailSequencesRequest request) {
                return GoldenGatePaginators.this.client.listTrailSequences(request);
            }
        }, (Function)new Function<ListTrailSequencesResponse, List<TrailSequenceSummary>>(){

            @Override
            public List<TrailSequenceSummary> apply(ListTrailSequencesResponse response) {
                return response.getTrailSequenceCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            @Override
            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

