/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.oracle.bmc.goldengate.GoldenGate;
import com.oracle.bmc.goldengate.model.CertificateLifecycleState;
import com.oracle.bmc.goldengate.model.Connection;
import com.oracle.bmc.goldengate.model.ConnectionAssignment;
import com.oracle.bmc.goldengate.model.LifecycleState;
import com.oracle.bmc.goldengate.requests.GetCertificateRequest;
import com.oracle.bmc.goldengate.requests.GetConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.GetConnectionRequest;
import com.oracle.bmc.goldengate.requests.GetDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.GetWorkRequestRequest;
import com.oracle.bmc.goldengate.responses.GetCertificateResponse;
import com.oracle.bmc.goldengate.responses.GetConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.GetConnectionResponse;
import com.oracle.bmc.goldengate.responses.GetDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class GoldenGateWaiters {
    private final ExecutorService executorService;
    private final GoldenGate client;

    public GoldenGateWaiters(ExecutorService executorService, GoldenGate client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, CertificateLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, CertificateLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CertificateLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(BmcGenericWaiter waiter, GetCertificateRequest request, CertificateLifecycleState ... targetStates) {
        final HashSet<CertificateLifecycleState> targetStatesSet = new HashSet<CertificateLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCertificateRequest, GetCertificateResponse>(){

            @Override
            public GetCertificateResponse apply(GetCertificateRequest request) {
                return GoldenGateWaiters.this.client.getCertificate(request);
            }
        }, (Predicate)new Predicate<GetCertificateResponse>(){

            @Override
            public boolean test(GetCertificateResponse response) {
                return targetStatesSet.contains((Object)response.getCertificate().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CertificateLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, Connection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, Connection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Connection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(BmcGenericWaiter waiter, GetConnectionRequest request, Connection.LifecycleState ... targetStates) {
        final HashSet<Connection.LifecycleState> targetStatesSet = new HashSet<Connection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConnectionRequest, GetConnectionResponse>(){

            @Override
            public GetConnectionResponse apply(GetConnectionRequest request) {
                return GoldenGateWaiters.this.client.getConnection(request);
            }
        }, (Predicate)new Predicate<GetConnectionResponse>(){

            @Override
            public boolean test(GetConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Connection.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetConnectionAssignmentRequest, GetConnectionAssignmentResponse> forConnectionAssignment(GetConnectionAssignmentRequest request, ConnectionAssignment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnectionAssignment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConnectionAssignmentRequest, GetConnectionAssignmentResponse> forConnectionAssignment(GetConnectionAssignmentRequest request, ConnectionAssignment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConnectionAssignment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConnectionAssignmentRequest, GetConnectionAssignmentResponse> forConnectionAssignment(GetConnectionAssignmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ConnectionAssignment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConnectionAssignment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConnectionAssignmentRequest, GetConnectionAssignmentResponse> forConnectionAssignment(BmcGenericWaiter waiter, GetConnectionAssignmentRequest request, ConnectionAssignment.LifecycleState ... targetStates) {
        final HashSet<ConnectionAssignment.LifecycleState> targetStatesSet = new HashSet<ConnectionAssignment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConnectionAssignmentRequest, GetConnectionAssignmentResponse>(){

            @Override
            public GetConnectionAssignmentResponse apply(GetConnectionAssignmentRequest request) {
                return GoldenGateWaiters.this.client.getConnectionAssignment(request);
            }
        }, (Predicate)new Predicate<GetConnectionAssignmentResponse>(){

            @Override
            public boolean test(GetConnectionAssignmentResponse response) {
                return targetStatesSet.contains((Object)response.getConnectionAssignment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(GetDatabaseRegistrationRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseRegistration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(GetDatabaseRegistrationRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabaseRegistration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(GetDatabaseRegistrationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseRegistration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(BmcGenericWaiter waiter, GetDatabaseRegistrationRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse>(){

            @Override
            public GetDatabaseRegistrationResponse apply(GetDatabaseRegistrationRequest request) {
                return GoldenGateWaiters.this.client.getDatabaseRegistration(request);
            }
        }, (Predicate)new Predicate<GetDatabaseRegistrationResponse>(){

            @Override
            public boolean test(GetDatabaseRegistrationResponse response) {
                return targetStatesSet.contains((Object)response.getDatabaseRegistration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(BmcGenericWaiter waiter, GetDeploymentRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDeploymentRequest, GetDeploymentResponse>(){

            @Override
            public GetDeploymentResponse apply(GetDeploymentRequest request) {
                return GoldenGateWaiters.this.client.getDeployment(request);
            }
        }, (Predicate)new Predicate<GetDeploymentResponse>(){

            @Override
            public boolean test(GetDeploymentResponse response) {
                return targetStatesSet.contains((Object)response.getDeployment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(GetDeploymentBackupRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeploymentBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(GetDeploymentBackupRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeploymentBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(GetDeploymentBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeploymentBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(BmcGenericWaiter waiter, GetDeploymentBackupRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDeploymentBackupRequest, GetDeploymentBackupResponse>(){

            @Override
            public GetDeploymentBackupResponse apply(GetDeploymentBackupRequest request) {
                return GoldenGateWaiters.this.client.getDeploymentBackup(request);
            }
        }, (Predicate)new Predicate<GetDeploymentBackupResponse>(){

            @Override
            public boolean test(GetDeploymentBackupResponse response) {
                return targetStatesSet.contains((Object)response.getDeploymentBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeploymentUpgradeRequest, GetDeploymentUpgradeResponse> forDeploymentUpgrade(GetDeploymentUpgradeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeploymentUpgrade(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeploymentUpgradeRequest, GetDeploymentUpgradeResponse> forDeploymentUpgrade(GetDeploymentUpgradeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeploymentUpgrade(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeploymentUpgradeRequest, GetDeploymentUpgradeResponse> forDeploymentUpgrade(GetDeploymentUpgradeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeploymentUpgrade(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeploymentUpgradeRequest, GetDeploymentUpgradeResponse> forDeploymentUpgrade(BmcGenericWaiter waiter, GetDeploymentUpgradeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDeploymentUpgradeRequest, GetDeploymentUpgradeResponse>(){

            @Override
            public GetDeploymentUpgradeResponse apply(GetDeploymentUpgradeRequest request) {
                return GoldenGateWaiters.this.client.getDeploymentUpgrade(request);
            }
        }, (Predicate)new Predicate<GetDeploymentUpgradeResponse>(){

            @Override
            public boolean test(GetDeploymentUpgradeResponse response) {
                return targetStatesSet.contains((Object)response.getDeploymentUpgrade().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return GoldenGateWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

